/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableWorkspaceListener;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListenerManager;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.wtp.core.modules.IJBTModule;
import org.osgi.service.prefs.BackingStoreException;

public class SingleDeployableFactory
extends ModuleFactoryDelegate {
    public static final String FACTORY_ID = "org.jboss.ide.eclipse.as.core.singledeployablefactory";
    private static SingleDeployableFactory factDelegate;
    public static final String MODULE_TYPE = "jboss.singlefile";
    public static final String VERSION = "1.0";
    private static final String PREFERENCE_KEY = "org.jboss.ide.eclipse.as.core.singledeployable.deployableList";
    private static final String STORED_IN_PROJECTS_PREF_KEY = "org.jboss.ide.eclipse.as.core.singledeployable.storedInProjectKey";
    private static final String DELIM = "\r";
    private static ModuleFactory factory;
    private HashMap<IPath, IModule> moduleIdToModule;
    private HashMap<IModule, SingleDeployableModuleDelegate> moduleToDelegate;
    private IResourceChangeListener resourceListener = new FileDeletionListener();
    private SingleDeployableWorkspaceListener workspaceChangeListener;

    public static SingleDeployableFactory getFactory() {
        if (factDelegate == null) {
            ModuleFactory[] factories = ServerPlugin.getModuleFactories();
            int i = 0;
            while (i < factories.length) {
                ModuleFactoryDelegate o;
                if (factories[i].getId().equals(FACTORY_ID) && (o = factories[i].getDelegate((IProgressMonitor)new NullProgressMonitor())) instanceof SingleDeployableFactory) {
                    factory = factories[i];
                    factDelegate = (SingleDeployableFactory)o;
                    return factDelegate;
                }
                ++i;
            }
        }
        return factDelegate;
    }

    public static boolean makeDeployable(IResource resource) {
        return SingleDeployableFactory.makeDeployable(resource.getFullPath());
    }

    public static boolean makeDeployable(IProject project, IPath[] workspaceRelative) {
        boolean ret = true;
        int i = 0;
        while (i < workspaceRelative.length) {
            ret &= SingleDeployableFactory.getFactory().addModule(workspaceRelative[i]);
            ++i;
        }
        SingleDeployableFactory.getFactory().saveDeployableList(project.getName());
        return ret;
    }

    public static boolean makeDeployable(IPath workspaceAbsolute) {
        boolean ret = SingleDeployableFactory.getFactory().addModule(workspaceAbsolute);
        SingleDeployableFactory.getFactory().saveDeployableList(workspaceAbsolute.segment(0));
        return ret;
    }

    public static void unmakeDeployable(IResource resource) {
        SingleDeployableFactory.unmakeDeployable(resource.getFullPath());
    }

    public static void unmakeDeployable(IPath workspaceRelative) {
        SingleDeployableFactory.getFactory().removeModule(workspaceRelative);
        SingleDeployableFactory.getFactory().saveDeployableList(workspaceRelative.segment(0));
    }

    public static void unmakeDeployable(IProject project, IPath[] workspaceRelative) {
        int i = 0;
        while (i < workspaceRelative.length) {
            SingleDeployableFactory.getFactory().removeModule(workspaceRelative[i]);
            ++i;
        }
        SingleDeployableFactory.getFactory().saveDeployableList(project.getName());
    }

    public static IModule findModule(IResource resource) {
        return SingleDeployableFactory.findModule(resource.getFullPath());
    }

    public static IModule findModule(IPath workspaceRelative) {
        return SingleDeployableFactory.getFactory().getModule(workspaceRelative);
    }

    public SingleDeployableFactory() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 5);
    }

    public void initialize() {
        this.moduleIdToModule = new HashMap();
        this.moduleToDelegate = new HashMap();
        this.registerListener();
        String storeInProjects = JBossServerCorePlugin.getDefault().getPluginPreferences().getString(STORED_IN_PROJECTS_PREF_KEY);
        if (storeInProjects != null) {
            this.projectLoad();
        } else {
            this.legacyLoad();
        }
    }

    protected void projectLoad() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        String qualifier = "org.jboss.ide.eclipse.as.core";
        int i = 0;
        while (i < allProjects.length) {
            ProjectScope context = new ProjectScope(allProjects[i]);
            IEclipsePreferences node = context.getNode(qualifier);
            String val = node.get(PREFERENCE_KEY, "");
            String[] paths = val.split("\n");
            int j = 0;
            while (j < paths.length) {
                if (!paths[j].trim().equals("")) {
                    IPath tmp = new Path(allProjects[i].getName()).append(paths[j]).makeAbsolute();
                    this.addModule(tmp);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void legacyLoad() {
        String files = JBossServerCorePlugin.getDefault().getPluginPreferences().getString(PREFERENCE_KEY);
        if (files.equals("")) {
            return;
        }
        String[] files2 = files.split(DELIM);
        int i = 0;
        while (i < files2.length) {
            this.addModule((IPath)new Path(files2[i]));
            ++i;
        }
    }

    public void saveDeployableList(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String list = "";
        Set<IPath> allPaths = this.moduleIdToModule.keySet();
        for (IPath tmp : allPaths) {
            String firstSegment = tmp.segment(0);
            if (firstSegment == null || !firstSegment.equals(projectName)) continue;
            list = String.valueOf(list) + tmp.removeFirstSegments(1).makeRelative() + "\n";
        }
        String qualifier = "org.jboss.ide.eclipse.as.core";
        if (project.exists() && project.isAccessible()) {
            ProjectScope context = new ProjectScope(project);
            IEclipsePreferences node = context.getNode(qualifier);
            if (node != null) {
                node.put(PREFERENCE_KEY, list);
            }
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                JBossServerCorePlugin.log(e);
            }
        }
    }

    public void legacySaveDeployableList() {
        Iterator<IPath> i = this.moduleIdToModule.keySet().iterator();
        String val = "";
        while (i.hasNext()) {
            val = String.valueOf(val) + i.next().toString() + DELIM;
        }
        JBossServerCorePlugin.getDefault().getPluginPreferences().setValue(PREFERENCE_KEY, val);
        JBossServerCorePlugin.getDefault().savePluginPreferences();
    }

    protected void registerListener() {
        UnitedServerListenerManager.getDefault().addListener(new UnitedServerListener(){

            public void publishFinished(IServer server, IStatus status) {
                SingleDeployableFactory.this.cleanUnusedModules();
            }
        });
        this.workspaceChangeListener = new SingleDeployableWorkspaceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.workspaceChangeListener);
    }

    protected void cleanUnusedModules() {
        IModule[] mods = this.getModules();
        IServer[] servers = ServerCore.getServers();
        ArrayList<IModule> usedMods = new ArrayList<IModule>();
        int i = 0;
        while (i < servers.length) {
            IModule[] modsInner = servers[i].getModules();
            int j = 0;
            while (j < modsInner.length) {
                if (modsInner[j].getModuleType().getId().equals(MODULE_TYPE) && !usedMods.contains(modsInner[j])) {
                    usedMods.add(modsInner[j]);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < mods.length) {
            if (!usedMods.contains(mods[i])) {
                SingleDeployableModuleDelegate delegate = (SingleDeployableModuleDelegate)((Object)mods[i].loadAdapter(SingleDeployableModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor()));
                if (!delegate.getGlobalSourcePath().toFile().exists()) {
                    SingleDeployableFactory.unmakeDeployable(delegate.getWorkspaceRelativePath());
                }
            } else {
                usedMods.remove(mods[i]);
            }
            ++i;
        }
        for (IModule tmp : usedMods) {
            SingleDeployableFactory.makeDeployable((IPath)new Path(tmp.getName()));
        }
    }

    public IModule getModule(IPath path) {
        return this.moduleIdToModule.get(path.makeAbsolute());
    }

    public IModule findModule(String id) {
        IModule s = super.findModule(id);
        if (s == null && !new Path(id).isAbsolute()) {
            s = super.findModule(String.valueOf('/') + id);
        }
        return s;
    }

    protected boolean addModule(IPath path) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource != null && resource.exists()) {
            IModule module = this.createModule(path.toString(), path.toString(), MODULE_TYPE, VERSION, resource.getProject());
            this.moduleIdToModule.put(path, module);
            this.moduleToDelegate.put(module, new SingleDeployableModuleDelegate(path));
            return true;
        }
        return false;
    }

    protected void removeModule(IPath path) {
        IModule mod = this.moduleIdToModule.get(path);
        this.moduleIdToModule.remove(path);
        this.moduleToDelegate.remove(mod);
    }

    public IModule[] getModules() {
        Collection<IModule> c = this.moduleIdToModule.values();
        return c.toArray(new IModule[c.size()]);
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        return this.moduleToDelegate.get(module);
    }

    public class FileDeletionListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        public ArrayList<IPath> list = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            block5: {
                try {
                    ArrayList<IPath> clone;
                    if (event.getDelta() == null) break block5;
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    if (this.list.size() <= 0) break block5;
                    FileDeletionListener fileDeletionListener = this;
                    synchronized (fileDeletionListener) {
                        clone = new ArrayList<IPath>();
                        clone.addAll(this.list);
                        this.list.clear();
                    }
                    UndeployFromServerJob job = new UndeployFromServerJob(clone);
                    job.schedule();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }

        public boolean visit(IResourceDelta delta) {
            if ((delta.getKind() & 2) != 0 && delta.getResource() != null && delta.getResource().getFullPath() != null && SingleDeployableFactory.this.getModule(delta.getResource().getFullPath()) != null && !this.list.contains(delta.getResource().getFullPath())) {
                this.list.add(delta.getResource().getFullPath());
            }
            return true;
        }
    }

    public class SingleDeployableModuleDelegate
    extends ModuleDelegate
    implements IJBTModule {
        private IPath global;
        private IPath workspaceRelative;
        private IResource resource;

        public SingleDeployableModuleDelegate(IPath workspaceRelative) {
            this.workspaceRelative = workspaceRelative;
            this.resource = ResourcesPlugin.getWorkspace().getRoot().findMember(workspaceRelative);
            this.global = this.resource.getLocation();
        }

        public IModule[] getChildModules() {
            return new IModule[0];
        }

        public IModuleResource[] members() throws CoreException {
            if (this.isBinary() && this.resource instanceof IFile) {
                IModuleResource resource2 = ModuleResourceUtil.createResource((IResource)this.resource);
                return new IModuleResource[]{resource2};
            }
            if (!this.isBinary() && this.resource instanceof IContainer) {
                IModuleResource[] resource2 = ModuleResourceUtil.createChildrenResources((IContainer)((IContainer)this.resource), (IPath)new Path("/"));
                return resource2;
            }
            return new IModuleResource[0];
        }

        public IStatus validate() {
            return Status.OK_STATUS;
        }

        public IPath getGlobalSourcePath() {
            return this.global;
        }

        public IPath getWorkspaceRelativePath() {
            return this.workspaceRelative;
        }

        public IModule[] getModules() {
            return new IModule[0];
        }

        public String getURI(IModule module) {
            return null;
        }

        public boolean isBinary() {
            boolean b = this.global.toFile().exists() && this.global.toFile().isFile();
            return b;
        }
    }

    public static class UndeployFromServerJob
    extends Job {
        private ArrayList<IPath> paths;
        private boolean removeFromFactory;

        public UndeployFromServerJob(ArrayList<IPath> paths) {
            this(paths, true);
        }

        public UndeployFromServerJob(ArrayList<IPath> paths, boolean removeFromFactory) {
            super(Messages.UndeploySingleFilesJob);
            this.paths = paths;
            this.removeFromFactory = removeFromFactory;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IServer[] allServers = ServerCore.getServers();
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 4, Messages.SingleFileUndeployFailed, null);
            for (IPath next : this.paths) {
                IModule mod = SingleDeployableFactory.getFactory().getModule(next);
                if (mod == null) continue;
                boolean removedFromAllServers = true;
                int j = 0;
                while (j < allServers.length) {
                    List<IModule> l = Arrays.asList(allServers[j].getModules());
                    if (l.contains(mod)) {
                        Status s;
                        try {
                            IServerWorkingCopy copy = allServers[j].createWorkingCopy();
                            ServerUtil.modifyModules((IServerWorkingCopy)copy, (IModule[])new IModule[0], (IModule[])new IModule[]{mod}, (IProgressMonitor)new NullProgressMonitor());
                            s = copy.save(false, (IProgressMonitor)new NullProgressMonitor());
                            new PublishServerJob((IServer)s).schedule();
                        }
                        catch (CoreException ce) {
                            removedFromAllServers = false;
                            s = new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.SingleFileUndeployFailed2, (Object)next, (Object)allServers[j].getName()), (Throwable)ce);
                            ms.add((IStatus)s);
                        }
                    }
                    ++j;
                }
                if (!this.removeFromFactory || !removedFromAllServers) continue;
                SingleDeployableFactory.unmakeDeployable(next);
            }
            return ms.getChildren().length == 0 ? Status.OK_STATUS : ms;
        }
    }
}

