/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.extendedproperties;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IServerModeDetails;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossDefaultLaunchArguments;

public class JBoss70DefaultLaunchArguments
extends JBossDefaultLaunchArguments {
    public JBoss70DefaultLaunchArguments(IServer s) {
        super(s);
    }

    public JBoss70DefaultLaunchArguments(IRuntime rt) {
        super(rt);
    }

    @Override
    public String getStartDefaultProgramArgs() {
        return "-mp \"" + this.getServerHome().append("modules").toString() + "\"" + this.getLoggingProgramArg() + " " + this.getJaxpProvider() + " " + this.getJaxpProvider() + " " + "org.jboss.as.standalone";
    }

    protected String getJaxpProvider() {
        return "-jaxpmodule javax.xml.jaxp-provider";
    }

    protected String getLoggingProgramArg() {
        return " -logmodule org.jboss.logmanager";
    }

    @Override
    public String getStartDefaultVMArgs() {
        return String.valueOf(this.getProgramNameArgs()) + this.getServerFlagArgs() + this.getMemoryArgs() + this.getResolverWarning() + this.getJavaFlags() + this.getJBossJavaFlags();
    }

    @Override
    protected String getMemoryArgs() {
        return "-Xms64m -Xmx512m -XX:MaxPermSize=256m ";
    }

    protected String getResolverWarning() {
        return "-Dorg.jboss.resolver.warning=true ";
    }

    @Override
    protected String getJavaFlags() {
        return this.getJavaFlags(true);
    }

    @Override
    protected String getJBossJavaFlags() {
        IPath serverHome = this.getServerHome();
        IServerModeDetails det = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)this.server, IServerModeDetails.class);
        String basedir = det.getProperty("PROP_SERVER_BASE_DIR_ABS");
        Path base = new Path(basedir);
        IPath bootLog = base.append("log").append("boot.log");
        IPath logConfig = base.append("configuration").append("logging.properties");
        String ret = "-Djava.awt.headless=true \"-Dorg.jboss.boot.log.file=" + bootLog.toString() + "\"" + " " + "\"" + "-D" + "logging.configuration" + "=" + "file:" + logConfig.toString() + "\"" + " " + "\"" + "-D" + "jboss.home.dir" + "=" + serverHome.toString() + "\"" + " ";
        return ret;
    }
}

