/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.IServerModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;

public abstract class AbstractJBoss7ModuleStateVerifier
extends AbstractSubsystemController
implements IModuleStateController,
IServerModuleStateVerifier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitModuleStarted(IServer server, IModule[] module, final int maxDelay) {
        final NullProgressMonitor monitor = new NullProgressMonitor();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(maxDelay);
                }
                catch (InterruptedException ie) {
                    return;
                }
                NullProgressMonitor nullProgressMonitor = monitor;
                synchronized (nullProgressMonitor) {
                    monitor.setCanceled(true);
                }
            }
        };
        t.start();
        this.waitModuleStarted(server, module, (IProgressMonitor)monitor);
        NullProgressMonitor nullProgressMonitor = monitor;
        synchronized (nullProgressMonitor) {
            if (!monitor.isCanceled()) {
                t.interrupt();
            }
        }
    }

    public boolean isModuleStarted(IServer server, IModule[] module, IProgressMonitor monitor) {
        return this.getModuleState(server, module, monitor) == 2;
    }

    public int getModuleState(IServer server, IModule[] module, IProgressMonitor monitor) {
        try {
            return this.getRootModuleState(server, module[0], this.getDeploymentName(server, module[0]), monitor);
        }
        catch (Exception e) {
            String er = "Error occurred while checking module state for {0} on server {1}";
            Status s = new Status(2, "org.jboss.ide.eclipse.as.core", NLS.bind((String)er, (Object)module[0].getName(), (Object)server.getName()), (Throwable)e);
            ServerLogger.getDefault().log(server, (IStatus)s);
            return 0;
        }
    }

    private String getDeploymentName(IServer server, IModule module) throws Exception {
        return this.getDeploymentOutputName(server, module);
    }

    private String getDeploymentOutputName(IServer server, IModule module) {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (beh != null) {
            try {
                IModule[] moduleToTest = new IModule[]{module};
                IModuleDeployPathController controller = (IModuleDeployPathController)beh.getController("moduleDeployPath");
                return controller.getOutputName(moduleToTest);
            }
            catch (CoreException ce) {
                return null;
            }
        }
        return null;
    }

    private boolean isRootModuleStarted(IServer server, IModule root, String deploymentName, IProgressMonitor monitor) throws Exception {
        return this.getRootModuleState(server, root, deploymentName, monitor) == 2;
    }

    public void waitModuleStarted(IServer server, IModule[] module, IProgressMonitor monitor) {
        if (module.length == 0 || module[0] == null) {
            return;
        }
        try {
            String deploymentName = this.getDeploymentName(server, module[0]);
            boolean waitedOnce = false;
            while (!monitor.isCanceled()) {
                boolean done = this.isRootModuleStarted(server, module[0], deploymentName, monitor);
                if (done) {
                    return;
                }
                if (!waitedOnce) {
                    String info = "Module {0} on {1} not yet fully deployed. Waiting...";
                    Status s = new Status(1, "org.jboss.ide.eclipse.as.core", NLS.bind((String)info, (Object)module[0].getName(), (Object)server.getName()), null);
                    ServerLogger.getDefault().log(server, (IStatus)s);
                }
                waitedOnce = true;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException info) {
                    // empty catch block
                }
            }
            String warning = "Module {0} on {1} still not ready to be shown in browser. Aborting delay.";
            Status s = new Status(2, "org.jboss.ide.eclipse.as.core", NLS.bind((String)warning, (Object)module[0].getName(), (Object)server.getName()), null);
            ServerLogger.getDefault().log(server, (IStatus)s);
        }
        catch (Exception e) {
            String er = "Error occurred while waiting for {0} to start on server {1}";
            Status s = new Status(2, "org.jboss.ide.eclipse.as.core", NLS.bind((String)er, (Object)module[0].getName(), (Object)server.getName()), (Throwable)e);
            ServerLogger.getDefault().log(server, (IStatus)s);
        }
    }

    public int stopModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        return this.changeModuleStateTo(module, 4, monitor);
    }

    public int startModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        return this.changeModuleStateTo(module, 2, monitor);
    }

    protected abstract int getRootModuleState(IServer var1, IModule var2, String var3, IProgressMonitor var4) throws Exception;

    public abstract int changeModuleStateTo(IModule[] var1, int var2, IProgressMonitor var3) throws CoreException;

    public int restartModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        this.stopModule(module, monitor);
        return this.startModule(module, monitor);
    }

    public boolean canRestartModule(IModule[] module) {
        return module.length == 1;
    }

    public int getModuleState(IModule[] module, IProgressMonitor monitor) {
        return this.getModuleState(this.getServer(), module, monitor);
    }

    public boolean isModuleStarted(IModule[] module, IProgressMonitor monitor) {
        return this.isModuleStarted(this.getServer(), module, monitor);
    }

    public void waitModuleStarted(IModule[] module, IProgressMonitor monitor) {
        this.waitModuleStarted(this.getServer(), module, monitor);
    }

    public void waitModuleStarted(IModule[] module, int maxDelay) {
        this.waitModuleStarted(this.getServer(), module, maxDelay);
    }
}

