/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.ServerHotCodeReplaceListener;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.jmx.core.IConnectionFacade;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;

public class ClassCollectingHCRListener
extends ServerHotCodeReplaceListener {
    public ClassCollectingHCRListener(IServer server, ILaunch launch) {
        super(server, launch);
    }

    protected void postPublish(IJavaDebugTarget target, IModule[] modules) {
        IServer server = this.getServer();
        this.waitModulesStarted(modules);
        this.removeBreakpoints(target);
        this.executeJMXGarbageCollection(server, modules);
        this.addBreakpoints(target);
    }

    private void addBreakpoints(IJavaDebugTarget target) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            target.breakpointAdded(breakpoints[i]);
            ++i;
        }
    }

    private void removeBreakpoints(IJavaDebugTarget target) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            target.breakpointRemoved(breakpoints[i], null);
            ++i;
        }
    }

    protected void executeJMXGarbageCollection(IServer server, IModule[] modules) {
        IConnectionFacade jbs = (IConnectionFacade)server.loadAdapter(IConnectionFacade.class, null);
        if (jbs instanceof IConnectionFacade) {
            IConnectionWrapper wrap = jbs.getJMXConnection();
            try {
                if (!wrap.isConnected()) {
                    wrap.connect();
                }
                wrap.run(new IJMXRunnable(){

                    public void run(MBeanServerConnection connection) throws Exception {
                        Object ret = connection.invoke(new ObjectName("java.lang:type=Memory"), "gc", new Object[0], new String[0]);
                        Object ret2 = connection.invoke(new ObjectName("java.lang:type=Memory"), "gc", new Object[0], new String[0]);
                    }
                });
            }
            catch (IOException | JMXException e) {
                JBossServerCorePlugin.log(StatusFactory.errorStatus((String)"org.jboss.ide.eclipse.as.core", (String)"Error executing garbage collection on server after publish", (Throwable)e));
            }
        }
    }
}

