/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilterProvider;
import org.jboss.ide.eclipse.as.core.server.internal.UpdateModuleStateJob;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7DeploymentResult;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.IncrementalDeploymentManagerService;
import org.jboss.ide.eclipse.as.management.core.IncrementalManagementModel;
import org.jboss.ide.eclipse.as.management.core.JBoss7DeploymentState;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.management.core.JBoss7ServerState;
import org.jboss.ide.eclipse.as.wtp.core.modules.filter.patterns.ComponentModuleInclusionFilterUtility;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPrimaryPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishControllerDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.util.PublishControllerUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.LocalZippedModulePublishRunner;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.tools.as.core.server.controllable.internal.DeployableServerBehavior;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;

public class ManagementPublishController
extends AbstractSubsystemController
implements IPublishController,
IPrimaryPublishController {
    private IJBoss7ManagerService service;
    private AS7ManagementDetails managementDetails;
    private IModuleStateController moduleStateController;
    private boolean moduleStateControllerLoadFailed = false;
    private IModuleDeployPathController moduleDeployPathController;
    private static final IStatus CANCEL_STATUS = new Status(8, "ASWTPToolsPlugin.PLUGIN_ID", "Publish Canceled");
    private static final IStatus[] CANCEL_STATUS_ARR = new IStatus[]{CANCEL_STATUS};

    private IJBoss7ManagerService getService() throws JBoss7ManangerException {
        if (this.service == null) {
            this.service = JBoss7ManagerUtil.getService((IServer)this.getServer());
            this.managementDetails = new AS7ManagementDetails(this.getServer());
        }
        return this.service;
    }

    public IStatus validate() {
        try {
            IStatus sup = super.validate();
            if (!sup.isOK()) {
                return sup;
            }
            this.getDeployPathController();
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    private IStatus isRunning() {
        if (this.getServer().getServerState() != 2) {
            return Status.CANCEL_STATUS;
        }
        Exception e = null;
        try {
            JBoss7ServerState serverState = null;
            serverState = this.getService().getServerState((IAS7ManagementDetails)this.managementDetails);
            if (serverState == JBoss7ServerState.RUNNING) {
                return Status.OK_STATUS;
            }
        }
        catch (Exception e2) {
            e = e2;
        }
        return new Status(4, "org.jboss.ide.eclipse.as.core", "JBossTools is unable to verify that the server is up and responsive.", (Throwable)e);
    }

    public IStatus canPublish() {
        return this.canPublishInternal(false);
    }

    private IStatus canPublishInternal(boolean checkServerResponds) {
        IStatus isRunningStatus;
        boolean started;
        boolean bl = started = this.getServer().getServerState() == 2;
        if (!started) {
            return Status.CANCEL_STATUS;
        }
        if (checkServerResponds && !(isRunningStatus = this.isRunning()).isOK()) {
            return isRunningStatus;
        }
        return this.validate();
    }

    public boolean canPublishModule(IModule[] module) {
        return this.canPublishInternal(false).isOK();
    }

    public void publishStart(IProgressMonitor monitor) throws CoreException {
        IStatus canPublish = this.canPublishInternal(true);
        if (!canPublish.isOK() && this.canPublish().getSeverity() != 8) {
            throw new CoreException(canPublish);
        }
    }

    public void publishFinish(IProgressMonitor monitor) throws CoreException {
        IServer s = this.getServer();
        ((Server)s).setServerPublishState(this.getUpdatedPublishState(s));
        IModuleStateController c = this.getModuleStateController();
        if (c != null && this.getServer().getServerState() == 2) {
            new UpdateModuleStateJob(c, this.getServer(), true, 15000).schedule(5000L);
        }
    }

    protected IModuleStateController getModuleStateController() throws CoreException {
        if (this.moduleStateController == null && !this.moduleStateControllerLoadFailed) {
            try {
                DeployableServerBehavior o = (DeployableServerBehavior)((Object)this.getServer().loadAdapter(DeployableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor()));
                this.moduleStateController = (IModuleStateController)o.getController("modules");
            }
            catch (CoreException ce) {
                this.moduleStateControllerLoadFailed = true;
            }
        }
        return this.moduleStateController;
    }

    protected IModuleDeployPathController getDeployPathController() throws CoreException {
        if (this.moduleDeployPathController == null) {
            this.moduleDeployPathController = (IModuleDeployPathController)this.findDependencyFromBehavior("moduleDeployPath");
        }
        return this.moduleDeployPathController;
    }

    protected boolean shouldMinimizeRedeployments() {
        boolean debugMode = "debug".equals(this.getServer().getMode());
        Object o = this.getControllableBehavior().getSharedData("AbstractStartJavaServerLaunchDelegate.HotCodeReplaceOverridden");
        return debugMode && o instanceof Boolean && (Boolean)o != false;
    }

    public int publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        IStatus canPublish = this.canPublishInternal(true);
        if (!canPublish.isOK() && canPublish.getSeverity() != 8) {
            Status error = new Status(4, "org.jboss.ide.eclipse.as.core", "The server must be started to publish.");
            throw new CoreException((IStatus)error);
        }
        if (canPublish.getSeverity() == 8) {
            return this.getServer().getModulePublishState(module);
        }
        ((Server)this.getServer()).setModuleState(module, 0);
        IPublishControllerDelegate delegate = PublishControllerUtil.findDelegatePublishController((IServer)this.getServer(), (IModule[])module, (boolean)true);
        if (delegate != null) {
            return delegate.publishModule(kind, deltaKind, module, monitor);
        }
        if (module.length > 1) {
            return 1;
        }
        int publishType = PublishControllerUtil.getDeepPublishType((IServer)this.getServer(), (IModule)module[0], (int)kind, (int)deltaKind);
        if (publishType == 0) {
            return 1;
        }
        if (publishType == 1) {
            if (this.shouldMinimizeRedeployments()) {
                return this.getServer().getModulePublishState(module);
            }
            if (this.getService().supportsIncrementalDeployment()) {
                return this.incrementalPublish(module[0], monitor);
            }
        }
        if (publishType == 3) {
            return this.removeModule(module, monitor);
        }
        monitor.setTaskName("Publishing " + module[0].getName());
        boolean isBinaryObject = ServerModelUtilities.isBinaryModule((IModule[])module);
        IModuleResource[] resources = ModuleResourceUtil.getMembers((IModule)module[0]);
        if (isBinaryObject && resources.length > 1) {
            return this.multiResourceBinaryFullPublish();
        }
        File toTransfer = this.getFullPublishFilesToTransfer(module, monitor);
        if (toTransfer != null) {
            String tName = toTransfer.getName();
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 1644298251, "Deployment of module " + module[0].getName() + " has failed", null);
            IProgressMonitor transferMonitor = ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)800);
            transferMonitor.beginTask("Transfering " + tName, 100);
            JBoss7DeploymentState state = this.getService().getDeploymentState((IAS7ManagementDetails)this.managementDetails, toTransfer.getName());
            if (state != JBoss7DeploymentState.NOT_FOUND) {
                monitor.setTaskName("Undeploying: " + tName);
                IJBoss7DeploymentResult removeResult = this.getService().undeploySync((IAS7ManagementDetails)this.managementDetails, tName, true, ProgressMonitorUtil.submon((IProgressMonitor)transferMonitor, (int)5));
                ms.add(removeResult.getStatus());
            } else {
                transferMonitor.worked(5);
            }
            monitor.setTaskName("Transfering: " + tName);
            IJBoss7ManagerService serv = this.getService();
            IJBoss7DeploymentResult result = null;
            if (serv.supportsIncrementalDeployment()) {
                IncrementalDeploymentManagerService serv2 = (IncrementalDeploymentManagerService)serv;
                String[] explodePaths = isBinaryObject ? new String[]{} : this.getExplodePaths(module);
                result = serv2.deploySync((IAS7ManagementDetails)this.managementDetails, tName, toTransfer, true, explodePaths, ProgressMonitorUtil.submon((IProgressMonitor)transferMonitor, (int)95));
            } else {
                result = this.getService().deploySync((IAS7ManagementDetails)this.managementDetails, tName, toTransfer, true, ProgressMonitorUtil.submon((IProgressMonitor)transferMonitor, (int)95));
            }
            IStatus s = result.getStatus();
            ms.add(s);
            if (ms.isOK()) {
                return 1;
            }
            ServerLogger.getDefault().log(this.getServer(), (IStatus)ms);
            transferMonitor.done();
            return 3;
        }
        Status s = new Status(4, "org.jboss.ide.eclipse.as.core", "Error deploying via management api: No file to deploy: " + module[module.length - 1].getName());
        JBossServerCorePlugin.getDefault().getLog().log((IStatus)s);
        return 0;
    }

    private File getFullPublishFilesToTransfer(IModule[] module, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName("Zipping module: " + module[0].getName());
        IProgressMonitor submon = ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)200);
        File file = this.zipLocally(module[0], 2, submon);
        return file;
    }

    private int multiResourceBinaryFullPublish() throws CoreException {
        return this.unsupported("Unsupported publish of multi-resource binary module over management");
    }

    private int unsupported(String s) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", s));
    }

    private String[] getExplodePaths(IModule[] module) throws CoreException {
        String rootModName = this.getDeploymentOutputName(this.getServer(), module[0]);
        ArrayList<String> toExplode = new ArrayList<String>();
        toExplode.add(rootModName);
        return toExplode.toArray(new String[toExplode.size()]);
    }

    private String getDeploymentOutputName(IServer server, IModule module) throws CoreException {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (beh != null) {
            IModule[] moduleToTest = new IModule[]{module};
            IModuleDeployPathController controller = this.getDeployPathController();
            return controller.getOutputName(moduleToTest);
        }
        return null;
    }

    public void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 100);
        monitor.done();
    }

    private File zipLocally(IModule module, int publishType, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Zip module " + module.getName(), 100);
        IPath localTempLocation = this.getMetadataTemporaryLocation(this.getServer());
        String name = this.getDeploymentOutputName(this.getServer(), module);
        IPath tmpArchive = localTempLocation.append(name);
        LocalZippedModulePublishRunner runner = this.createZippedRunner(module, tmpArchive);
        IStatus result = null;
        if (publishType == 2) {
            result = runner.fullPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
        } else if (publishType == 1) {
            result = runner.incrementalPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
        }
        monitor.done();
        if (result != null && result.isOK() && tmpArchive.toFile().exists()) {
            return tmpArchive.toFile();
        }
        throw new CoreException(result);
    }

    private IPath getMetadataTemporaryLocation(IServer server) {
        IPath deployRoot = JBossServerCorePlugin.getServerStateLocation(server).append("tempRemoteDeploy").makeAbsolute();
        deployRoot.toFile().mkdirs();
        return deployRoot;
    }

    private IModulePathFilterProvider getModulePathFilterProvider() {
        return new IModulePathFilterProvider(){

            public IModulePathFilter getFilter(IServer server, IModule[] module) {
                return ComponentModuleInclusionFilterUtility.findDefaultModuleFilter((IModule)module[module.length - 1]);
            }
        };
    }

    private LocalZippedModulePublishRunner createZippedRunner(IModule m, IPath p) {
        return new LocalZippedModulePublishRunner(this.getServer(), m, p, this.getModulePathFilterProvider());
    }

    public int transferBuiltModule(IModule[] module, IPath srcFile, IProgressMonitor monitor) throws CoreException {
        String name = this.getDeploymentOutputName(this.getServer(), module[0]);
        IJBoss7DeploymentResult removeResult = this.getService().undeploySync((IAS7ManagementDetails)this.managementDetails, name, true, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)10));
        IStatus status1 = removeResult.getStatus();
        IJBoss7DeploymentResult result = this.getService().deploySync((IAS7ManagementDetails)this.managementDetails, name, srcFile.toFile(), true, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
        IStatus status2 = result.getStatus();
        return status1.isOK() && status2.isOK() ? 1 : 0;
    }

    public int removeModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        String name = this.getDeploymentOutputName(this.getServer(), module[0]);
        IJBoss7DeploymentResult removeResult = this.getService().undeploySync((IAS7ManagementDetails)this.managementDetails, name, true, monitor);
        IStatus result = removeResult.getStatus();
        if (result.isOK()) {
            return 1;
        }
        return 3;
    }

    private int getUpdatedPublishState(IServer server) {
        IModule[] modules = server.getModules();
        boolean allpublished = true;
        int i = 0;
        while (i < modules.length) {
            if (server.getModulePublishState(new IModule[]{modules[i]}) != 1) {
                allpublished = false;
            }
            ++i;
        }
        if (allpublished) {
            return 1;
        }
        return 2;
    }

    protected int incrementalPublish(IModule module, IProgressMonitor monitor) throws CoreException {
        IncrementalDeploymentManagerService service = (IncrementalDeploymentManagerService)this.getService();
        return new IncrementalManagementPublishRunner().incrementalPublish(module, service, monitor);
    }

    protected IModuleResourceDelta[] getDeltaForModule(IModule[] module) {
        IModuleResourceDelta[] deltas = ((Server)this.getServer()).getPublishedResourceDelta(module);
        return deltas;
    }

    private class IncrementalManagementPublishRunner {
        private IncrementalManagementPublishRunner() {
        }

        public int incrementalPublish(IModule module, IncrementalDeploymentManagerService service, IProgressMonitor monitor) throws CoreException {
            monitor.beginTask("Incremental Publish", 200);
            String rootName = ManagementPublishController.this.getDeploymentOutputName(ManagementPublishController.this.getServer(), module);
            IModule[] asArr = new IModule[]{module};
            IModuleResourceDelta[] delta = ManagementPublishController.this.getDeltaForModule(asArr);
            ManagementDouble dub = this.traverseDelta(delta, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            IncrementalManagementModel model = new IncrementalManagementModel();
            model.setDeploymentChanges(rootName, dub.changedContent, dub.removedContent);
            ArrayList deepModules = ServerModelUtilities.getDeepChildren((IServer)ManagementPublishController.this.getServer(), (IModule[])asArr);
            for (IModule[] m2 : deepModules) {
                delta = ManagementPublishController.this.getDeltaForModule(m2);
                dub = this.traverseDelta(delta, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                IPath rel = ServerModelUtilities.getRootModuleRelativePath((IServerAttributes)ManagementPublishController.this.getServer(), (IModule[])m2);
                String relative = rel.removeTrailingSeparator().toString();
                model.addSubDeploymentChanges(rootName, relative, dub.changedContent, dub.removedContent);
            }
            IJBoss7DeploymentResult result = service.incrementalPublish((IAS7ManagementDetails)ManagementPublishController.this.managementDetails, rootName, model, true, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            IStatus s = result.getStatus();
            if (!s.isOK()) {
                ServerLogger.getDefault().log(ManagementPublishController.this.getServer(), s);
                return 3;
            }
            return 1;
        }

        private ManagementDouble traverseDelta(IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
            ManagementDouble ret = new ManagementDouble();
            int i = 0;
            while (i < delta.length) {
                this.traverseDelta(delta[i], ret, monitor);
                ++i;
            }
            return ret;
        }

        private void traverseDelta(IModuleResourceDelta delta, ManagementDouble ret, IProgressMonitor monitor) throws CoreException {
            IModuleResourceDelta[] childDeltas;
            if (monitor.isCanceled()) {
                return;
            }
            IModuleResource resource = delta.getModuleResource();
            int kind2 = delta.getKind();
            IPath absolutePath = resource.getModuleRelativePath().append(resource.getName());
            if (resource instanceof IModuleFile) {
                IModuleFile file = (IModuleFile)resource;
                File ioFile = ModuleResourceUtil.getFile((IModuleFile)file);
                if (kind2 == 3) {
                    ret.addRemovedContent(absolutePath.toString());
                } else if (kind2 != 0) {
                    ret.addChangedContent(absolutePath.toString(), ioFile.getAbsolutePath());
                }
            }
            int size = (childDeltas = delta.getAffectedChildren()) == null ? 0 : childDeltas.length;
            int i = 0;
            while (i < size) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.traverseDelta(childDeltas[i], ret, monitor);
                ++i;
            }
            if (kind2 == 3) {
                ret.addRemovedContent(absolutePath.toString());
            }
        }

        private class ManagementDouble {
            Map<String, String> changedContent = new HashMap<String, String>();
            List<String> removedContent = new ArrayList<String>();

            public void addChangedContent(String relativePath, String absoluteLocalPath) {
                this.changedContent.put(relativePath, absoluteLocalPath);
            }

            public void addRemovedContent(String relativePath) {
                if (!this.removedContent.contains(relativePath)) {
                    this.removedContent.add(relativePath);
                }
            }
        }
    }
}

