/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core.tree;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXCoreMessages;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.core.tree.NodeBuilder;
import org.jboss.tools.jmx.core.tree.ObjectNameNode;
import org.jboss.tools.jmx.core.tree.Root;

public class NodeUtils {
    private NodeUtils() {
    }

    public static ObjectNameNode findObjectNameNode(Node node, ObjectName objectName) {
        ObjectNameNode onNode;
        Assert.isNotNull((Object)node);
        if (node instanceof ObjectNameNode && (onNode = (ObjectNameNode)node).getObjectName().equals(objectName)) {
            return onNode;
        }
        Node[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            Node child = children[i];
            ObjectNameNode found = NodeUtils.findObjectNameNode(child, objectName);
            if (found != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    public static Root createObjectNameTree(final IConnectionWrapper connectionWrapper, final IProgressMonitor monitor) throws JMXException {
        final Root[] roots = new Root[1];
        connectionWrapper.run(new IJMXRunnable(){

            @Override
            public void run(MBeanServerConnection connection) throws Exception {
                monitor.beginTask(JMXCoreMessages.LoadMBeans, 1000);
                Set<ObjectName> beanInfo = connection.queryNames(new ObjectName("*:*"), null);
                roots[0] = NodeBuilder.createRoot(connectionWrapper);
                monitor.worked(100);
                if (beanInfo != null) {
                    SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)JMXCoreMessages.InspectMBeans, (int)beanInfo.size());
                    Iterator<ObjectName> iter = beanInfo.iterator();
                    while (iter.hasNext() && !monitor.isCanceled()) {
                        ObjectName on = iter.next();
                        NodeBuilder.addToTree(roots[0].getMBeansNode(), on, connection);
                        subMon.worked(1);
                    }
                }
                monitor.done();
            }
        });
        return roots[0];
    }
}

