/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.Trace;
import org.jboss.ide.eclipse.as.core.server.IServerConsoleWriter;
import org.jboss.ide.eclipse.as.core.util.ThreadUtils;
import org.jboss.ide.eclipse.as.rse.core.RSEFrameworkUtils;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;
import org.jboss.ide.eclipse.as.rse.core.xpl.ConnectAllSubsystemsUtil;
import org.jboss.ide.eclipse.as.wtp.core.console.ServerConsoleModel;

public class RSEHostShellModel {
    private static RSEHostShellModel instance;
    private HashMap<String, ServerShellModel> map = new HashMap();
    private IServerConsoleWriter listener;

    public static synchronized RSEHostShellModel getInstance() {
        if (instance == null) {
            instance = new RSEHostShellModel();
        }
        return instance;
    }

    RSEHostShellModel() {
        this.loadListeners();
    }

    private void loadListeners() {
        this.listener = ServerConsoleModel.getDefault().getConsoleWriter();
    }

    public ServerShellModel getModel(IServer server) {
        if (this.map.get(server.getId()) == null) {
            this.map.put(server.getId(), new ServerShellModel(server.getId()));
        }
        return this.map.get(server.getId());
    }

    public static IShellService findShellService(IServer server) throws CoreException {
        RSEFrameworkUtils.waitForFullInit();
        if (server != null) {
            String connectionName = RSEUtils.getRSEConnectionName((IServerAttributes)server);
            IHost host = RSEFrameworkUtils.findHost(connectionName);
            if (host == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "Host \"" + connectionName + "\" not found. Host may have been deleted or RSE model may not be completely loaded"));
            }
            new ConnectAllSubsystemsUtil(host).run((IProgressMonitor)new NullProgressMonitor());
            return RSEFrameworkUtils.findHostShellSystem(host);
        }
        throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "No Shell Service Found"));
    }

    public static class ServerShellModel {
        private String serverId;
        private IHostShell startupShell;
        private IHostShell singleUseShell;
        private IHostShellOutputListener listener;

        public ServerShellModel(String id) {
            this.serverId = id;
        }

        public IHostShell getStartupShell() {
            return this.startupShell;
        }

        public void resetStartupShell() {
            if (this.startupShell != null && this.startupShell.isActive()) {
                this.startupShell.exit();
                this.startupShell = null;
            }
        }

        public IHostShell createStartupShell(String initialWorkingDirectory, String command, String[] environment, IProgressMonitor monitor) throws CoreException, SystemMessageException {
            IHostShellOutputListener listener = new IHostShellOutputListener(){

                public void shellOutputChanged(IHostShellChangeEvent event) {
                    IHostOutput[] lines = event.getLines();
                    String[] lines2 = new String[lines.length];
                    int i = 0;
                    while (i < lines.length) {
                        lines2[i] = lines[i].getString();
                        ++i;
                    }
                    this.writeToConsole(lines2);
                }
            };
            return this.createStartupShell(initialWorkingDirectory, command, environment, listener, monitor);
        }

        public IHostShell createStartupShell(String initialWorkingDirectory, String command, String[] environment, IHostShellOutputListener listener, IProgressMonitor monitor) throws CoreException, SystemMessageException {
            this.listener = listener;
            this.resetStartupShell();
            IServer s = ServerCore.findServer((String)this.serverId);
            IShellService service = RSEHostShellModel.findShellService(s);
            try {
                IHostShell hs;
                this.startupShell = hs = service.launchShell(initialWorkingDirectory, environment, (IProgressMonitor)new NullProgressMonitor());
                if (listener != null) {
                    this.startupShell.addOutputListener(listener);
                }
                hs.writeToShell(command);
                return hs;
            }
            catch (SystemMessageException sme) {
                throw sme;
            }
            catch (RuntimeException re) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", re.getMessage(), (Throwable)re));
            }
        }

        protected void writeToConsole(String[] lines) {
            IServerConsoleWriter l = RSEHostShellModel.getInstance().listener;
            if (l != null) {
                l.writeToShell(this.serverId, lines);
            }
        }

        public void executeRemoteCommand(String initialWorkingDirectory, String command, String[] environment, IProgressMonitor monitor) throws CoreException {
            IServer s = ServerCore.findServer((String)this.serverId);
            IShellService service = RSEHostShellModel.findShellService(s);
            try {
                if (this.singleUseShell == null || !this.singleUseShell.isActive()) {
                    this.singleUseShell = service.launchShell(initialWorkingDirectory, environment, monitor);
                } else if (initialWorkingDirectory != null) {
                    this.singleUseShell.writeToShell("cd " + initialWorkingDirectory);
                }
                this.singleUseShell.writeToShell(command);
            }
            catch (RuntimeException re) {
                String className = service.getClass().getName();
                if (className.endsWith(".DStoreShellService")) {
                    throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "no remote daemon installed. Please install a remote daemon or use an RSE server configured for ssh rather than dstore"));
                }
            }
            catch (SystemMessageException sme) {
                Status s2 = new Status(4, "org.jboss.ide.eclipse.as.rse.core", sme.getMessage(), (Throwable)sme);
                throw new CoreException((IStatus)s2);
            }
        }

        public void executeRemoteCommand(String initialWorkingDirectory, String command, String[] environment, IProgressMonitor monitor, int delay, boolean exit) throws CoreException {
            this.executeRemoteCommand(initialWorkingDirectory, command, environment, monitor);
            ThreadUtils.sleepFor((int)delay);
            if (exit && this.singleUseShell != null) {
                this.singleUseShell.exit();
                this.singleUseShell = null;
            }
        }

        public int executeRemoteCommandGetStatus(String initialWorkingDirectory, String command, String[] environment, IProgressMonitor monitor, int delay, boolean exit) throws CoreException {
            this.executeRemoteCommand(initialWorkingDirectory, command, environment, monitor);
            final String[] statusLine = new String[2];
            final boolean[] done = new boolean[]{false};
            statusLine[0] = null;
            IHostShellOutputListener statusListener = new IHostShellOutputListener(){

                public void shellOutputChanged(IHostShellChangeEvent event) {
                    IHostOutput[] lines = event.getLines();
                    int i = 0;
                    while (i < lines.length) {
                        if (!done[0]) {
                            statusLine[0] = statusLine[1];
                            statusLine[1] = lines[i].getString();
                            System.out.println("RSEHostShellModel debug out:  " + lines[i].getString());
                        }
                        if (serverId.equals(statusLine[1])) {
                            done[0] = true;
                        }
                        ++i;
                    }
                }
            };
            this.singleUseShell.getStandardOutputReader().addOutputListener(statusListener);
            this.singleUseShell.writeToShell("echo $? && echo \"" + this.serverId + "\"");
            ThreadUtils.sleepFor((int)delay);
            if (exit && this.singleUseShell != null && this.singleUseShell.isActive()) {
                this.singleUseShell.exit();
                this.singleUseShell = null;
            }
            String s = statusLine[0];
            done[0] = true;
            if (s != null) {
                try {
                    Integer i = Integer.parseInt(s);
                    return i;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Trace.trace((String)"/finer", (String)NLS.bind((String)"Command {0} exited with status {1}", (Object)command, (Object)statusLine[0]));
            return -1;
        }
    }
}

