/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.server.launch.CommandLineLaunchConfigProperties;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.rse.core.RSEFrameworkUtils;
import org.jboss.ide.eclipse.as.rse.core.RSEHostShellModel;
import org.jboss.ide.eclipse.as.rse.core.RSEServerDummyProcess;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;

public class StandardRSEStartLaunchDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    protected static final String DELIMETER = ":";
    protected static final String ECHO_KEY_DISCOVER_PID = "JBTOOLS_SERVER_START_CMD";
    protected static final String ECHO_KEY_PID_TERMD = "JBTOOLS_SERVER_LAUNCH_TERMINATED_CMD";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        boolean skipLaunch = LaunchCommandPreferences.isIgnoreLaunchCommand((ILaunchConfiguration)configuration);
        if (this.isStarted(server)) {
            this.setServerAlreadyStarted(configuration, mode, beh, server, launch, null);
            return;
        }
        if (skipLaunch) {
            this.externallyManagedPollForStarted(server, beh, mode, launch);
            return;
        }
        this.beforeVMRunner(configuration, mode, launch, monitor);
        this.actualLaunch(configuration, mode, launch, monitor);
        this.afterVMRunner(configuration, mode, launch, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String currentHost;
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        boolean skipLaunch = LaunchCommandPreferences.isIgnoreLaunchCommand((ILaunchConfiguration)configuration);
        ((ControllableServerBehavior)beh).setRunMode(mode);
        if (!(this.isStarted(server) || skipLaunch || (currentHost = server.getAttribute("org.jboss.ide.eclipse.as.rse.core.ServerHost", null)) != null && RSEFrameworkUtils.findHost(currentHost) != null)) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "Host \"" + currentHost + "\" not found. Host may have been deleted or RSE model may not be completely loaded"));
        }
        return true;
    }

    protected void externallyManagedPollForStarted(IServer server, IControllableServerBehavior beh, String mode, ILaunch launch) {
        ((ControllableServerBehavior)beh).setServerStarting();
        String label = String.valueOf(mode) + " " + server.getName();
        this.addDummyProcess(server, launch, null, label);
        this.pollServer(server, true);
    }

    protected void setServerAlreadyStarted(ILaunchConfiguration configuration, String mode, IControllableServerBehavior beh, IServer server, ILaunch launch, String command) throws CoreException {
        ((ControllableServerBehavior)beh).setServerStarting();
        String label = String.valueOf(mode) + " " + server.getName();
        this.addDummyProcess(server, launch, command, label);
        ((ControllableServerBehavior)beh).setServerStarted();
    }

    protected void beforeVMRunner(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        if (beh != null) {
            ((ControllableServerBehavior)beh).setServerStarting();
            ((ControllableServerBehavior)beh).setRunMode(mode);
        }
    }

    protected void actualLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        String command = new CommandLineLaunchConfigProperties().getStartupCommand(configuration);
        if (command.trim().length() == 0) {
            if (beh != null) {
                ((ControllableServerBehavior)beh).setServerStopped();
            }
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "Unable to start server: command to run is empty", null));
        }
        RSEServerDummyProcess dp = this.addDummyProcess(server, launch, command, "Running " + server.getName());
        this.executeRemoteCommand(command, server, dp);
    }

    protected RSEServerDummyProcess addDummyProcess(IServer server, ILaunch launch, String command, String name) {
        RSEServerDummyProcess dp = new RSEServerDummyProcess(server, launch, name);
        dp.setAttribute(IProcess.ATTR_CMDLINE, command);
        launch.addProcess((IProcess)dp);
        return dp;
    }

    protected void afterVMRunner(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.pollServer(ServerUtil.getServer((ILaunchConfiguration)configuration), true);
    }

    protected boolean isStarted(IServer server) {
        return false;
    }

    protected void pollServer(IServer server, boolean expectedState) {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (beh != null) {
            ((ControllableServerBehavior)beh).setServerStarted();
        }
    }

    protected void executeRemoteCommand(String command, IServer server, final RSEServerDummyProcess dp) throws CoreException {
        IHostShellOutputListener sysoutOutListener = new IHostShellOutputListener(){

            public void shellOutputChanged(IHostShellChangeEvent event) {
                IHostOutput[] lines = event.getLines();
                String[] lines2 = new String[lines.length];
                int i = 0;
                while (i < lines.length) {
                    lines2[i] = lines[i].getString();
                    ++i;
                }
                dp.appendToSysout(lines2);
            }
        };
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        try {
            RSEHostShellModel.ServerShellModel model = RSEHostShellModel.getInstance().getModel(server);
            IHostShell shell = model.createStartupShell("/", command, new String[0], sysoutOutListener, (IProgressMonitor)new NullProgressMonitor());
            this.addShellOutputListener(shell, beh, dp);
            String getPidCommand = "echo \"JBTOOLS_SERVER_START_CMD:" + server.getId() + DELIMETER + "\"$!";
            shell.writeToShell(getPidCommand);
        }
        catch (SystemMessageException sme) {
            ((ControllableServerBehavior)beh).setServerStopped();
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", MessageFormat.format("Could not execute command on remote server {0}. Please ensure the server is reachable.", server.getName()), (Throwable)sme));
        }
    }

    private void addShellOutputListener(IHostShell shell, final IControllableServerBehavior behavior, final RSEServerDummyProcess dp) {
        if (shell == null) {
            return;
        }
        IHostShellOutputListener listener = null;
        listener = new IHostShellOutputListener(){

            public void shellOutputChanged(IHostShellChangeEvent event) {
                IHostOutput[] out = event.getLines();
                String s = null;
                int i = 0;
                while (i < out.length) {
                    int lastColon;
                    String pid;
                    s = out[i].toString();
                    if (s.contains(StandardRSEStartLaunchDelegate.ECHO_KEY_DISCOVER_PID) && (pid = s.substring((lastColon = s.lastIndexOf(StandardRSEStartLaunchDelegate.DELIMETER)) + 1)).trim().matches("-?\\d+")) {
                        behavior.putSharedData("DeployableServerBehavior.Process_ID", (Object)pid);
                        IServer ser = behavior.getServer();
                        RSEHostShellModel.ServerShellModel model = RSEHostShellModel.getInstance().getModel(ser);
                        IHostShell startupShell = model.getStartupShell();
                        String waitTerminated = "wait " + pid + "; echo \"" + StandardRSEStartLaunchDelegate.ECHO_KEY_PID_TERMD + StandardRSEStartLaunchDelegate.DELIMETER + ser.getId() + StandardRSEStartLaunchDelegate.DELIMETER + "\" $?";
                        startupShell.writeToShell(waitTerminated);
                    }
                    if (s.startsWith(StandardRSEStartLaunchDelegate.ECHO_KEY_PID_TERMD)) {
                        dp.processComplete();
                        ((ControllableServerBehavior)behavior).setServerStopped();
                    }
                    ++i;
                }
            }
        };
        shell.addOutputListener(listener);
    }
}

