/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.archives;

import java.io.File;
import org.jboss.ide.eclipse.archives.ui.test.bot.ArchivesTestBase;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServersView;
import org.jboss.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesDialog;
import org.jboss.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesPage;
import org.jboss.reddeer.junit.runner.RedDeerSuite;
import org.jboss.reddeer.swt.api.TreeItem;
import org.jboss.reddeer.swt.impl.tree.DefaultTree;
import org.jboss.tools.archives.reddeer.archives.ui.ArchivePublishDialog;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesExplorer;
import org.jboss.tools.archives.reddeer.component.Archive;
import org.jboss.tools.as.ui.bot.itests.Activator;
import org.jboss.tools.as.ui.bot.itests.download.RuntimeDownloadTestUtility;
import org.jboss.tools.as.ui.bot.itests.parametized.server.ServerRuntimeUIConstants;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.DetectRuntimeTemplate;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class DeployingArchiveTest
extends ArchivesTestBase {
    private static String SMOKETEST_TYPE = ServerRuntimeUIConstants.SMOKETEST_DOWNLOADS[0];
    private static String projectName = "DeployingArchiveTest";
    private static final String ARCHIVE_NAME_1 = String.valueOf(projectName) + "a.jar";
    private static final String ARCHIVE_NAME_2 = String.valueOf(projectName) + "b.jar";
    private static final String PATH_SUFFIX = " [/" + projectName + "]";
    private static final String PATH_ARCHIVE_1 = String.valueOf(ARCHIVE_NAME_1) + PATH_SUFFIX;
    private static final String PATH_ARCHIVE_2 = String.valueOf(ARCHIVE_NAME_2) + PATH_SUFFIX;

    @BeforeClass
    public static void setup() {
        DeployingArchiveTest.createJavaProject((String)projectName);
        DeployingArchiveTest.addArchivesSupport((String)projectName);
        DeployingArchiveTest.createArchive((String)projectName, (String)ARCHIVE_NAME_1, (boolean)true);
        DeployingArchiveTest.createArchive((String)projectName, (String)ARCHIVE_NAME_2, (boolean)true);
        File f = Activator.getDownloadFolder(SMOKETEST_TYPE);
        if (!f.exists() || f.list() == null || f.list().length == 0) {
            RuntimeDownloadTestUtility util = new RuntimeDownloadTestUtility(f);
            util.downloadRuntimeNoCredentials(SMOKETEST_TYPE);
        } else {
            DetectRuntimeTemplate.detectRuntime(f.getAbsolutePath(), ServerRuntimeUIConstants.getRuntimesForDownloadable(SMOKETEST_TYPE));
            DetectRuntimeTemplate.removePath(f.getAbsolutePath());
        }
    }

    @AfterClass
    public static void postClass() {
        new RuntimeDownloadTestUtility(Activator.getStateFolder().toFile()).clean(false);
    }

    @Test
    public void testDeployingArchiveWithView() {
        view = DeployingArchiveTest.viewForProject((String)projectName);
        Archive archive = view.getProject(projectName).getArchive(PATH_ARCHIVE_1);
        this.fillPublishDialog(archive.publishToServer(), false, false);
        this.assertArchiveIsDeployed(String.valueOf(projectName) + "/" + ARCHIVE_NAME_1);
        this.removeArchiveFromServer(String.valueOf(projectName) + "/" + ARCHIVE_NAME_1);
        view = DeployingArchiveTest.viewForProject((String)projectName);
        this.fillPublishDialog(archive.editPublishSettings(), true, false);
        archive.publishToServer();
        this.assertArchiveIsDeployed(String.valueOf(projectName) + "/" + ARCHIVE_NAME_1);
    }

    @Test
    public void testDeployingArchiveWithExplorer() {
        ProjectArchivesExplorer explorer = this.explorerForProject(projectName);
        Archive archive = explorer.getArchive(PATH_ARCHIVE_2);
        this.fillPublishDialog(archive.publishToServer(), false, false);
        this.assertArchiveIsDeployed(String.valueOf(projectName) + "/" + ARCHIVE_NAME_2);
        this.removeArchiveFromServer(String.valueOf(projectName) + "/" + ARCHIVE_NAME_2);
        explorer = this.explorerForProject(projectName);
        this.fillPublishDialog(archive.editPublishSettings(), true, false);
        archive.publishToServer();
        this.assertArchiveIsDeployed(String.valueOf(projectName) + "/" + ARCHIVE_NAME_2);
    }

    private void fillPublishDialog(ArchivePublishDialog dialog, boolean alwaysPublish, boolean autodeploy) {
        if (!alwaysPublish && autodeploy) {
            throw new IllegalArgumentException("Cannot autodeploy without always publish option checked");
        }
        String serverName = ServerRuntimeUIConstants.getServerName(SMOKETEST_TYPE);
        dialog.selectServers(new String[]{serverName});
        if (alwaysPublish) {
            dialog.checkAlwaysPublish();
        }
        if (autodeploy) {
            dialog.checkAutoDeploy();
        }
        dialog.finish();
    }

    private void removeArchiveFromServer(String archive) {
        ServersView serversView = new ServersView();
        serversView.open();
        String serverName = ServerRuntimeUIConstants.getServerName(SMOKETEST_TYPE);
        ModifyModulesDialog md = serversView.getServer(serverName).addAndRemoveModules();
        ModifyModulesPage mp = new ModifyModulesPage();
        mp.remove(new String[]{archive});
        md.finish();
    }

    private void assertArchiveIsDeployed(String archive) {
        ServersView sview = new ServersView();
        sview.open();
        boolean found = false;
        String serverName = ServerRuntimeUIConstants.getServerName(SMOKETEST_TYPE);
        block0: for (TreeItem i : new DefaultTree().getItems()) {
            if (!i.getText().contains(serverName)) continue;
            for (TreeItem node : i.getItems()) {
                String[] nodeParsed = node.getText().split(" ");
                if (!nodeParsed[0].equals(archive)) continue;
                found = true;
                continue block0;
            }
        }
        Assert.assertTrue((String)(String.valueOf(archive) + " was not deployed"), (boolean)found);
    }
}

