/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.parametized.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.as.ui.bot.itests.Activator;
import org.jboss.tools.as.ui.bot.itests.SuiteConstants;
import org.jboss.tools.as.ui.bot.itests.parametized.MatrixUtils;
import org.jboss.tools.as.ui.bot.itests.reddeer.Runtime;

public class ServerRuntimeUIConstants {
    public static final String GATE_IN_3_6 = "GateIn Portal 3.6.0";
    public static final String JBAS_328 = "JBoss 3.2.8 SP 1";
    public static final String JBAS_405 = "JBoss 4.0.5";
    public static final String JBAS_423 = "JBoss 4.2.3";
    public static final String JBAS_501 = "JBoss 5.0.1";
    public static final String JBAS_510 = "JBoss 5.1.0";
    public static final String JBAS_600 = "JBoss 6.0.0";
    public static final String JBAS_701 = "JBoss 7.0.1";
    public static final String JBAS_702 = "JBoss 7.0.2";
    public static final String JBAS_710 = "JBoss 7.1.0";
    public static final String JBAS_711 = "JBoss AS 7.1.1 (Brontes)";
    public static final String JBEAP_610 = "JBoss EAP 6.1.0";
    public static final String WF_800 = "WildFly 8.0.0 Final";
    public static final String WF_810 = "WildFly 8.1.0 Final";
    public static final String WF_820 = "WildFly 8.2.0 Final";
    public static final String WF_821 = "WildFly 8.2.1 Final";
    public static final String WF_900 = "WildFly 9.0.0 Final";
    public static final String WF_901 = "WildFly 9.0.1 Final";
    public static final String WF_902 = "WildFly 9.0.2 Final";
    public static final String WF_10_0_0 = "WildFly 10.0.0 Final";
    public static final String WF_10_1_0 = "WildFly 10.1.0 Final";
    public static final String JBEAP_620 = "JBoss EAP 6.2.0";
    public static final String JBEAP_630 = "JBoss EAP 6.3.0";
    public static final String JBEAP_640 = "JBoss EAP 6.4.0";
    public static final String JBEAP_700 = "JBoss EAP 7.0.0";
    public static final String JPP_610 = "JBoss Portal Platform 6.1.0";
    public static final String[] LATEST_MAJORS_FREE_DOWNLOADS = new String[]{"GateIn Portal 3.6.0", "JBoss 4.2.3", "JBoss 5.1.0", "JBoss 6.0.0", "JBoss AS 7.1.1 (Brontes)", "WildFly 8.2.1 Final", "WildFly 9.0.2 Final", "WildFly 10.1.0 Final"};
    public static final String[] FREE_DOWNLOADS = new String[]{"GateIn Portal 3.6.0", "JBoss 3.2.8 SP 1", "JBoss 4.0.5", "JBoss 4.2.3", "JBoss 5.0.1", "JBoss 5.1.0", "JBoss 6.0.0", "JBoss 7.0.1", "JBoss 7.0.2", "JBoss 7.1.0", "JBoss AS 7.1.1 (Brontes)", "WildFly 8.0.0 Final", "WildFly 8.1.0 Final", "WildFly 8.2.0 Final", "WildFly 8.2.1 Final", "WildFly 9.0.1 Final", "WildFly 9.0.2 Final", "WildFly 10.0.0 Final", "WildFly 10.1.0 Final"};
    public static final String[] ZERO_DOLLAR = new String[]{"JBoss Portal Platform 6.1.0", "JBoss EAP 6.1.0", "JBoss EAP 6.2.0", "JBoss EAP 6.3.0", "JBoss EAP 6.4.0", "JBoss EAP 7.0.0"};
    public static final String[] ALL_DOWNLOADS = (String[])Stream.concat(Arrays.stream(FREE_DOWNLOADS), Arrays.stream(ZERO_DOLLAR)).toArray(String[]::new);
    public static final String[] SMOKETEST_DOWNLOADS = new String[]{"WildFly 9.0.2 Final", "WildFly 10.1.0 Final"};
    private static HashMap<String, ModelWrapper> expectations = null;
    private static final IStringFormatter LEGACY_DEPLOY = new PatternFormatter("deploy, ctxPath=/{0}", 1);
    private static final IStringFormatter LEGACY_UNDEPLOY = new PatternFormatter("undeploy, ctxPath=/{0}", 1);
    private static final IStringFormatter STANDARD_DEPLOY = new PatternFormatter("Deployed \"{0}{1}\"", 2);
    private static final IStringFormatter STANDARD_UNDEPLOY = new PatternFormatter("Undeployed \"{0}{1}\"", 2);
    public static final String SKIP_PRIVATE_REQUIREMENTS = "org.jboss.tools.tests.skipPrivateRequirements";

    private static void initialize() {
        HashMap map = new HashMap();
        expectations = map;
        ServerRuntimeUIConstants.addEntry(JBAS_328, "JBoss AS 3.2", "3.2", "AS", "jboss-3.2.8.SP1", LEGACY_DEPLOY, LEGACY_UNDEPLOY, ServerRuntimeUIConstants.legacyEditorPorts());
        ServerRuntimeUIConstants.addEntry(JBAS_405, "JBoss AS 4.0", "4.0", "AS", "jboss-4.0.5.GA", LEGACY_DEPLOY, LEGACY_UNDEPLOY, ServerRuntimeUIConstants.legacyEditorPorts());
        ServerRuntimeUIConstants.addEntry(JBAS_423, "JBoss AS 4.2", "4.2", "AS", "jboss-4.2.3.GA", LEGACY_DEPLOY, LEGACY_UNDEPLOY, ServerRuntimeUIConstants.legacyEditorPorts());
        ServerRuntimeUIConstants.addEntry(JBAS_501, "JBoss AS 5.0", "5.0", "AS", "jboss-5.0.1.GA", LEGACY_DEPLOY, LEGACY_UNDEPLOY, ServerRuntimeUIConstants.legacyEditorPorts());
        ServerRuntimeUIConstants.addEntry(JBAS_510, "JBoss AS 5.1", "5.1", "AS", "jboss-5.1.0.GA", LEGACY_DEPLOY, LEGACY_UNDEPLOY, ServerRuntimeUIConstants.legacyEditorPorts());
        ServerRuntimeUIConstants.addEntry(JBAS_600, "JBoss AS 6.0", "6.0", "AS", "jboss-6.0.0.Final", LEGACY_DEPLOY, LEGACY_UNDEPLOY, ServerRuntimeUIConstants.as6EditorPorts());
        ServerRuntimeUIConstants.addEntry(GATE_IN_3_6, "GateIn 3.6", "3.6", "GateIn", "GateIn-3.6.0.Final-jbossas7", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.as7EditorPorts());
        ServerRuntimeUIConstants.addEntry(JBAS_701, "JBoss AS 7.0", "7.0", "AS", "jboss-as-7.0.1.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.as7EditorPorts());
        ServerRuntimeUIConstants.addEntry(JBAS_702, "JBoss AS 7.0", "7.0", "AS", "jboss-as-7.0.2.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.as7EditorPorts());
        ServerRuntimeUIConstants.addEntry(JBAS_710, "JBoss AS 7.1", "7.1", "AS", "jboss-as-7.1.0.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.as7EditorPorts());
        ServerRuntimeUIConstants.addEntry(JBAS_711, "JBoss AS 7.1", "7.1", "AS", "jboss-as-7.1.1.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.as7EditorPorts());
        ServerRuntimeUIConstants.addEntry(WF_800, "WildFly 8.0", "8.0", "WildFly", "wildfly-8.0.0.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.wfEditorPorts());
        ServerRuntimeUIConstants.addEntry(WF_810, "WildFly 8.1", "8.1", "WildFly", "wildfly-8.1.0.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.wfEditorPorts());
        ServerRuntimeUIConstants.addEntry(WF_820, "WildFly 8.2", "8.2", "WildFly", "wildfly-8.2.0.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.wfEditorPorts());
        ServerRuntimeUIConstants.addEntry(WF_821, "WildFly 8.2", "8.2", "WildFly", "wildfly-8.2.1.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.wfEditorPorts());
        ServerRuntimeUIConstants.addEntry(WF_900, "WildFly 9.0", "9.0", "WildFly", "wildfly-9.0.0.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.wfEditorPorts());
        ServerRuntimeUIConstants.addEntry(WF_901, "WildFly 9.0", "9.0", "WildFly", "wildfly-9.0.1.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.wfEditorPorts());
        ServerRuntimeUIConstants.addEntry(WF_902, "WildFly 9.0", "9.0", "WildFly", "wildfly-9.0.2.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.wfEditorPorts());
        ServerRuntimeUIConstants.addEntry(WF_10_0_0, "WildFly 10.0", "10.0", "WildFly", "wildfly-10.0.0.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.wfEditorPorts());
        ServerRuntimeUIConstants.addEntry(WF_10_1_0, "WildFly 10.1", "10.1", "WildFly", "wildfly-10.1.0.Final", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.wfEditorPorts());
        ServerRuntimeUIConstants.addEntry(JBEAP_610, "Red Hat JBoss EAP 6.1", "6.1", "EAP", "jboss-eap-6.1", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.as7EditorPorts());
        ServerRuntimeUIConstants.addEntry(JBEAP_620, "Red Hat JBoss EAP 6.2", "6.2", "EAP", "jboss-eap-6.2", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.as7EditorPorts());
        ServerRuntimeUIConstants.addEntry(JBEAP_630, "Red Hat JBoss EAP 6.3", "6.3", "EAP", "jboss-eap-6.3", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.as7EditorPorts());
        ServerRuntimeUIConstants.addEntry(JBEAP_640, "Red Hat JBoss EAP 6.4", "6.4", "EAP", "jboss-eap-6.4", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.as7EditorPorts());
        ServerRuntimeUIConstants.addEntry(JBEAP_700, "Red Hat JBoss EAP 7.0", "7.0", "EAP", "jboss-eap-7.0", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.wfEditorPorts());
        ServerRuntimeUIConstants.addEntry(JPP_610, "JBoss Portal 6.1", "6.1", "JPP", "jboss-jpp-6.1", STANDARD_DEPLOY, STANDARD_UNDEPLOY, ServerRuntimeUIConstants.as7EditorPorts());
    }

    public static EditorPort[] legacyEditorPorts() {
        return new EditorPort[]{new EditorPort("Web", "8080"), new EditorPort("JNDI", "1099")};
    }

    public static EditorPort[] as7EditorPorts() {
        return new EditorPort[]{new EditorPort("Web", "8080"), new EditorPort("Management", "9999")};
    }

    public static EditorPort[] wfEditorPorts() {
        return new EditorPort[]{new EditorPort("Web", "8080"), new EditorPort("Management", "9990")};
    }

    public static EditorPort[] as6EditorPorts() {
        return new EditorPort[]{new EditorPort("Web", "8080"), new EditorPort("JNDI", "1099"), new EditorPort("JMX RMI", "1090")};
    }

    private static void addEntry(String key, String name, String version, String type, String suffix, IStringFormatter deployString, IStringFormatter undeployString, EditorPort[] ports) {
        List<Runtime> l = ServerRuntimeUIConstants.asList(ServerRuntimeUIConstants.createRuntime(key, name, version, type, suffix));
        ModelWrapper mw = new ModelWrapper(l, deployString, undeployString, ports);
        expectations.put(key, mw);
    }

    private static List<Runtime> asList(Runtime r) {
        return Arrays.asList(r);
    }

    private static Runtime createRuntime(String key, String name, String version, String type, String suffix) {
        return new Runtime(name, version, type, Activator.getDownloadPath(key).append(suffix).toOSString());
    }

    public static List<Runtime> getRuntimesForDownloadable(String dlRuntimeString) {
        ModelWrapper mw;
        if (expectations == null) {
            ServerRuntimeUIConstants.initialize();
        }
        return (mw = expectations.get(dlRuntimeString)) == null ? null : mw.runtimes;
    }

    public static String getDeployString(String dlRuntimeString, String projectName, String suffix) {
        ModelWrapper mw;
        if (expectations == null) {
            ServerRuntimeUIConstants.initialize();
        }
        return (mw = expectations.get(dlRuntimeString)) == null ? null : mw.deployString.getString(projectName, suffix);
    }

    public static String getUndeployString(String dlRuntimeString, String projectName, String suffix) {
        ModelWrapper mw;
        if (expectations == null) {
            ServerRuntimeUIConstants.initialize();
        }
        return (mw = expectations.get(dlRuntimeString)) == null ? null : mw.undeployString.getString(projectName, suffix);
    }

    public static EditorPort[] getPorts(String dlRuntimeString) {
        ModelWrapper mw;
        if (expectations == null) {
            ServerRuntimeUIConstants.initialize();
        }
        return (mw = expectations.get(dlRuntimeString)) == null ? null : mw.ports;
    }

    public static String getServerName(String runtimeString) {
        String serverName = ServerRuntimeUIConstants.getRuntimesForDownloadable(runtimeString).get(0).getName();
        return serverName;
    }

    public static boolean skipPrivateRequirements() {
        return Boolean.getBoolean(SKIP_PRIVATE_REQUIREMENTS);
    }

    public static Collection<Object[]> getParametersForScope(String scope) {
        ArrayList<Object[]> ret;
        Object[] free = new Object[]{SuiteConstants.FREE};
        Object[] zeroDollar = new Object[]{SuiteConstants.ZERO_DOLLAR};
        if ("latestMajors".equals(scope)) {
            ret = MatrixUtils.toMatrix(new Object[][]{LATEST_MAJORS_FREE_DOWNLOADS, free});
        } else if ("allFree".equals(scope)) {
            ret = MatrixUtils.toMatrix(new Object[][]{FREE_DOWNLOADS, free});
        } else if ("all".equals(scope)) {
            if (ServerRuntimeUIConstants.skipPrivateRequirements()) {
                ret = MatrixUtils.toMatrix(new Object[][]{FREE_DOWNLOADS, free});
            } else {
                ret = MatrixUtils.toMatrix(new Object[][]{FREE_DOWNLOADS, free});
                ArrayList<Object[]> ret2 = MatrixUtils.toMatrix(new Object[][]{ZERO_DOLLAR, zeroDollar});
                ret.addAll(ret2);
            }
        } else {
            ret = MatrixUtils.toMatrix(new Object[][]{SMOKETEST_DOWNLOADS, free});
        }
        return ret;
    }

    public static class EditorPort {
        private String label;
        private String value;

        public EditorPort(String k, String v) {
            this.label = k;
            this.value = v;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static interface IStringFormatter {
        public String getString(String var1, String var2);
    }

    private static class ModelWrapper {
        List<Runtime> runtimes;
        IStringFormatter deployString;
        IStringFormatter undeployString;
        EditorPort[] ports;

        public ModelWrapper(List<Runtime> runtimes, IStringFormatter deployString, IStringFormatter undeployString, EditorPort[] ports) {
            this.runtimes = runtimes;
            this.deployString = deployString;
            this.undeployString = undeployString;
            this.ports = ports;
        }
    }

    private static class PatternFormatter
    implements IStringFormatter {
        private String pattern;
        private int numReplace;

        public PatternFormatter(String pattern, int numReplace) {
            this.pattern = pattern;
            this.numReplace = numReplace;
        }

        @Override
        public String getString(String projectName, String suffix) {
            if (this.numReplace == 1) {
                return NLS.bind((String)this.pattern, (Object)projectName);
            }
            return NLS.bind((String)this.pattern, (Object)projectName, (Object)suffix);
        }
    }
}

