/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.parametized.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.jboss.ide.eclipse.as.reddeer.server.view.JBossServer;
import org.jboss.ide.eclipse.as.reddeer.server.view.JBossServerView;
import org.jboss.reddeer.core.util.Display;
import org.jboss.reddeer.eclipse.jdt.ui.preferences.JREsPreferencePage;
import org.jboss.reddeer.jface.preference.PreferencePage;
import org.jboss.reddeer.junit.internal.runner.ParameterizedRequirementsRunnerFactory;
import org.jboss.reddeer.junit.runner.RedDeerSuite;
import org.jboss.reddeer.swt.impl.text.LabeledText;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.as.ui.bot.itests.Activator;
import org.jboss.tools.as.ui.bot.itests.SuiteConstants;
import org.jboss.tools.as.ui.bot.itests.download.RuntimeDownloadTestUtility;
import org.jboss.tools.as.ui.bot.itests.parametized.server.ServerRuntimeUIConstants;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.DeployJSPProjectTemplate;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.DetectRuntimeTemplate;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.DisableSecureStorageRequirement;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.OperateServerTemplate;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@RunWith(value=RedDeerSuite.class)
@Parameterized.UseParametersRunnerFactory(value=ParameterizedRequirementsRunnerFactory.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@DisableSecureStorageRequirement.DisableSecureStorage
public class ServerRuntimesTest {
    private String runtimeString;
    private boolean dlType;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        String scope = System.getProperty("runtimes.suite.scope");
        ArrayList ret = (ArrayList)ServerRuntimeUIConstants.getParametersForScope(scope);
        return ret;
    }

    @BeforeClass
    public static void addJREs() {
        String jre6 = System.getProperty("jbosstools.test.jre.6");
        String jre7 = System.getProperty("jbosstools.test.jre.7");
        String jre8 = System.getProperty("jbosstools.test.jre.8");
        if (jre6 == null || jre6.isEmpty() || !new File(jre6).exists()) {
            throw new RuntimeException("Expected requirement JRE-6 is not set, is empty, or does not exist. Please set via system property -Djbosstools.test.jre.6");
        }
        if (jre7 == null || jre7.isEmpty() || !new File(jre7).exists()) {
            throw new RuntimeException("Expected requirement JRE-7 is not set, is empty, or does not exist. Please set via system property -Djbosstools.test.jre.7");
        }
        if (jre8 == null || jre8.isEmpty() || !new File(jre8).exists()) {
            throw new RuntimeException("Expected requirement JRE-8 is not set, is empty, or does not exist. Please set via system property -Djbosstools.test.jre.8");
        }
        ServerRuntimesTest.addJRE("JRE6", jre6);
        ServerRuntimesTest.addJRE("JRE7", jre7);
        ServerRuntimesTest.addJRE("JRE8", jre8);
    }

    @AfterClass
    public static void removeJREs() {
        ServerRuntimesTest.removeJRE("JRE6");
        ServerRuntimesTest.removeJRE("JRE7");
        ServerRuntimesTest.removeJRE("JRE8");
    }

    public static void removeJRE(String name) {
        JREsPreferencePage page = new JREsPreferencePage();
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        dialog.open();
        dialog.select((PreferencePage)page);
        page.deleteJRE(name);
        dialog.ok();
    }

    private static void addJRE(String name, String path) {
        JREsPreferencePage page = new JREsPreferencePage();
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        dialog.open();
        dialog.select((PreferencePage)page);
        page.addJRE(path, name);
        dialog.ok();
    }

    public ServerRuntimesTest(String type, boolean free) {
        this.runtimeString = type;
        this.dlType = free;
    }

    protected File getDownloadPath() {
        return Activator.getDownloadFolder(this.runtimeString);
    }

    @Test
    public void acquireAndDetect() {
        System.out.println(this.runtimeString);
        RuntimeDownloadTestUtility util = new RuntimeDownloadTestUtility(this.getDownloadPath());
        if (this.dlType == SuiteConstants.FREE) {
            util.downloadRuntimeNoCredentials(this.runtimeString);
        } else {
            util.downloadRuntimeWithCredentials(this.runtimeString);
        }
    }

    @Test
    public void detect() {
        DetectRuntimeTemplate.detectRuntime(this.getDownloadPath().getAbsolutePath(), ServerRuntimeUIConstants.getRuntimesForDownloadable(this.runtimeString));
        DetectRuntimeTemplate.removePath(this.getDownloadPath().getAbsolutePath());
        String serverName = ServerRuntimeUIConstants.getServerName(this.runtimeString);
        JBossServer server = new JBossServerView().getServer(serverName);
        server.open();
        ServerRuntimeUIConstants.EditorPort[] ports = ServerRuntimeUIConstants.getPorts(this.runtimeString);
        Assert.assertNotNull((Object)ports);
        int i = 0;
        while (i < ports.length) {
            MatcherAssert.assertThat((Object)new LabeledText(ports[i].getLabel()).getText(), (Matcher)Is.is((Object)ports[i].getValue()));
            ++i;
        }
    }

    @Test
    public void operate() {
        DetectRuntimeTemplate.detectRuntime(this.getDownloadPath().getAbsolutePath(), ServerRuntimeUIConstants.getRuntimesForDownloadable(this.runtimeString));
        DetectRuntimeTemplate.removePath(this.getDownloadPath().getAbsolutePath());
        String serverName = ServerRuntimeUIConstants.getServerName(this.runtimeString);
        OperateServerTemplate operate = new OperateServerTemplate(serverName);
        operate.setUp();
        try {
            operate.operateServer();
        }
        finally {
            operate.cleanServerAndConsoleView();
        }
    }

    @Test
    public void operateDeploy() {
        DetectRuntimeTemplate.detectRuntime(this.getDownloadPath().getAbsolutePath(), ServerRuntimeUIConstants.getRuntimesForDownloadable(this.runtimeString));
        DetectRuntimeTemplate.removePath(this.getDownloadPath().getAbsolutePath());
        String serverName = ServerRuntimeUIConstants.getServerName(this.runtimeString);
        OperateServerTemplate operate = new OperateServerTemplate(serverName);
        operate.setUp();
        try {
            operate.startServerSafe();
            DeployJSPProjectTemplate djsppt = new DeployJSPProjectTemplate();
            djsppt.clearConsole();
            djsppt.getServer(serverName);
            djsppt.importProject("jsp-project", "projects/jsp-project.zip", String.valueOf(serverName) + " Runtime");
            String depString = ServerRuntimeUIConstants.getDeployString(this.runtimeString, "jsp-project", ".war");
            djsppt.deployProject("jsp-project", serverName, depString);
            djsppt.hotDeployment("jsp-project");
            String undepString = ServerRuntimeUIConstants.getUndeployString(this.runtimeString, "jsp-project", ".war");
            djsppt.undeployProject(serverName, "jsp-project", undepString);
        }
        finally {
            operate.stopAndDeleteServer();
            operate.cleanServerAndConsoleView();
        }
    }

    @After
    public void postTest() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            }
        });
        new RuntimeDownloadTestUtility(this.getDownloadPath()).clean(false);
    }

    @AfterClass
    public static void postClass() {
        new RuntimeDownloadTestUtility(Activator.getStateFolder().toFile()).clean(true);
    }
}

