/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.reddeer.util;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.jboss.reddeer.jface.preference.PreferencePage;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.as.ui.bot.itests.reddeer.Runtime;
import org.jboss.tools.as.ui.bot.itests.reddeer.RuntimeMatcher;
import org.jboss.tools.as.ui.bot.itests.reddeer.ui.SearchingForRuntimesDialog;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.RuntimeDetectionUtility;
import org.junit.Assert;

public class DetectRuntimeTemplate
extends RuntimeDetectionUtility {
    public static List<Runtime> detectRuntime(String path) {
        Assert.assertTrue((String)("Path " + path + " doesn't exists"), (boolean)new File(path).exists());
        SearchingForRuntimesDialog searchingForRuntimesDialog = DetectRuntimeTemplate.addPath(path);
        List<Runtime> runtimes = searchingForRuntimesDialog.getRuntimes();
        searchingForRuntimesDialog.ok();
        runtimeDetectionPage.ok();
        return runtimes;
    }

    public static List<Runtime> detectRuntime(String path, List<Runtime> expected) {
        Assert.assertTrue((String)("Path " + path + " doesn't exists"), (boolean)new File(path).exists());
        SearchingForRuntimesDialog searchingForRuntimesDialog = DetectRuntimeTemplate.addPath(path);
        List<Runtime> runtimes = searchingForRuntimesDialog.getRuntimes();
        searchingForRuntimesDialog.ok();
        runtimeDetectionPage.ok();
        DetectRuntimeTemplate.assertCountOfRuntimes(searchingForRuntimesDialog, expected, runtimes, path);
        DetectRuntimeTemplate.assertThatExpectedRuntimesArePresent(expected, runtimes);
        return runtimes;
    }

    public static void removePath(String requiredPath) {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        preferenceDialog.open();
        preferenceDialog.select((PreferencePage)runtimeDetectionPage);
        List<String> allPaths = runtimeDetectionPage.getAllPaths();
        Assert.assertTrue((String)("Expected is presence of path " + requiredPath + " but there are:\n" + Arrays.toString(allPaths.toArray())), (boolean)allPaths.contains(requiredPath));
        runtimeDetectionPage.removeAllPaths();
        allPaths = runtimeDetectionPage.getAllPaths();
        runtimeDetectionPage.ok();
        MatcherAssert.assertThat((String)("Not all paths were removed. There are " + Arrays.toString(allPaths.toArray())), (Object)allPaths.size(), (Matcher)Is.is((Object)0));
    }

    private static void assertCountOfRuntimes(SearchingForRuntimesDialog dialog, List<Runtime> expected, List<Runtime> runtimes, String path) {
        int size = runtimes.size();
        int expectedSize = expected.size();
        if (size > 0) {
            MatcherAssert.assertThat((String)("Expected " + expectedSize + " but there were " + size + ":\nExpected runtimes: " + Arrays.toString(expected.toArray()) + "\nBut there were " + Arrays.toString(runtimes.toArray())), (Object)size, (Matcher)Is.is((Object)expectedSize));
        } else {
            dialog.cancel();
            Assert.fail((String)("No runtime detected in folder: " + path));
        }
    }

    private static void assertThatExpectedRuntimesArePresent(List<Runtime> expected, List<Runtime> runtimes) {
        for (Runtime runtime : expected) {
            MatcherAssert.assertThat(runtimes, (Matcher)IsCollectionContaining.hasItem((Matcher)new RuntimeMatcher(runtime)));
        }
    }
}

