/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.reddeer.junit.runner.RedDeerSuite;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class SingleServerDirectoryStructureTest {
    private String location = System.getProperty("jbosstools.test.single.runtime.location");

    @Test
    public void verifyFolderStructure() {
        Assert.assertNotNull((Object)this.location);
        File f = new File(this.location);
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f.isDirectory());
        File prodConf = new File(new File(f, "bin"), "product.conf");
        Assert.assertTrue((boolean)prodConf.exists());
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(prodConf));
            Assert.assertEquals((Object)"eap", (Object)p.getProperty("slot"));
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
        File jbModules = new File(this.location, "jboss-modules.jar");
        Assert.assertTrue((boolean)jbModules.exists());
        IPath standaloneXML = new Path(this.location).append("standalone/configuration/standalone.xml");
        Assert.assertTrue((boolean)standaloneXML.toFile().exists());
        Path p2 = new Path(this.location);
        IPath prodManifest = p2.append("modules/system/layers/base/org/jboss/as/product/eap/dir/META-INF/MANIFEST.MF");
        Assert.assertTrue((boolean)prodManifest.toFile().exists());
        try {
            Manifest man = new Manifest(new FileInputStream(prodManifest.toFile()));
            String o3 = man.getMainAttributes().getValue("JBoss-Product-Release-Name");
            Assert.assertEquals((Object)"JBoss EAP", (Object)o3);
            String o4 = man.getMainAttributes().getValue("JBoss-Product-Release-Version");
            Assert.assertNotNull((Object)o4);
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
    }
}

