/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.server;

import java.io.File;
import java.util.List;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.jboss.ide.eclipse.as.reddeer.server.view.JBossServerView;
import org.jboss.reddeer.core.util.Display;
import org.jboss.reddeer.eclipse.wst.server.ui.view.Server;
import org.jboss.reddeer.junit.runner.RedDeerSuite;
import org.jboss.tools.as.ui.bot.itests.Activator;
import org.jboss.tools.as.ui.bot.itests.download.RuntimeDownloadTestUtility;
import org.jboss.tools.as.ui.bot.itests.parametized.server.ServerRuntimeUIConstants;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.DeployJSPProjectTemplate;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.DetectRuntimeTemplate;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.DisableSecureStorageRequirement;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.OperateServerTemplate;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;

@RunWith(value=RedDeerSuite.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@DisableSecureStorageRequirement.DisableSecureStorage
public class SingleServerRuntimeTest {
    private String location = System.getProperty("jbosstools.test.single.runtime.location");
    private String serverName;

    protected File getDownloadPath() {
        return new File(this.location);
    }

    @Test
    public void detect() {
        DetectRuntimeTemplate.detectRuntime(this.getDownloadPath().getAbsolutePath());
        DetectRuntimeTemplate.removePath(this.getDownloadPath().getAbsolutePath());
        new JBossServerView().open();
        List all = new JBossServerView().getServers();
        MatcherAssert.assertThat((Object)all.size(), (Matcher)Is.is((Object)1));
        this.serverName = ((Server)all.get(0)).getLabel().getName();
    }

    @Test
    public void operate() {
        DetectRuntimeTemplate.detectRuntime(this.getDownloadPath().getAbsolutePath());
        DetectRuntimeTemplate.removePath(this.getDownloadPath().getAbsolutePath());
        new JBossServerView().open();
        List all = new JBossServerView().getServers();
        MatcherAssert.assertThat((Object)all.size(), (Matcher)Is.is((Object)1));
        this.serverName = ((Server)all.get(0)).getLabel().getName();
        OperateServerTemplate operate = new OperateServerTemplate(this.serverName);
        operate.setUp();
        try {
            operate.operateServer();
        }
        finally {
            operate.cleanServerAndConsoleView();
        }
    }

    @Test
    public void operateDeploy() {
        String undepString = ServerRuntimeUIConstants.getUndeployString("JBoss EAP 7.0.0", "jsp-project", ".war");
        String depString = ServerRuntimeUIConstants.getDeployString("JBoss EAP 7.0.0", "jsp-project", ".war");
        DetectRuntimeTemplate.detectRuntime(this.getDownloadPath().getAbsolutePath());
        DetectRuntimeTemplate.removePath(this.getDownloadPath().getAbsolutePath());
        new JBossServerView().open();
        List all = new JBossServerView().getServers();
        MatcherAssert.assertThat((Object)all.size(), (Matcher)Is.is((Object)1));
        this.serverName = ((Server)all.get(0)).getLabel().getName();
        OperateServerTemplate operate = new OperateServerTemplate(this.serverName);
        operate.setUp();
        try {
            operate.startServerSafe();
            DeployJSPProjectTemplate djsppt = new DeployJSPProjectTemplate();
            djsppt.clearConsole();
            djsppt.getServer(this.serverName);
            djsppt.importProject("jsp-project", "projects/jsp-project.zip", String.valueOf(this.serverName) + " Runtime");
            djsppt.deployProject("jsp-project", this.serverName, depString);
            djsppt.hotDeployment("jsp-project");
            djsppt.undeployProject(this.serverName, "jsp-project", undepString);
        }
        finally {
            operate.stopAndDeleteServer();
            operate.cleanServerAndConsoleView();
        }
    }

    @After
    public void postTest() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            }
        });
        new RuntimeDownloadTestUtility(this.getDownloadPath()).clean(false);
    }

    @AfterClass
    public static void postClass() {
        new RuntimeDownloadTestUtility(Activator.getStateFolder().toFile()).clean(true);
    }
}

