/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.reddeer.archives.ui;

import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.swt.api.Shell;
import org.jboss.reddeer.swt.condition.ShellIsAvailable;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.button.RadioButton;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.swt.impl.text.LabeledText;

public abstract class ArchiveDialogBase
extends DefaultShell {
    public ArchiveDialogBase(String dialogTitle) {
        super(dialogTitle);
    }

    public ArchiveDialogBase setArchiveName(String archiveName) {
        String newArchiveName = archiveName.contains(".jar") ? archiveName : String.valueOf(archiveName) + ".jar";
        new LabeledText("Archive name:").setText(newArchiveName);
        return this;
    }

    public ArchiveDialogBase setDestination(String location) {
        new LabeledText("Destination:").setText("");
        new LabeledText("Destination:").setText(location);
        return this;
    }

    public ArchiveDialogBase setFileSystemRelative() {
        new RadioButton("Filesystem Relative").click();
        return this;
    }

    public ArchiveDialogBase setWorkspaceRelative() {
        new RadioButton("Workspace Relative").click();
        return this;
    }

    public ArchiveDialogBase setZipStandardArchiveType() {
        new RadioButton("Standard archive using zip compression").click();
        return this;
    }

    public ArchiveDialogBase setNoCompressionArchiveType() {
        new RadioButton("Exploded archive resulting in a folder (no compression)").click();
        return this;
    }

    public void cancel() {
        new PushButton("Cancel").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)this));
    }

    public void finish() {
        new PushButton("Finish").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)this));
        new WaitWhile((WaitCondition)new JobIsRunning());
    }
}

