/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.reddeer.archives.ui;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.swt.api.Shell;
import org.jboss.reddeer.swt.api.Table;
import org.jboss.reddeer.swt.condition.ShellIsAvailable;
import org.jboss.reddeer.swt.impl.button.CheckBox;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.swt.impl.table.DefaultTable;

public class ArchivePublishDialog
extends DefaultShell {
    private static final String DIALOG_TITLE = "Archive Publish Settings";

    public ArchivePublishDialog() {
        super(DIALOG_TITLE);
    }

    public List<String> getAllServersInDialog() {
        ArrayList<String> serversInDialog = new ArrayList<String>();
        int i = 0;
        while (i < this.table().rowCount()) {
            serversInDialog.add(this.table().getItem(i).getText(0));
            ++i;
        }
        return serversInDialog;
    }

    public List<String> getAllSelectedServersInDialog() {
        ArrayList<String> selectedServers = new ArrayList<String>();
        return selectedServers;
    }

    public ArchivePublishDialog selectServers(String ... serversToSelect) {
        this.table().select(serversToSelect);
        return this;
    }

    public ArchivePublishDialog unselectServers(String ... serversToUnselect) {
        List<String> selectedServers = this.getAllSelectedServersInDialog();
        int i = 0;
        while (i < serversToUnselect.length) {
            selectedServers.remove(serversToUnselect[i]);
            ++i;
        }
        String[] strArray = new String[selectedServers.size()];
        selectedServers.toArray(strArray);
        this.table().select(strArray);
        return this;
    }

    public ArchivePublishDialog unselectAllServers() {
        return this;
    }

    public ArchivePublishDialog checkAlwaysPublish() {
        new CheckBox(0, new Matcher[0]).toggle(true);
        return this;
    }

    public ArchivePublishDialog uncheckAlwaysPublish() {
        new CheckBox(0, new Matcher[0]).toggle(false);
        return this;
    }

    public ArchivePublishDialog checkAutoDeploy() {
        new CheckBox(1, new Matcher[0]).toggle(true);
        return this;
    }

    public ArchivePublishDialog uncheckAutoDeploy() {
        new CheckBox(1, new Matcher[0]).toggle(false);
        return this;
    }

    private Table table() {
        return new DefaultTable();
    }

    public void cancel() {
        new PushButton("Cancel").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)this));
    }

    public void finish() {
        new PushButton("Finish").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)this));
        new WaitWhile((WaitCondition)new JobIsRunning());
    }
}

