/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.reddeer.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.jboss.reddeer.common.logging.Logger;
import org.jboss.reddeer.eclipse.ui.console.ConsoleView;

public class ServerConsoleContainsNoExceptionMatcher
extends TypeSafeMatcher<ConsoleView> {
    private static final String[] EXPECTED_EXCEPTIONS_PATTERNS = new String[]{".*Remote connection failed: java.io.IOException: Connection reset by peer.*", ".*Remote connection failed: java.io.IOException: An established connection was aborted by the software in your host.*"};
    private static final Logger log = Logger.getLogger(ServerConsoleContainsNoExceptionMatcher.class);
    private List<String> expectedExceptions = new ArrayList<String>();
    private List<String> unexpectedExceptions = new ArrayList<String>();
    private String actualText;

    protected boolean matchesSafely(ConsoleView view) {
        this.actualText = view.getConsoleText();
        if (!this.actualText.contains("Exception")) {
            return true;
        }
        this.findExceptionLines(this.actualText);
        return this.unexpectedExceptions.isEmpty();
    }

    private void findExceptionLines(String text) {
        this.unexpectedExceptions = new ArrayList<String>();
        this.expectedExceptions = new ArrayList<String>();
        Scanner scanner = new Scanner(text);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.contains("Exception")) continue;
            log.trace("Found line with exception: " + line);
            if (this.isExpected(line)) {
                log.trace("Line will be ignored");
                this.expectedExceptions.add(line);
                continue;
            }
            this.unexpectedExceptions.add(line);
        }
        scanner.close();
    }

    private boolean isExpected(String line) {
        String[] stringArray = EXPECTED_EXCEPTIONS_PATTERNS;
        int n = EXPECTED_EXCEPTIONS_PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (line.matches(pattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("console contains no unexpected exceptions '\n");
        description.appendText("Found exceptions are:\n");
        for (String exception : this.unexpectedExceptions) {
            description.appendText("\t" + exception + "\n");
        }
        description.appendText("Found expected exceptions are:\n");
        for (String exception : this.expectedExceptions) {
            description.appendText("\t" + exception + "\n");
        }
        description.appendText("Full console log:\n");
        description.appendText(this.actualText);
        description.appendText("'.");
    }
}

