/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.reddeer.server.deploy;

import org.hamcrest.Matcher;
import org.jboss.ide.eclipse.as.reddeer.server.view.JBossServerModule;
import org.jboss.ide.eclipse.as.reddeer.server.view.JBossServerView;
import org.jboss.reddeer.common.condition.AbstractWaitCondition;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.exception.WaitTimeoutExpiredException;
import org.jboss.reddeer.common.logging.Logger;
import org.jboss.reddeer.common.matcher.RegexMatcher;
import org.jboss.reddeer.common.wait.TimePeriod;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.core.exception.CoreLayerException;
import org.jboss.reddeer.core.matcher.TreeItemTextMatcher;
import org.jboss.reddeer.eclipse.condition.ConsoleHasNoChange;
import org.jboss.reddeer.eclipse.core.resources.Project;
import org.jboss.reddeer.eclipse.exception.EclipseLayerException;
import org.jboss.reddeer.eclipse.jdt.ui.ProjectExplorer;
import org.jboss.reddeer.eclipse.ui.browser.BrowserEditor;
import org.jboss.reddeer.eclipse.ui.browser.BrowserView;
import org.jboss.reddeer.eclipse.ui.console.ConsoleView;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ModuleLabel;
import org.jboss.reddeer.eclipse.wst.server.ui.view.Server;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServerModule;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServersView;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServersViewEnums;
import org.jboss.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesDialog;
import org.jboss.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesPage;
import org.jboss.reddeer.jface.wizard.WizardDialog;
import org.jboss.reddeer.swt.impl.menu.ContextMenu;
import org.jboss.reddeer.swt.impl.tree.DefaultTreeItem;
import org.jboss.reddeer.workbench.impl.editor.DefaultEditor;
import org.junit.Assert;

public class DeployOnServer {
    private static final Logger log = Logger.getLogger(DeployOnServer.class);

    public void checkServerStatus(String serverName) {
        ServersView serversView = new ServersView();
        serversView.open();
        Server server = serversView.getServer(serverName);
        Assert.assertTrue((String)"Server has not been started!", (server.getLabel().getState() == ServersViewEnums.ServerState.STARTED ? 1 : 0) != 0);
    }

    public void deployUndeployProjectToServer(String projectToDeploy, String serverName) {
        new ConsoleView().clearConsole();
        this.deployProject(projectToDeploy, serverName);
        this.checkDeployedProject(projectToDeploy, serverName);
        this.unDeployModule(projectToDeploy, serverName);
    }

    public void unDeployModule(String moduleName, String serverName) {
        log.info("UNDEPLOYING MODULE" + moduleName + " ON SERVER " + serverName);
        ServersView serversView = new ServersView();
        serversView.open();
        Server server = serversView.getServer(serverName);
        ServerModule serverModule = server.getModule((Matcher)new RegexMatcher(".*" + moduleName + ".*"));
        serverModule.remove();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
    }

    public void deployProject(String deployableProject, String serverName) {
        log.info("DEPLOYING " + deployableProject);
        ProjectExplorer explorer = new ProjectExplorer();
        explorer.activate();
        Project project = explorer.getProject(deployableProject);
        project.select();
        new ContextMenu(new String[]{"Run As", "1 Run on Server"}).select();
        new WizardDialog().finish();
    }

    public void deployProjectModule(String projectName, String serverName) {
        JBossServerView serversView = new JBossServerView();
        serversView.open();
        ModifyModulesDialog modulesDialog = serversView.getServer(serverName).addAndRemoveModules();
        String moduleName = new DefaultTreeItem(new Matcher[]{new TreeItemTextMatcher((Matcher)new RegexMatcher(".*" + projectName + ".*"))}).getText();
        new ModifyModulesPage().add(new String[]{moduleName});
        modulesDialog.finish();
        new WaitUntil((WaitCondition)new WaitForProjectToStartAndSynchronize(moduleName, serverName), TimePeriod.LONG);
    }

    public void restartServer(String serverName) {
        ServersView serversView = new ServersView();
        serversView.open();
        Server server = serversView.getServer(serverName);
        server.clean();
        server.restart();
    }

    protected static void closeBrowser() {
        try {
            BrowserEditor browser = new BrowserEditor((Matcher)new RegexMatcher(".*"));
            while (browser != null) {
                browser.close();
                try {
                    browser = new BrowserEditor((Matcher)new RegexMatcher(".*"));
                }
                catch (CoreLayerException coreLayerException) {
                    browser = null;
                }
            }
        }
        catch (CoreLayerException coreLayerException) {
            return;
        }
    }

    public void checkDeployedProject(String projectName, String serverNameLabel) {
        if (!projectName.contains("ejb-timer") && !projectName.contains("cluster-ha-singleton")) {
            new WaitWhile((WaitCondition)new JobIsRunning());
            new WaitUntil((WaitCondition)new ConsoleHasNoChange(TimePeriod.LONG), TimePeriod.VERY_LONG);
        }
        JBossServerView serversView = new JBossServerView();
        serversView.open();
        String moduleName = projectName.equals("template") ? "QUICKSTART_NAME" : projectName;
        JBossServerModule module = (JBossServerModule)serversView.getServer(serverNameLabel).getModule((Matcher)new RegexMatcher(".*" + moduleName + ".*"));
        if (new ContextMenu(new String[]{"Show In", "Web Browser"}).isEnabled()) {
            module.openWebPage();
            BrowserEditor browser = new BrowserEditor((Matcher)new RegexMatcher(".*"));
            try {
                new WaitUntil((WaitCondition)new BrowserIsNotEmpty(browser));
            }
            catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
                browser.refreshPage();
                new WaitUntil((WaitCondition)new BrowserIsNotEmpty(browser));
            }
            DeployOnServer.checkBrowserForErrorPage(browser);
            Assert.assertNotEquals((Object)"", (Object)browser.getText());
            new DefaultEditor().close();
        }
        this.checkConsoleForException();
        this.checkServerViewForStatus(moduleName, serverNameLabel);
    }

    protected void checkConsoleForException() {
        ConsoleView consoleView = new ConsoleView();
        consoleView.open();
        Assert.assertFalse((String)("Console contains text 'Operation (\"deploy\") failed':\n" + consoleView.getConsoleText()), (boolean)consoleView.getConsoleText().contains("Operation (\"deploy\") failed"));
    }

    protected void checkServerViewForStatus(String moduleName, String serverNameLabel) {
        ServersView serversView = new ServersView();
        serversView.open();
        Server server = serversView.getServer(serverNameLabel);
        ServerModule serverModule = server.getModule((Matcher)new RegexMatcher(".*" + moduleName + ".*"));
        ModuleLabel moduleLabel = serverModule.getLabel();
        ServersViewEnums.ServerState moduleState = moduleLabel.getState();
        Assert.assertTrue((String)"Module has not been started!", (moduleState == ServersViewEnums.ServerState.STARTED ? 1 : 0) != 0);
    }

    public static void checkBrowserForErrorPage(BrowserEditor browserEditor) {
        DeployOnServer.evaluateBrowserPage(browserEditor.getText());
    }

    public static void checkBrowserForErrorPage(BrowserView browserView, String url) {
        if (browserView.getText().contains("Unable") || browserView.getText().contains("404")) {
            if (url == null) {
                browserView.refreshPage();
            } else {
                browserView.openPageURL(url);
            }
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        DeployOnServer.evaluateBrowserPage(browserView.getText());
    }

    private static void evaluateBrowserPage(String browserPage) {
        ConsoleView consoleView = new ConsoleView();
        consoleView.open();
        Assert.assertFalse((String)("Browser contains text 'Status 404'\n Console output:\n" + consoleView.getConsoleText() + System.getProperty("line.separator") + "Browser contents:" + browserPage), (browserPage.contains("Status 404") || browserPage.contains("404 - Not Found") ? 1 : 0) != 0);
        Assert.assertFalse((String)("Browser contains text 'Error processing request'\n Console output:\n" + consoleView.getConsoleText() + System.getProperty("line.separator") + "Browser contents:" + browserPage), (boolean)browserPage.contains("Error processing request"));
        Assert.assertFalse((String)("Browser contains text 'Forbidden'\n Console output:\n" + consoleView.getConsoleText() + System.getProperty("line.separator") + "Browser contents:" + browserPage), (boolean)browserPage.contains("Forbidden"));
    }

    class BrowserIsNotEmpty
    extends AbstractWaitCondition {
        BrowserEditor browser;

        public BrowserIsNotEmpty(BrowserEditor browser) {
            this.browser = browser;
        }

        public boolean test() {
            return !this.browser.getText().equals("");
        }

        public String description() {
            return "Browser is empty!";
        }
    }

    class WaitForProjectToStartAndSynchronize
    extends AbstractWaitCondition {
        String projectName;
        String serverNameLabel;
        JBossServerModule module = null;

        public WaitForProjectToStartAndSynchronize(String projectName, String serverNameLabel) {
            this.projectName = projectName;
            this.serverNameLabel = serverNameLabel;
        }

        public boolean test() {
            boolean started;
            boolean synch = this.getModule().getLabel().getPublishState().compareTo((Enum)ServersViewEnums.ServerPublishState.SYNCHRONIZED) == 0;
            boolean bl = started = this.getModule().getLabel().getState().compareTo((Enum)ServersViewEnums.ServerState.STARTED) == 0;
            return synch && started;
        }

        public String description() {
            return "Waiting for module to be started-synchronized, but was " + this.getModule().getLabel().getState() + "-" + this.getModule().getLabel().getPublishState();
        }

        private JBossServerModule getModule() {
            int counter = 0;
            while (this.module == null && counter < 5) {
                JBossServerView serversView = new JBossServerView();
                serversView.open();
                try {
                    this.module = serversView.getServer(this.serverNameLabel).getModule(this.projectName);
                }
                catch (EclipseLayerException eclipseLayerException) {
                    ++counter;
                }
            }
            return this.module;
        }
    }
}

