/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.reddeer.server.requirement;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.jboss.ide.eclipse.as.reddeer.server.family.FamilyEAP;
import org.jboss.ide.eclipse.as.reddeer.server.family.FamilyWildFly;
import org.jboss.ide.eclipse.as.reddeer.server.requirement.ServerMatcher;
import org.jboss.ide.eclipse.as.reddeer.server.requirement.ServerReqType;
import org.jboss.ide.eclipse.as.reddeer.server.requirement.ServerReqVersion;
import org.jboss.ide.eclipse.as.reddeer.server.requirement.ServerRequirementConfig;
import org.jboss.ide.eclipse.as.reddeer.server.view.JBossServerView;
import org.jboss.ide.eclipse.as.reddeer.server.wizard.page.JBossRuntimeWizardPage;
import org.jboss.ide.eclipse.as.reddeer.server.wizard.page.NewServerAdapterPage;
import org.jboss.ide.eclipse.as.reddeer.server.wizard.page.NewServerRSIWizardPage;
import org.jboss.ide.eclipse.as.reddeer.server.wizard.page.NewServerWizardPageWithErrorCheck;
import org.jboss.reddeer.common.exception.RedDeerException;
import org.jboss.reddeer.common.logging.Logger;
import org.jboss.reddeer.eclipse.rse.ui.view.System;
import org.jboss.reddeer.eclipse.rse.ui.view.SystemView;
import org.jboss.reddeer.eclipse.rse.ui.wizard.NewConnectionWizardDialog;
import org.jboss.reddeer.eclipse.rse.ui.wizard.NewConnectionWizardMainPage;
import org.jboss.reddeer.eclipse.rse.ui.wizard.NewConnectionWizardSelectionPage;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServersView;
import org.jboss.reddeer.eclipse.wst.server.ui.wizard.NewServerWizardDialog;
import org.jboss.reddeer.junit.requirement.CustomConfiguration;
import org.jboss.reddeer.junit.requirement.Requirement;
import org.jboss.reddeer.requirements.server.ConfiguredServerInfo;
import org.jboss.reddeer.requirements.server.IServerReqConfig;
import org.jboss.reddeer.requirements.server.ServerReqBase;
import org.jboss.reddeer.requirements.server.ServerReqState;
import org.junit.Assert;

public class ServerRequirement
extends ServerReqBase
implements Requirement<JBossServer>,
CustomConfiguration<ServerRequirementConfig> {
    private static final Logger LOGGER = Logger.getLogger(ServerRequirement.class);
    private static ConfiguredServerInfo lastServerConfiguration;
    private ServerRequirementConfig config;
    private JBossServer server;

    public boolean canFulfill() {
        return ServerMatcher.matchServerFamily(this.server.type().getFamily(), this.config.getServerFamily()) && ServerMatcher.matchServerVersion(this.server.type().getVersion(), this.server.version(), this.config.getServerFamily().getVersion());
    }

    public void fulfill() {
        if (lastServerConfiguration != null) {
            boolean differentConfig;
            boolean bl = differentConfig = !this.config.equals(lastServerConfiguration.getConfig());
            if (differentConfig) {
                this.removeLastRequiredServerAndRuntime(lastServerConfiguration);
                lastServerConfiguration = null;
            }
        }
        if (lastServerConfiguration == null || !this.isLastConfiguredServerPresent(lastServerConfiguration)) {
            LOGGER.info("Setup server");
            if (this.config.getRemote() == null) {
                this.setupLocalServerAdapter();
            } else {
                this.setupRemoteServerAdapter();
            }
            lastServerConfiguration = new ConfiguredServerInfo(this.getServerNameLabelText(this.config), (IServerReqConfig)this.config);
        }
        this.setupServerState(this.server.state(), lastServerConfiguration);
    }

    protected ServersView createServersView() {
        return new JBossServerView();
    }

    public void setDeclaration(JBossServer server) {
        this.server = server;
    }

    public Class<ServerRequirementConfig> getConfigurationClass() {
        return ServerRequirementConfig.class;
    }

    public void setConfiguration(ServerRequirementConfig config) {
        this.config = config;
    }

    public void cleanUp() {
        if (this.server.cleanup() && this.config != null) {
            this.removeLastRequiredServerAndRuntime(lastServerConfiguration);
            lastServerConfiguration = null;
        }
    }

    public ServerRequirementConfig getConfig() {
        return this.config;
    }

    public String getServerNameLabelText(IServerReqConfig config) {
        if (this.config.getRemote() == null) {
            return super.getServerNameLabelText(config);
        }
        return String.valueOf(super.getServerTypeLabelText(config)) + " Remote Server";
    }

    protected void setupLocalServerAdapter() {
        NewServerWizardDialog serverW = new NewServerWizardDialog();
        try {
            String version;
            String label;
            serverW.open();
            NewServerWizardPageWithErrorCheck sp = new NewServerWizardPageWithErrorCheck();
            String serverTypeLabelText = this.getServerTypeLabelText(this.config);
            if (FamilyWildFly.class.equals(this.config.getServerFamily().getClass())) {
                label = this.config.getServerFamily().getLabel();
                version = this.config.getServerFamily().getVersion();
                if (version.equals("8.x")) {
                    serverTypeLabelText = String.valueOf(label) + "  " + version;
                }
                if (version.equals("9.x")) {
                    serverTypeLabelText = String.valueOf(label) + "  " + version;
                }
                if (version.equals("10.x")) {
                    serverTypeLabelText = String.valueOf(label) + " " + version;
                }
            }
            if (FamilyEAP.class.equals(this.config.getServerFamily().getClass())) {
                label = this.config.getServerFamily().getLabel();
                version = this.config.getServerFamily().getVersion();
                if (version.equals("7.x")) {
                    serverTypeLabelText = String.valueOf(label) + " 7.x";
                }
            }
            sp.selectType(new String[]{this.config.getServerFamily().getCategory(), serverTypeLabelText});
            sp.setName(this.getServerNameLabelText(this.config));
            sp.checkErrors();
            serverW.next();
            NewServerAdapterPage ap = new NewServerAdapterPage();
            ap.setRuntime(null);
            ap.checkErrors();
            serverW.next();
            this.setupRuntime();
            serverW.finish();
        }
        catch (RuntimeException e) {
            try {
                serverW.cancel();
            }
            catch (RedDeerException redDeerException) {
                throw e;
            }
            throw e;
        }
        catch (AssertionError e) {
            try {
                serverW.cancel();
            }
            catch (RedDeerException redDeerException) {
                throw e;
            }
            throw e;
        }
    }

    protected void setupRuntime() {
        JBossRuntimeWizardPage rp = new JBossRuntimeWizardPage();
        rp.setRuntimeName(this.getRuntimeNameLabelText(this.config));
        rp.setRuntimeDir(this.config.getRuntime());
        rp.checkErrors();
    }

    protected void setupRemoteSystem() {
        SystemView sview = new SystemView();
        NewConnectionWizardDialog connW = sview.newConnection();
        NewConnectionWizardSelectionPage sp = new NewConnectionWizardSelectionPage();
        sp.selectSystemType(NewConnectionWizardSelectionPage.SystemType.SSH_ONLY);
        connW.next();
        NewConnectionWizardMainPage mp = new NewConnectionWizardMainPage();
        mp.setHostName(this.config.getRemote().getHost());
        connW.finish();
        System system = sview.getSystem(this.config.getRemote().getHost());
        system.connect(this.config.getRemote().getUsername(), this.config.getRemote().getPassword());
        Assert.assertTrue((boolean)system.isConnected());
    }

    protected void setupRemoteServerAdapter() {
        NewServerWizardDialog serverW = new NewServerWizardDialog();
        try {
            this.setupRemoteSystem();
            serverW.open();
            NewServerWizardPageWithErrorCheck sp = new NewServerWizardPageWithErrorCheck();
            sp.selectType(new String[]{this.config.getServerFamily().getCategory(), this.getServerTypeLabelText(this.config)});
            sp.setName(this.getServerNameLabelText(this.config));
            sp.checkErrors();
            serverW.next();
            NewServerAdapterPage ap = new NewServerAdapterPage();
            ap.setProfile(NewServerAdapterPage.Profile.REMOTE);
            if (this.config.getRuntime() == null) {
                ap.setAssignRuntime(false);
            }
            serverW.next();
            if (this.config.getRuntime() != null) {
                this.setupRuntime();
                serverW.next();
            }
            NewServerRSIWizardPage rsp = new NewServerRSIWizardPage();
            rsp.setRemoteServerHome(this.config.getRemote().getRemoteServerHome());
            rsp.selectHost(this.config.getRemote().getHost());
            serverW.finish();
        }
        catch (RuntimeException e) {
            serverW.cancel();
            throw e;
        }
        catch (AssertionError e) {
            serverW.cancel();
            throw e;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface JBossServer {
        public ServerReqState state() default ServerReqState.RUNNING;

        public ServerReqType type() default ServerReqType.ANY;

        public ServerReqVersion version() default ServerReqVersion.EQUAL;

        public boolean cleanup() default true;
    }
}

