/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.reddeer.server.view;

import java.util.ArrayList;
import java.util.List;
import org.jboss.ide.eclipse.as.reddeer.server.editor.JBossServerEditor;
import org.jboss.ide.eclipse.as.reddeer.server.editor.WelcomeToServerEditor;
import org.jboss.ide.eclipse.as.reddeer.server.view.JBossServerModule;
import org.jboss.ide.eclipse.as.reddeer.server.view.XMLConfiguration;
import org.jboss.reddeer.common.condition.AbstractWaitCondition;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.exception.WaitTimeoutExpiredException;
import org.jboss.reddeer.common.logging.Logger;
import org.jboss.reddeer.common.wait.TimePeriod;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.eclipse.ui.console.ConsoleView;
import org.jboss.reddeer.eclipse.wst.server.ui.editor.ServerEditor;
import org.jboss.reddeer.eclipse.wst.server.ui.view.Server;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServerModule;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServersView;
import org.jboss.reddeer.swt.api.TreeItem;
import org.jboss.reddeer.swt.exception.SWTLayerException;
import org.jboss.reddeer.swt.impl.menu.ContextMenu;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;

public class JBossServer
extends Server {
    public static final String XML_LABEL_DECORATION_SEPARATOR = "   ";
    private static final Logger log = Logger.getLogger(JBossServer.class);

    protected JBossServer(TreeItem treeItem, ServersView view) {
        super(treeItem, view);
    }

    public JBossServerEditor open() {
        ServerEditor editor = super.open();
        if (!(editor instanceof JBossServerEditor)) {
            throw new IllegalStateException("Unexpected ServerEditor subtype. Expected: " + JBossServerEditor.class + " but was: " + editor.getClass());
        }
        return (JBossServerEditor)editor;
    }

    public JBossServerModule getModule(String name) {
        ServerModule module = super.getModule(name);
        if (!(module instanceof JBossServerModule)) {
            throw new IllegalStateException("Unexpected ServerModule subtype. Expected: " + JBossServerModule.class + " but was: " + module.getClass());
        }
        return (JBossServerModule)module;
    }

    public WelcomeToServerEditor openWebPage() {
        this.activate();
        new WaitUntil((WaitCondition)new ContextMenuIsEnabled("Show In", "Web Browser"));
        new ContextMenu(new String[]{"Show In", "Web Browser"}).select();
        return new WelcomeToServerEditor();
    }

    public void start() {
        this.checkServerAlreadyRunningDialog();
        try {
            super.start();
        }
        catch (WaitTimeoutExpiredException e) {
            log.error("JBoss server failed to start");
            this.checkServerAlreadyRunningDialog();
            log.error("JBoss server's console dump:");
            ConsoleView view = new ConsoleView();
            view.open();
            log.error("\t" + view.getConsoleText());
            throw e;
        }
    }

    public void restart() {
        try {
            super.restart();
        }
        catch (WaitTimeoutExpiredException e) {
            log.error("JBoss server failed to restart");
            this.checkServerAlreadyRunningDialog();
            log.error("JBoss server's console dump:");
            ConsoleView view = new ConsoleView();
            view.open();
            log.error("\t" + view.getConsoleText());
            throw e;
        }
    }

    public List<XMLConfiguration> getXMLConfiguration(String categoryName) {
        this.activate();
        TreeItem categoryItem = this.treeItem.getItem("XML Configuration").getItem(categoryName);
        List configurationItems = categoryItem.getItems();
        new WaitUntil((WaitCondition)new TreeItemLabelDecorated((TreeItem)configurationItems.get(0)), TimePeriod.NORMAL, false);
        new WaitUntil((WaitCondition)new TreeItemLabelDecorated((TreeItem)configurationItems.get(configurationItems.size() - 1)), TimePeriod.NONE, false);
        ArrayList<XMLConfiguration> configurations = new ArrayList<XMLConfiguration>();
        for (TreeItem item : configurationItems) {
            String[] columns = item.getText().split(XML_LABEL_DECORATION_SEPARATOR);
            if (columns.length < 2) continue;
            configurations.add(new XMLConfiguration(columns[0].trim(), columns[1].trim()));
        }
        return configurations;
    }

    protected ServerEditor createServerEditor(String title) {
        return new JBossServerEditor(title);
    }

    protected ServerModule createServerModule(TreeItem item) {
        return new JBossServerModule(item, this.view);
    }

    private void checkServerAlreadyRunningDialog() {
        try {
            DefaultShell shell = new DefaultShell("Server already running on localhost");
            shell.close();
            throw new ServerAlreadyStartedException();
        }
        catch (SWTLayerException sWTLayerException) {
            return;
        }
    }

    private static class ContextMenuIsEnabled
    extends AbstractWaitCondition {
        private String[] path;

        public ContextMenuIsEnabled(String ... path) {
            this.path = path;
        }

        public boolean test() {
            return new ContextMenu(this.path).isEnabled();
        }

        public String description() {
            return "context menu item is enabled";
        }
    }

    class ServerAlreadyStartedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ServerAlreadyStartedException() {
            super("Server already running on localhost");
        }
    }

    private static class TreeItemLabelDecorated
    extends AbstractWaitCondition {
        private TreeItem item;

        private TreeItemLabelDecorated(TreeItem item) {
            this.item = item;
        }

        public boolean test() {
            return this.item.getText().contains(JBossServer.XML_LABEL_DECORATION_SEPARATOR);
        }

        public String description() {
            return "Expected the tree item to be decorated with separator '   '";
        }
    }
}

