/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.ui;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.rse.ui.DeployOnlyRSEPrefComposite;
import org.jboss.ide.eclipse.as.rse.ui.JBoss7RSEDeploymentPrefComposite;
import org.jboss.ide.eclipse.as.rse.ui.JBossRSEDeploymentPrefComposite;
import org.jboss.ide.eclipse.as.rse.ui.RSEDeploymentPreferenceComposite;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;

public class RSEWizardFragment
extends WizardFragment {
    private IWizardHandle handle;
    private Composite main;

    protected void initWizardHandle() {
        this.handle.setTitle("Remote System Integration");
        this.handle.setDescription("Please set the properties required for connecting to a remote system.");
        String imageKey = "jbossLogo";
        this.handle.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor((String)imageKey));
    }

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        return this.main != null && !this.main.isDisposed() && super.isComplete();
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
    }

    public Composite createComposite(Composite parent, final IWizardHandle handle) {
        this.handle = handle;
        this.initWizardHandle();
        IDeploymentTypeUI.IServerModeUICallback callbackDelegate = (IDeploymentTypeUI.IServerModeUICallback)this.getTaskModel().getObject("wc_callback_handler");
        DelegatingCallback callback = new DelegatingCallback(callbackDelegate){

            @Override
            public void setComplete(boolean complete) {
                RSEWizardFragment.this.setComplete(complete);
                handle.update();
            }

            @Override
            public void setErrorMessage(String msg) {
                handle.setMessage(msg, 3);
                this.setComplete(msg != null);
            }
        };
        this.main = new Composite(parent, 0);
        this.main.setLayout((Layout)new FillLayout());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.main.setLayoutData((Object)gd);
        RSEDeploymentPreferenceComposite composite = null;
        IServerWorkingCopy cServer = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        IJBossServer jbs = cServer.getOriginal() == null ? ServerConverter.getJBossServer((IServerWorkingCopy)cServer) : ServerConverter.getJBossServer((IServer)cServer.getOriginal());
        ServerExtendedProperties sep = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)cServer);
        if (jbs == null || sep == null) {
            composite = new DeployOnlyRSEPrefComposite(this.main, 0, callback);
        } else if (sep.getFileStructure() == 1) {
            composite = new JBossRSEDeploymentPrefComposite(this.main, 0, callback);
        } else if (sep.getFileStructure() == 2) {
            composite = new JBoss7RSEDeploymentPrefComposite(this.main, 0, callback);
        }
        this.main.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RSEWizardFragment.this.main = null;
            }
        });
        return this.main;
    }

    private static class DelegatingCallback
    implements IDeploymentTypeUI.IServerModeUICallback {
        protected IDeploymentTypeUI.IServerModeUICallback callback;

        public DelegatingCallback(IDeploymentTypeUI.IServerModeUICallback cb) {
            this.callback = cb;
        }

        public IServerWorkingCopy getServer() {
            return this.callback.getServer();
        }

        public IRuntime getRuntime() {
            return this.callback.getRuntime();
        }

        public void execute(IUndoableOperation operation) {
            this.callback.execute(operation);
        }

        public void executeLongRunning(Job j) {
            this.callback.executeLongRunning(j);
        }

        public void setErrorMessage(String msg) {
            this.callback.setErrorMessage(msg);
        }

        public Object getAttribute(String key) {
            return this.callback.getAttribute(key);
        }

        public int getCallbackType() {
            return this.callback.getCallbackType();
        }

        public void setComplete(boolean complete) {
            this.callback.setComplete(complete);
        }
    }
}

