/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathCorePlugin;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlot;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlotCache;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.LayeredProductPathProvider;

public abstract class AbstractModuleSlotUtil {
    public static IRuntimePathProvider[] moduleSlotsAsProviders(ModuleSlot[] all) {
        ArrayList<LayeredProductPathProvider> ret = new ArrayList<LayeredProductPathProvider>();
        int i = 0;
        while (i < all.length) {
            ret.add(new LayeredProductPathProvider(all[i]));
            ++i;
        }
        return ret.toArray(new IRuntimePathProvider[ret.size()]);
    }

    protected IFile[] locateFiles(IProject p, final String fileName) throws CoreException {
        final ArrayList ret = new ArrayList();
        if (p != null && p.isAccessible()) {
            p.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getName().toLowerCase().equals(fileName) && resource instanceof IFile) {
                        ret.add((IFile)resource);
                    }
                    return true;
                }
            });
        }
        return ret.toArray(new IFile[ret.size()]);
    }

    protected ModuleSlot getModuleSlot(String ms) {
        if (ms != null) {
            if ((ms = ms.trim()).contains(" ")) {
                ms = ms.substring(0, ms.indexOf(" ")).trim();
            }
            int colon = ms.indexOf(":");
            String mod = null;
            String slot = null;
            if (colon != -1) {
                slot = ms.substring(colon + 1);
                mod = ms.substring(0, colon);
            } else {
                mod = ms;
            }
            return new ModuleSlot(mod, slot);
        }
        return null;
    }

    protected boolean isCacheOutdated(IFile[] all) {
        int i = 0;
        while (i < all.length) {
            if (ModuleSlotCache.getInstance().isOutdated(all[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isCacheOutdated(IProject p) {
        IFile[] all = this.getRelevantFiles(p);
        if (all != null) {
            return this.isCacheOutdated(all);
        }
        return true;
    }

    protected IFile[] getRelevantFiles(IProject p) {
        if (!this.isInitialized(p)) {
            try {
                this.cacheFiles(p, this.locateRelevantFiles(p));
            }
            catch (CoreException ce) {
                return new IFile[0];
            }
        }
        return this.getCachedFiles(p);
    }

    protected boolean isCacheOutdated(IFile f) {
        return ModuleSlotCache.getInstance().isOutdated(f);
    }

    public ModuleSlot[] getAllModuleSlots(IProject p, IFile[] files) {
        ArrayList<ModuleSlot> all = new ArrayList<ModuleSlot>();
        if (files == null) {
            return new ModuleSlot[0];
        }
        int i = 0;
        while (i < files.length) {
            IFile f = files[i];
            if (!this.isCacheOutdated(f)) {
                ModuleSlot[] prevCached = this.fetchCachedModuleSlots(f);
                all.addAll(Arrays.asList(prevCached));
            } else {
                ModuleSlot[] forFile = this.calculateModuleSlots(files[i]);
                this.cacheModuleSlots(f, forFile);
                all.addAll(Arrays.asList(forFile));
            }
            ++i;
        }
        return all.toArray(new ModuleSlot[all.size()]);
    }

    protected void cacheModuleSlots(IFile f, ModuleSlot[] all) {
        ModuleSlotCache.getInstance().cache(f, all);
    }

    protected abstract boolean isInitialized(IProject var1);

    protected ModuleSlot[] fetchCachedModuleSlots(IFile f) {
        return ModuleSlotCache.getInstance().getEntries(f);
    }

    protected abstract ModuleSlot[] calculateModuleSlots(IFile var1);

    protected abstract IFile[] locateRelevantFiles(IProject var1) throws CoreException;

    protected abstract boolean cacheInitializedProject(IProject var1);

    protected abstract IFile[] getCachedFiles(IProject var1);

    protected abstract void cacheFiles(IProject var1, IFile[] var2);

    protected void cacheRelevantFiles(IProject p) throws CoreException {
        this.cacheFiles(p, this.locateRelevantFiles(p));
    }

    public ModuleSlot[] getAllModuleSlots(IProject p) {
        return this.getAllModuleSlots(p, this.getRelevantFiles(p));
    }

    @Deprecated
    public void esureInCache(IFile f) {
        this.ensureInCache(f);
    }

    public void ensureInCache(IFile f) {
        IFile[] all;
        ArrayList<IFile> tmp;
        IProject p = f.getProject();
        boolean initialized = this.cacheInitializedProject(p);
        if (!initialized) {
            try {
                this.cacheRelevantFiles(p);
            }
            catch (CoreException ce) {
                IStatus o = ce.getStatus();
                Status stat2 = new Status(o.getSeverity(), o.getPlugin(), o.getMessage(), (Throwable)ce);
                ClasspathCorePlugin.getDefault().getLog().log((IStatus)stat2);
            }
        }
        ArrayList<IFile> arrayList = tmp = (all = this.getCachedFiles(p)) == null ? new ArrayList<IFile>() : new ArrayList<IFile>(Arrays.asList(all));
        if (!tmp.contains(f)) {
            tmp.add(f);
            this.cacheFiles(p, tmp.toArray(new IFile[tmp.size()]));
        }
    }
}

