/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;

public class ExploreUtils {
    public static final String PATH = "{%}";
    private static String exploreFolderCommand;
    private static String[] exploreFolderCommandArray;
    private static String[] exploreFileCommandArray;
    private static String exploreFileCommand;

    public static String getExploreCommand() {
        if (exploreFolderCommand == null) {
            ExploreUtils.setExploreCommands();
        }
        return exploreFolderCommand;
    }

    public static String getExploreFileCommand() {
        exploreFileCommand = null;
        exploreFolderCommandArray = null;
        exploreFolderCommand = null;
        if (exploreFileCommand == null) {
            ExploreUtils.setExploreCommands();
        }
        return exploreFileCommand;
    }

    private static void setExploreCommands() {
        if ("macosx".equals(Platform.getOS())) {
            exploreFolderCommandArray = new String[]{"/usr/bin/open", "-a", "/System/Library/CoreServices/Finder.app", ""};
            exploreFolderCommand = "";
        } else if ("win32".equals(Platform.getOS())) {
            exploreFolderCommandArray = new String[5];
            ExploreUtils.exploreFolderCommandArray[0] = "cmd";
            ExploreUtils.exploreFolderCommandArray[1] = "/C";
            ExploreUtils.exploreFolderCommandArray[2] = "start";
            ExploreUtils.exploreFolderCommandArray[3] = "explorer";
            exploreFileCommandArray = new String[6];
            ExploreUtils.exploreFileCommandArray[0] = "cmd";
            ExploreUtils.exploreFileCommandArray[1] = "/C";
            ExploreUtils.exploreFileCommandArray[2] = "start";
            ExploreUtils.exploreFileCommandArray[3] = "explorer";
            ExploreUtils.exploreFileCommandArray[4] = "/select,";
            exploreFolderCommand = "cmd /C start explorer \"{%}\"";
            exploreFileCommand = "cmd /C start explorer /select,\"{%}\"";
        } else if ("linux".equals(Platform.getOS())) {
            exploreFolderCommand = "";
            if (new File("/usr/bin/nautilus").exists()) {
                exploreFolderCommandArray = new String[3];
                ExploreUtils.exploreFolderCommandArray[0] = "/usr/bin/nautilus";
                ExploreUtils.exploreFolderCommandArray[1] = "--no-desktop";
            } else if (new File("/usr/bin/konqueror").exists()) {
                exploreFolderCommandArray = new String[2];
                ExploreUtils.exploreFolderCommandArray[0] = "/usr/bin/konqueror";
            } else if (new File("/usr/bin/xdg-open").exists()) {
                exploreFolderCommandArray = new String[2];
                ExploreUtils.exploreFolderCommandArray[0] = "/usr/bin/xdg-open";
            }
            exploreFileCommand = exploreFolderCommand;
        }
    }

    public static void explore(String name) {
        File file = new File(name);
        String command = null;
        command = file.isFile() ? ExploreUtils.getExploreFileCommand() : ExploreUtils.getExploreCommand();
        if (command != null) {
            if (Platform.getOS().equals("win32")) {
                name = name.replace('/', '\\');
            }
            try {
                if ("linux".equals(Platform.getOS()) || "macosx".equals(Platform.getOS())) {
                    String name2;
                    int len = exploreFolderCommandArray.length;
                    ExploreUtils.exploreFolderCommandArray[len - 1] = name2 = file.isFile() ? new Path(name).removeLastSegments(1).toString() : name;
                    Runtime.getRuntime().exec(exploreFolderCommandArray);
                } else if (Platform.getOS().equals("win32")) {
                    if (file.isDirectory()) {
                        int len = exploreFolderCommandArray.length;
                        ExploreUtils.exploreFolderCommandArray[len - 1] = "\"" + name + "\"";
                        Runtime.getRuntime().exec(exploreFolderCommandArray);
                    } else {
                        int len = exploreFileCommandArray.length;
                        ExploreUtils.exploreFileCommandArray[len - 1] = "\"" + name + "\"";
                        Runtime.getRuntime().exec(exploreFileCommandArray);
                    }
                } else {
                    command = command.replace(PATH, name);
                    if (JBossServerUIPlugin.getDefault().isDebugging()) {
                        Status status = new Status(2, "org.jboss.ide.eclipse.as.ui", "command=" + command, null);
                        JBossServerUIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                    Runtime.getRuntime().exec(command);
                }
            }
            catch (IOException e) {
                JBossServerUIPlugin.log(e.getMessage(), e);
            }
        }
    }
}

