/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyCommand;

public class ServerPasswordSection
extends ServerEditorSection {
    private static String PASSWORD_NOT_LOADED = "***jbt****";
    private ModifyListener nameModifyListener;
    private ModifyListener passModifyListener;
    private Text nameText;
    private Text passText;
    private ServerAttributeHelper helper;
    private String passwordString;
    private boolean passwordChanged = false;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.swf_AuthenticationGroup);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label explanation = toolkit.createLabel(composite, Messages.swf_AuthorizationDescription);
        GridData d = new GridData();
        d.horizontalSpan = 2;
        explanation.setLayoutData((Object)d);
        Label username = toolkit.createLabel(composite, Messages.swf_Username);
        username.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        String n = ServerConverter.getJBossServer((IServer)this.server.getOriginal()).getUsername();
        this.passwordString = PASSWORD_NOT_LOADED;
        this.nameText = toolkit.createText(composite, n);
        Label password = toolkit.createLabel(composite, Messages.swf_Password);
        password.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.passText = toolkit.createText(composite, this.passwordString, 0x400004);
        d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.widthHint = 100;
        this.nameText.setLayoutData((Object)d);
        d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.widthHint = 100;
        this.passText.setLayoutData((Object)d);
        this.nameModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPasswordSection.this.execute((IUndoableOperation)new SetUserCommand(ServerPasswordSection.this.server));
            }
        };
        this.passModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPasswordSection.this.execute((IUndoableOperation)new SetPassCommand(ServerPasswordSection.this.server));
            }
        };
        this.nameText.addModifyListener(this.nameModifyListener);
        this.passText.addModifyListener(this.passModifyListener);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.passwordChanged) {
            JBossServer jbs = (JBossServer)ServerConverter.getJBossServer((IServer)this.server.getOriginal());
            jbs.setPassword(this.passwordString);
            monitor.worked(100);
            this.passwordChanged = false;
        }
    }

    public class SetPassCommand
    extends ServerWorkingCopyPropertyCommand {
        public SetPassCommand(IServerWorkingCopy server) {
            super(server, Messages.EditorChangePasswordCommandName, ServerPasswordSection.this.passText, ServerPasswordSection.this.passText.getText(), "org.jboss.ide.eclipse.as.core.server.password", ServerPasswordSection.this.passModifyListener);
            this.oldVal = ServerPasswordSection.this.passwordString;
        }

        public void execute() {
            ServerPasswordSection.this.passwordString = this.newVal;
            ServerPasswordSection.this.passwordChanged = !PASSWORD_NOT_LOADED.equals(ServerPasswordSection.this.passwordString);
        }

        public void undo() {
            ServerPasswordSection.this.passwordString = this.oldVal;
            this.text.removeModifyListener(this.listener);
            this.text.setText(this.oldVal);
            this.text.addModifyListener(this.listener);
            ServerPasswordSection.this.passwordChanged = !PASSWORD_NOT_LOADED.equals(ServerPasswordSection.this.passwordString);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
            this.execute();
            return Status.OK_STATUS;
        }
    }

    public class SetUserCommand
    extends ServerWorkingCopyPropertyCommand {
        public SetUserCommand(IServerWorkingCopy server) {
            super(server, Messages.EditorChangeUsernameCommandName, ServerPasswordSection.this.nameText, ServerPasswordSection.this.nameText.getText(), "org.jboss.ide.eclipse.as.core.server.userName", ServerPasswordSection.this.nameModifyListener);
        }
    }
}

