/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views;

import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.ui.internal.provisional.ManagedUIDecorator;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.views.LogEntry;
import org.jboss.ide.eclipse.as.ui.views.ServerLogView;

@Deprecated
public class LogLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getImage(Object element) {
        if (element instanceof ServerLogView.EventCategory) {
            int type = ((ServerLogView.EventCategory)element).getType();
            if (type == 0x1000000) {
                return new ManagedUIDecorator().getStateImage(1, "run", 1);
            }
            if (type == 0x2000000) {
                return JBossServerUISharedImages.getImage("PUBLISH_IMAGE");
            }
        }
        if (element instanceof LogEntry) {
            int code = ((LogEntry)((Object)element)).getCode();
            int istatusCode = (code & 0xE0000000) >> 29;
            if (istatusCode != 0) {
                switch (istatusCode) {
                    case 1: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                    }
                    case 2: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    }
                    case 3: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    }
                }
            }
            int majorType = code & 0x1F000000;
            switch (majorType) {
                case 0x1000000: {
                    return this.handlePollImage((LogEntry)((Object)element), code);
                }
                case 0x2000000: {
                    return this.handlePublishImage((LogEntry)((Object)element), code);
                }
            }
        }
        return null;
    }

    public Image handlePublishImage(LogEntry element, int code) {
        if ((code & 1) == 0) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if ((code & 2) == 0) {
            return JBossServerUISharedImages.getImage("PUBLISH_IMAGE");
        }
        return JBossServerUISharedImages.getImage("UNPUBLISH_IMAGE");
    }

    public Image handlePollImage(LogEntry element, int code) {
        if ((code & 0x1FFF0000) == 0x1010000) {
            int state = (code & 0x38) >> 3;
            return new ManagedUIDecorator().getStateImage(state, "run", 1);
        }
        if ((code & 0x1FFF0000) == 0x1020000) {
            if (element.getSeverity() == 2) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            int state = code & 0xF;
            switch (state) {
                case 1: {
                    return new ManagedUIDecorator().getStateImage(2, "run", 1);
                }
                case 0: {
                    return new ManagedUIDecorator().getStateImage(4, "run", 1);
                }
                case 2: {
                    return new ManagedUIDecorator().getStateImage(1, "run", 1);
                }
            }
        } else if ((code & 0x1FFF0000) == 0x1030000) {
            switch (code) {
                case 16973826: 
                case 0x1030003: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
                case 0x1030001: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                }
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ServerLogView.EventCategory) {
            int type = ((ServerLogView.EventCategory)element).getType();
            if (type == 0) {
                return Messages.LogLabelProvider_UnknownEventType;
            }
            if (type == 0x1000000) {
                return Messages.LogLabelProvider_StartupShutdownEventType;
            }
            if (type == 0x2000000) {
                return Messages.LogLabelProvider_PublishingEventType;
            }
        }
        if (element instanceof LogEntry) {
            return ((LogEntry)((Object)element)).getMessage();
        }
        return element == null ? "" : element.toString();
    }

    protected String getSuffix(Object entry2) {
        if (entry2 instanceof LogEntry) {
            long hours;
            LogEntry entry = (LogEntry)((Object)entry2);
            long diff = new Date().getTime() - entry.getDate().getTime();
            long sec = diff / 1000L;
            long minutes = sec / 60L;
            if (minutes > 0L) {
                sec -= minutes * 60L;
            }
            if ((hours = minutes / 60L) > 0L) {
                minutes -= hours * 60L;
                sec -= hours * 60L * 60L;
            }
            if (hours > 0L) {
                return MessageFormat.format(Messages.LogLabelProvider_HoursMinutesAgo, hours, minutes);
            }
            if (minutes > 0L) {
                return MessageFormat.format(Messages.LogLabelProvider_MinutesSecondsAgo, minutes, sec);
            }
            return MessageFormat.format(Messages.LogLabelProvider_SecondsAgo, sec);
        }
        return "";
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        return this.getSuffix(element);
    }
}

