/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.as7.management.content;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.server.core.IServer;
import org.jboss.dmr.ModelNode;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.AttributeNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ContainerNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IAttributeNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IAttributesContainer;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IResourceNode;

public class AttributesContainer
extends ContainerNode<IResourceNode>
implements IAttributesContainer {
    private List<String> attributeNames;
    private List<IAttributeNode> attributes;

    protected AttributesContainer(IResourceNode parent, List<String> attributeNames) {
        super(parent, "attributes");
        this.attributeNames = attributeNames;
    }

    @Override
    protected List<IAttributeNode> delegateGetChildren() {
        return this.attributes;
    }

    @Override
    protected void delegateClearChildren() {
        if (this.attributes != null) {
            for (IAttributeNode attribute : this.attributes) {
                attribute.dispose();
            }
            this.attributes.clear();
            this.attributes = null;
        }
    }

    @Override
    public void dispose() {
        this.attributeNames.clear();
        super.dispose();
    }

    @Override
    protected void delegateLoad() throws Exception {
        String resultJSON = (String)JBoss7ManagerUtil.executeWithService((JBoss7ManagerUtil.IServiceAware)new JBoss7ManagerUtil.IServiceAware<String>(){

            public String execute(IJBoss7ManagerService service) throws Exception {
                return service.execute((IAS7ManagementDetails)new AS7ManagementDetails(AttributesContainer.this.getServer()), AttributesContainer.this.createResourceRequest());
            }
        }, (IServer)this.getServer());
        ModelNode result = ModelNode.fromJSONString((String)resultJSON);
        this.attributes = new ArrayList<IAttributeNode>(this.attributeNames.size());
        for (String name : this.attributeNames) {
            if (result.hasDefined(name)) {
                this.attributes.add(new AttributeNode(this, name, result.get(name).asString()));
                continue;
            }
            this.attributes.add(new AttributeNode(this, name, null));
        }
    }

    private String createResourceRequest() {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-resource");
        request.get("address").set(AttributesContainer.getManagementAddress(this.getParent()));
        return request.toJSONString(true);
    }
}

