/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.itests.server.publishing;

import java.util.Collection;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;

public class AbstractComponentPublishingTest
extends AbstractPublishingTest {
    protected String jarFolder;
    protected String jarName;

    public static Collection<Object[]> componentJarData() {
        return AbstractComponentPublishingTest.componentJarData(false);
    }

    public static Collection<Object[]> fullComponentJarData() {
        return AbstractComponentPublishingTest.componentJarData(true);
    }

    public static Collection<Object[]> componentJarData(boolean complete) {
        String[] servers = ServerParameterUtils.getPublishServerTypes();
        String[] zipOption = ServerParameterUtils.getServerZipOptions();
        Object[] defaultDeployLoc = ServerParameterUtils.getDefaultDeployOptions();
        Object[] perModOverrides = ServerParameterUtils.getPerModuleOverrideOptions();
        if (!complete) {
            defaultDeployLoc = new Object[]{defaultDeployLoc[0]};
            perModOverrides = new Object[]{perModOverrides[0]};
        }
        String[] junitName = new String[]{"junit.jar", "otherOut.jar"};
        String[] outFolder = new String[]{"lib", "otherFolder", "deep/nested", ""};
        Object[][] allOptions = new Object[][]{servers, zipOption, defaultDeployLoc, perModOverrides, junitName, outFolder};
        return MatrixUtils.toMatrix((Object[][])allOptions);
    }

    public AbstractComponentPublishingTest(String serverType, String zip, String deployLoc, String perMod, String refName, String refFolder) {
        super(serverType, zip, deployLoc, perMod);
        this.jarName = refName;
        this.jarFolder = refFolder;
    }

    protected void printConstructor() {
        System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ":  " + this.param_serverType + ", " + this.param_zip + ", " + this.param_deployLoc + ", " + this.param_perModOverride + ", " + this.jarName + ", " + this.jarFolder);
    }

    protected void completeSetUp() {
        ServerProfileModel.setProfile((IServerWorkingCopy)this.wc, (String)"local");
    }

    protected void verifyFileFoundInModule(String folder, String name, int expectedFileCount) throws Exception {
        this.verifyFileFoundInModule(folder, name, expectedFileCount, this.primaryModule);
    }

    protected void verifyFileFoundInModule(String folder, String name, int expectedFileCount, IModule module) throws Exception {
        IModuleFile[] allFiles = ResourceUtils.findAllIModuleFiles((IModule)module);
        AbstractComponentPublishingTest.assertEquals((int)allFiles.length, (int)expectedFileCount);
        IModuleFile selected = null;
        int i = 0;
        while (i < allFiles.length) {
            if (allFiles[i].getName().equals(name)) {
                selected = allFiles[i];
                break;
            }
            ++i;
        }
        IModuleFile mf = selected;
        AbstractComponentPublishingTest.assertNotNull(mf);
        AbstractComponentPublishingTest.assertEquals((String)mf.getName(), (String)name);
        AbstractComponentPublishingTest.assertEquals((Object)mf.getModuleRelativePath().makeRelative(), (Object)new Path(folder).makeRelative());
    }
}

