/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.itests.server.publishing;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.application.internal.operations.AddReferenceToEnterpriseApplicationDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.tools.as.itests.server.publishing.AbstractComponentPublishingTest;
import org.jboss.tools.as.test.core.internal.MockPublishMethodFilesystemController;
import org.jboss.tools.as.test.core.internal.utils.ComponentReferenceUtils;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.classpath.ASToolsInternalVariableInitializer;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeploymentAssemblyArchivePathVarTest
extends AbstractComponentPublishingTest {
    private static String PROJECT_PREFIX = "pEar";
    private static int PROJECT_ID = 1;
    protected String MY_PROJECT_NAME;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return DeploymentAssemblyArchivePathVarTest.componentJarData();
    }

    public DeploymentAssemblyArchivePathVarTest(String serverType, String zip, String deployLoc, String perMod, String refName, String refFolder) {
        super(serverType, zip, deployLoc, perMod, refName, refFolder);
    }

    protected void createProjects() throws Exception {
        this.setProjectName();
        IProject p = this.projectCreation();
        this.addReferences(p);
        this.addModuleToServer(p);
    }

    protected void setProjectName() {
        this.MY_PROJECT_NAME = String.valueOf(PROJECT_PREFIX) + ++PROJECT_ID;
    }

    protected IProject projectCreation() throws Exception {
        return this.createSingleProject(this.getSingleProjectCreationDataModel(), this.MY_PROJECT_NAME);
    }

    protected IProject createSingleProject(IDataModel dm, String name) throws Exception {
        OperationTestCase.runAndVerify((IDataModel)dm);
        IProject p = ResourceUtils.findProject((String)name);
        if (!p.exists()) {
            DeploymentAssemblyArchivePathVarTest.fail();
        }
        return p;
    }

    protected IDataModel getSingleProjectCreationDataModel() {
        return CreateProjectOperationsUtility.getEARDataModel((String)this.MY_PROJECT_NAME, (String)"ourContent", null, null, (IProjectFacetVersion)JavaEEFacetConstants.EAR_5, (boolean)false);
    }

    protected void addReferences(IProject p) throws Exception {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)p);
        IVirtualReference ref = this.createArchiveReference(vc);
        ComponentReferenceUtils.addReferenceToComponent((IVirtualComponent)vc, (IVirtualReference)ref, (IDataModelProvider)this.getDefaultAddReferenceProvider());
    }

    protected IVirtualReference createArchiveReference(IVirtualComponent vc) throws Exception {
        ASToolsInternalVariableInitializer.ensureFoldersCreated();
        Path path = new Path("ASTOOLS_TEST_HOME/junit.jar");
        IVirtualReference ref = ComponentReferenceUtils.createPathArchiveReference((IVirtualComponent)vc, (IPath)path, (String)this.jarFolder, (String)this.jarName);
        return ref;
    }

    protected IDataModelProvider getDefaultAddReferenceProvider() {
        return new AddReferenceToEnterpriseApplicationDataModelProvider();
    }

    protected void addModuleToServer(IProject p) throws CoreException {
        IModule module = ServerUtil.getModule((IProject)p);
        this.addModuleToServer(module);
    }

    @Test
    public void testVariableReference() throws Exception {
        this.verifyFileFoundInModule(this.jarFolder, this.jarName, this.getExpectedFileCount());
        MockPublishMethodFilesystemController.StaticModel.clearAll();
        this.server.publish(1, (IProgressMonitor)new NullProgressMonitor());
        IPath earPath = this.getLocalPublishMethodDeployRoot();
        ArrayList<IPath> toFind = new ArrayList<IPath>();
        toFind.add(earPath.append(this.jarFolder).append(this.jarName));
        this.verifyList(earPath, toFind, true);
    }

    protected int getExpectedFileCount() {
        return 1;
    }
}

