/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jolokia.test.util;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.jboss.tools.jmx.jolokia.test.util.EnvTestUtil;
import org.jboss.tools.jmx.jolokia.test.util.OperationChecking;
import org.jolokia.client.BasicAuthenticator;
import org.jolokia.client.J4pClient;
import org.jolokia.http.AgentServlet;
import org.jolokia.jmx.JolokiaMBeanServerUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class JolokiaTestEnvironmentSetup {
    public static final String JOLOKIA_IT_DOMAIN = "jolokia.it";
    private static final String JOLOKIA = "jolokia";
    private static Server jettyServer;
    private static String j4pUrl;
    protected static J4pClient j4pClient;
    private static ObjectName registeredMBean;

    static {
        registeredMBean = null;
    }

    @BeforeClass
    public static void start() throws Exception {
        String testUrl = System.getProperty("j4p.url");
        if (testUrl == null) {
            int port = EnvTestUtil.getFreePort();
            jettyServer = new Server(port);
            SecurityHandler securityHandler = JolokiaTestEnvironmentSetup.createSecurityHandler();
            ServletContextHandler jettyContext = new ServletContextHandler((HandlerContainer)jettyServer, "/", null, securityHandler, null, null);
            ServletHolder holder = new ServletHolder((Servlet)new AgentServlet());
            holder.setInitParameter("dispatcherClasses", "org.jolokia.jsr160.Jsr160RequestDispatcher");
            jettyContext.addServlet(holder, "/j4p/*");
            jettyServer.start();
            j4pUrl = "http://localhost:" + port + "/j4p";
            MBeanServer mBeanServer = JolokiaMBeanServerUtil.getJolokiaMBeanServer();
            registeredMBean = mBeanServer.registerMBean(new OperationChecking(JOLOKIA_IT_DOMAIN), new ObjectName("jolokia.it:type=operation")).getObjectName();
        } else {
            j4pUrl = testUrl;
        }
        j4pClient = JolokiaTestEnvironmentSetup.createJ4pClient(j4pUrl);
    }

    @AfterClass
    public static void stop() throws Exception {
        if (registeredMBean != null) {
            JolokiaMBeanServerUtil.getJolokiaMBeanServer().unregisterMBean(registeredMBean);
            registeredMBean = null;
        }
        if (jettyServer != null) {
            jettyServer.stop();
        }
    }

    private static SecurityHandler createSecurityHandler() {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{JOLOKIA});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        HashLoginService loginService = new HashLoginService("Jolokia");
        loginService.putUser(JOLOKIA, (Credential)new Password(JOLOKIA), new String[]{JOLOKIA});
        securityHandler.setLoginService((LoginService)loginService);
        securityHandler.setConstraintMappings(new ConstraintMapping[]{cm});
        return securityHandler;
    }

    protected static J4pClient createJ4pClient(String url) {
        return J4pClient.url((String)url).user(JOLOKIA).password(JOLOKIA).authenticator(new BasicAuthenticator().preemptive()).pooledConnections().build();
    }
}

