/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.internal.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleResourceDelta;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleFile;
import org.jboss.tools.as.test.core.internal.utils.MockModuleFolder;

public class MockModuleUtil {
    public static MockModule createMockWebModule() {
        return MockModuleUtil.createMockWebModule("jst.web", "WebProj");
    }

    public static MockModule createMockWebModule(String name) {
        return MockModuleUtil.createMockWebModule("jst.web", name);
    }

    public static MockModule createMockWebModule(String id, String name) {
        return MockModuleUtil.createMockModule(id, name, "jst.web", "jst.web", "2.5");
    }

    public static MockModule createMockUtilModule() {
        return MockModuleUtil.createMockUtilModule("jst.utility", "UtilProj");
    }

    public static MockModule createMockUtilModule(String id, String name) {
        return MockModuleUtil.createMockModule(id, name, "jst.utility", "jst.utility", "1.0");
    }

    public static MockModule createMockEarModule() {
        return MockModuleUtil.createMockEarModule("jst.ear", "EarProj");
    }

    public static MockModule createMockEarModule(String id, String name) {
        return MockModuleUtil.createMockModule(id, name, "jst.ear", "jst.ear", "1.2");
    }

    public static MockModule createMockModule(String id, String name, String typeId, String typeName, String typeVersion) {
        return new MockModule(id, name, typeId, typeName, typeVersion);
    }

    public static IModuleResourceDelta[] createMockResourceDeltas(List<IModuleResource> list) {
        IPath[] all = new IPath[list.size()];
        int[] kind = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            all[i] = list.get(i).getModuleRelativePath().append(list.get(i).getName());
            kind[i] = 2;
            ++i;
        }
        return MockModuleUtil.createMockResourceDeltas(list, all, kind);
    }

    public static IModuleResource[] getAllResources(IModule module) throws Exception {
        ModuleDelegate dg = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, null);
        return MockModuleUtil.getAllResources(dg.members());
    }

    public static IModuleResource[] getAllResources(IModuleResource[] list) {
        ArrayList<IModuleResource> collector = new ArrayList<IModuleResource>();
        int i = 0;
        while (i < list.length) {
            collector.add(list[i]);
            if (list[i] instanceof IModuleFolder) {
                IModuleResource[] children = ((IModuleFolder)list[i]).members();
                collector.addAll(Arrays.asList(MockModuleUtil.getAllResources(children)));
            }
            ++i;
        }
        return collector.toArray(new IModuleResource[collector.size()]);
    }

    public static IModuleResourceDelta[] createMockResourceDeltas(List<IModuleResource> list, IPath[] leafNodes, int[] kind) {
        ArrayList<IModuleResourceDelta> deltaList = new ArrayList<IModuleResourceDelta>();
        int i = 0;
        while (i < leafNodes.length) {
            MockModuleUtil.addDeltaToList(deltaList, list, leafNodes[i], kind[i]);
            ++i;
        }
        return deltaList.toArray(new IModuleResourceDelta[deltaList.size()]);
    }

    private static IModuleResourceDelta addDeltaToList(ArrayList<IModuleResourceDelta> deltaList, List<IModuleResource> resourceList, IPath p, int kind) {
        IModuleResource mr = MockModuleUtil.findModuleResource(resourceList, p);
        if (mr == null) {
            throw new RuntimeException("Resource " + p.toOSString() + " does not exist in mocked model");
        }
        ModuleResourceDelta thisNodeDelta = new ModuleResourceDelta(mr, kind);
        if (p.segmentCount() == 1) {
            IModuleResourceDelta possibleDuplicate = MockModuleUtil.findDelta(deltaList, p);
            if (possibleDuplicate == null) {
                deltaList.add((IModuleResourceDelta)thisNodeDelta);
                return thisNodeDelta;
            }
            return possibleDuplicate;
        }
        IModuleResourceDelta parentDelta = MockModuleUtil.addDeltaToList(deltaList, resourceList, p.removeLastSegments(1), 2);
        IModuleResourceDelta[] existingChildren = parentDelta.getAffectedChildren();
        ArrayList<Object> tmpChildren = new ArrayList<Object>();
        if (existingChildren != null) {
            int k = 0;
            while (k < existingChildren.length) {
                IModuleResource kResource = existingChildren[k].getModuleResource();
                if (kResource.getName().equals(mr.getName()) && kResource.getModuleRelativePath().equals((Object)mr.getModuleRelativePath())) {
                    return existingChildren[k];
                }
                ++k;
            }
            tmpChildren.addAll(Arrays.asList(existingChildren));
        }
        tmpChildren.add(thisNodeDelta);
        IModuleResourceDelta[] newChildren = tmpChildren.toArray(new IModuleResourceDelta[tmpChildren.size()]);
        ((ModuleResourceDelta)parentDelta).setChildren(newChildren);
        return thisNodeDelta;
    }

    public static IModuleResourceDelta findDelta(IModuleResourceDelta[] deltas, IPath p) {
        ArrayList<IModuleResourceDelta> tmp = new ArrayList<IModuleResourceDelta>();
        tmp.addAll(Arrays.asList(deltas));
        return MockModuleUtil.findDelta(tmp, p);
    }

    public static IModuleResourceDelta findDelta(List<IModuleResourceDelta> list, IPath p) {
        if (p.segmentCount() == 1) {
            int i = 0;
            while (i < list.size()) {
                IModuleResource kDelta = list.get(i).getModuleResource();
                if (kDelta.getName().equals(p.lastSegment()) && kDelta.getModuleRelativePath().equals((Object)p.removeLastSegments(1))) {
                    return list.get(i);
                }
                ++i;
            }
            return null;
        }
        IModuleResourceDelta parentDelta = MockModuleUtil.findDelta(list, p.removeLastSegments(1));
        IModuleResourceDelta[] siblings = parentDelta.getAffectedChildren();
        int i = 0;
        while (i < siblings.length) {
            IModuleResource kDelta = siblings[i].getModuleResource();
            if (kDelta.getName().equals(p.lastSegment()) && kDelta.getModuleRelativePath().equals((Object)p.removeLastSegments(1))) {
                return siblings[i];
            }
            ++i;
        }
        return null;
    }

    private static IModuleResource findModuleResource(List<IModuleResource> list, IPath p) {
        if (p.segmentCount() == 1) {
            return MockModuleUtil.getFromList(list, p.lastSegment());
        }
        MockModuleFolder mf = MockModuleUtil.getExistingMockFolder(list, p.removeLastSegments(1));
        IModuleResource[] children = mf.members();
        return MockModuleUtil.getFromArray(children, p.lastSegment());
    }

    public static IModuleResource[] createMockResources(IPath[] leafNodes, IPath[] emptyFolders) {
        return MockModuleUtil.createMockResources(leafNodes, emptyFolders, null);
    }

    public static IModuleResource[] createMockResources(IPath[] leafNodes, IPath[] emptyFolders, File underlying) {
        IPath trimmed;
        int j;
        int count;
        IPath p;
        ArrayList<IModuleResource> resources = new ArrayList<IModuleResource>();
        int i = 0;
        while (i < leafNodes.length) {
            p = leafNodes[i];
            count = p.segmentCount();
            j = 1;
            while (j <= count) {
                trimmed = p.removeLastSegments(count - j);
                if (j == count) {
                    MockModuleUtil.addMockFile(resources, trimmed, underlying);
                } else {
                    MockModuleUtil.addMockFolder(resources, trimmed);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < emptyFolders.length) {
            p = emptyFolders[i];
            count = p.segmentCount();
            j = 1;
            while (j <= count) {
                trimmed = p.removeLastSegments(count - j);
                MockModuleUtil.addMockFolder(resources, trimmed);
                ++j;
            }
            ++i;
        }
        return resources.toArray(new IModuleResource[resources.size()]);
    }

    private static void addMockFile(ArrayList<IModuleResource> resources, IPath p, File underlying) {
        MockModuleFile newMockFile = new MockModuleFile(p.removeLastSegments(1), p.lastSegment());
        newMockFile.setFile(underlying);
        if (p.segmentCount() == 1) {
            if (!MockModuleUtil.listContains(resources, p.lastSegment())) {
                resources.add((IModuleResource)newMockFile);
            }
            return;
        }
        MockModuleFolder parent = MockModuleUtil.getExistingMockFolder(resources, p.removeLastSegments(1));
        MockModuleFolder parentF = parent;
        IModuleResource[] existing = parentF.members();
        if (existing == null) {
            existing = new IModuleResource[]{newMockFile};
            parentF.setMembers(existing);
            return;
        }
        if (MockModuleUtil.existingContains(existing, p.lastSegment())) {
            return;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(Arrays.asList(existing));
        l.add(newMockFile);
        parentF.setMembers(l.toArray(new IModuleResource[l.size()]));
    }

    private static boolean existingContains(IModuleResource[] all, String name) {
        int i = 0;
        while (i < all.length) {
            if (all[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean listContains(ArrayList<IModuleResource> all, String name) {
        return MockModuleUtil.getFromList(all, name) != null;
    }

    private static IModuleResource getFromList(List<IModuleResource> all, String name) {
        int i = 0;
        while (i < all.size()) {
            if (all.get(i).getName().equals(name)) {
                return all.get(i);
            }
            ++i;
        }
        return null;
    }

    private static IModuleResource getFromArray(IModuleResource[] all, String name) {
        int i = 0;
        while (i < all.length) {
            if (all[i].getName().equals(name)) {
                return all[i];
            }
            ++i;
        }
        return null;
    }

    private static void addMockFolder(ArrayList<IModuleResource> resources, IPath p) {
        MockModuleFolder newMockFolder = new MockModuleFolder(p.removeLastSegments(1), p.lastSegment());
        if (p.segmentCount() == 1) {
            if (!MockModuleUtil.listContains(resources, p.lastSegment())) {
                resources.add((IModuleResource)newMockFolder);
            }
            return;
        }
        MockModuleFolder parent = MockModuleUtil.getExistingMockFolder(resources, p.removeLastSegments(1));
        IModuleResource[] existing = parent.members();
        if (existing == null) {
            existing = new IModuleResource[]{newMockFolder};
            parent.setMembers(existing);
            return;
        }
        if (MockModuleUtil.existingContains(existing, p.lastSegment())) {
            return;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(Arrays.asList(existing));
        l.add(newMockFolder);
        parent.setMembers(l.toArray(new IModuleResource[l.size()]));
    }

    private static MockModuleFolder getExistingMockFolder(List<IModuleResource> resources, IPath p) {
        if (p.segmentCount() == 1) {
            IModuleResource parent = MockModuleUtil.getFromList(resources, p.lastSegment());
            return (MockModuleFolder)parent;
        }
        MockModuleFolder parent = MockModuleUtil.getExistingMockFolder(resources, p.removeLastSegments(1));
        IModuleResource[] existing = parent.members();
        return (MockModuleFolder)MockModuleUtil.getFromArray(existing, p.lastSegment());
    }
}

