/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.internal.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.ide.eclipse.as.core.util.IJBossToolingConstants;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;

public class ServerParameterUtils {
    public static final String ZIPPED = "zipped";
    public static final String UNZIPPED = "unzipped";
    public static final String ZIP_OPTION_UNSET = "zipUnset";
    public static final String DEPLOY_META = "metadata";
    public static final String DEPLOY_SERVER = "server";
    public static final String DEPLOY_CUSTOM_REL = "customRelative";
    public static final String DEPLOY_CUSTOM_ABS = "customAbsolute";
    public static final String DEPLOY_CUSTOM_NULL = "customNull";
    public static final String DEPLOY_PERMOD_DEFAULT = "permod_default";
    public static final String DEPLOY_PERMOD_ABS = "permod_absolute";
    public static final String DEPLOY_PERMOD_REL = "permod_relative";
    public static final String SKIP_PRIVATE_REQUIREMENTS = "org.jboss.tools.tests.skipPrivateRequirements";

    public static Collection<Object[]> asCollection(Object[] items) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        int i = 0;
        while (i < items.length) {
            ret.add(new Object[]{items[i]});
            ++i;
        }
        return ret;
    }

    public static boolean skipPrivateRequirements() {
        return Boolean.getBoolean(SKIP_PRIVATE_REQUIREMENTS);
    }

    public static Object[] getJBossServerTypeParametersPlusAdditionalMocks() {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(ServerParameterUtils.getJBossServerTypeParameters()));
        l.addAll(Arrays.asList(ServerCreationTestUtils.TEST_SERVER_TYPES_TO_MOCK));
        return l.toArray(new String[l.size()]);
    }

    @Deprecated
    public static Object[] getJBossServerTypeParamterers() {
        return ServerParameterUtils.getJBossServerTypeParameters();
    }

    public static String[] getJBossServerTypeParameters() {
        boolean skipReqs = ServerParameterUtils.skipPrivateRequirements();
        ArrayList<String> jbservers = new ArrayList<String>();
        int i = 0;
        while (i < IJBossToolingConstants.ALL_JBOSS_SERVERS.length) {
            if (!skipReqs || !IJBossToolingConstants.ALL_JBOSS_SERVERS[i].startsWith("org.jboss.ide.eclipse.as.eap.")) {
                jbservers.add(IJBossToolingConstants.ALL_JBOSS_SERVERS[i]);
            }
            ++i;
        }
        return jbservers.toArray(new String[jbservers.size()]);
    }

    @Deprecated
    public static String[] getAllJBossServerTypeParamterers() {
        return ServerParameterUtils.getAllJBossServerTypeParameters();
    }

    public static String[] getAllJBossServerTypeParameters() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.jboss.ide.eclipse.as.systemCopyServer");
        list.addAll(Arrays.asList(ServerParameterUtils.getJBossServerTypeParameters()));
        return list.toArray(new String[list.size()]);
    }

    public static String[] getPublishServerTypes() {
        return new String[]{"org.jboss.ide.eclipse.as.systemCopyServer", "org.jboss.ide.eclipse.as.60", "org.jboss.ide.eclipse.as.71"};
    }

    public static String[] getServerZipOptions() {
        return new String[]{ZIPPED, UNZIPPED};
    }

    public static String[] getDefaultDeployOptions() {
        return new String[]{DEPLOY_META, DEPLOY_SERVER, DEPLOY_CUSTOM_NULL, DEPLOY_CUSTOM_ABS, DEPLOY_CUSTOM_REL};
    }

    public static String[] getPerModuleOverrideOptions() {
        return new String[]{DEPLOY_PERMOD_DEFAULT, DEPLOY_PERMOD_ABS, DEPLOY_PERMOD_REL};
    }
}

