/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing.defect;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.validation.ValidationFramework;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.classpath.WorkspaceTestUtil;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.jboss.tools.as.test.core.internal.utils.wtp.ProjectUtility;
import org.jboss.tools.test.util.JobUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClosedProjectPublishTest
extends TestCase {
    private IServer server;
    private IModule module;
    private static boolean preValidation;
    private static boolean preAutoBuild;

    @BeforeClass
    public static void beforeClassSetup() {
        preValidation = ValidationFramework.getDefault().isSuspended();
        preAutoBuild = WorkspaceTestUtil.isAutoBuildEnabled();
        ValidationFramework.getDefault().suspendAllValidation(true);
        WorkspaceTestUtil.setAutoBuildEnabled(false);
    }

    @AfterClass
    public static void afterClassTeardown() {
        ValidationFramework.getDefault().suspendAllValidation(preValidation);
        WorkspaceTestUtil.setAutoBuildEnabled(preAutoBuild);
    }

    @Before
    public void setUp() throws Exception {
        String param_serverType = "org.jboss.ide.eclipse.as.71";
        IServer s = ServerCreationTestUtils.createMockServerWithRuntime(param_serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + param_serverType);
        IDataModel dyn1Model = CreateProjectOperationsUtility.getWebDataModel("cpptd1v", null, null, null, null, JavaEEFacetConstants.WEB_23, true);
        OperationTestCase.runAndVerify(dyn1Model);
        IModule m = ServerUtil.getModule((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject("cpptd1v"));
        this.server = s;
        this.module = m;
        this.addOrRemoveModuleWithPublish(new IModule[]{this.module}, true);
    }

    @After
    public void tearDown() throws Exception {
        JobUtils.waitForIdle((long)100L);
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
        ProjectUtility.deleteAllProjects();
        ASMatrixTests.clearStateLocation();
        JobUtils.waitForIdle();
    }

    private void addOrRemoveModuleWithPublish(IModule[] module, boolean add) throws CoreException {
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        if (add) {
            wc.modifyModules(module, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
        } else {
            wc.modifyModules(new IModule[0], module, (IProgressMonitor)new NullProgressMonitor());
        }
        this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        this.server.publish(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testOpenClosedProject() throws Exception {
        IDeployableServer ds = (IDeployableServer)this.server.loadAdapter(IDeployableServer.class, null);
        IPath p = ds.getDeploymentLocation(new IModule[]{this.module}, true);
        ClosedProjectPublishTest.assertTrue((boolean)p.append("WEB-INF").append("web.xml").toFile().exists());
        this.module.getProject().close((IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        this.server.publish(1, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        ClosedProjectPublishTest.assertTrue((boolean)p.append("WEB-INF").append("web.xml").toFile().exists());
        this.server.publish(2, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        ClosedProjectPublishTest.assertTrue((boolean)p.append("WEB-INF").append("web.xml").toFile().exists());
        this.addOrRemoveModuleWithPublish(new IModule[]{this.module}, false);
        JobUtils.waitForIdle();
        ClosedProjectPublishTest.assertFalse((boolean)p.append("WEB-INF").append("web.xml").toFile().exists());
        this.addOrRemoveModuleWithPublish(new IModule[]{this.module}, true);
        JobUtils.waitForIdle();
        ClosedProjectPublishTest.assertFalse((boolean)p.append("WEB-INF").append("web.xml").toFile().exists());
        this.module.getProject().open((IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        ClosedProjectPublishTest.assertFalse((boolean)p.append("WEB-INF").append("web.xml").toFile().exists());
        this.server.publish(1, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        ClosedProjectPublishTest.assertTrue((boolean)p.append("WEB-INF").append("web.xml").toFile().exists());
    }
}

