/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing.defect;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;
import org.jboss.tools.as.test.core.subsystems.impl.CustomPublishController;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalAfterFullPublishDefectTest
extends AbstractPublishingTest {
    private IModule[] module;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        String[] servers = new String[]{"org.jboss.ide.eclipse.as.71", "org.jboss.ide.eclipse.as.systemCopyServer"};
        Object[][] allOptions = new Object[][]{servers};
        return MatrixUtils.toMatrix(allOptions);
    }

    public IncrementalAfterFullPublishDefectTest(String serverType) {
        super(serverType, "unzipped", "metadata", "permod_default");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp(false);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void createProjects() throws Exception {
        this.module = this.createUtilInWebInEarModule();
        this.addModuleToServer(this.module[0]);
    }

    @Test
    public void testPublish() throws Exception {
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule[] ear = new IModule[]{this.module[0]};
        IModule[] webInEar = new IModule[]{this.module[0], this.module[1]};
        IModule[] utilInWebInEar = new IModule[]{this.module[0], this.module[1], this.module[2]};
        this.fullPublishAll(controller, ear, webInEar, utilInWebInEar);
        IPath depPath = controller.getDeployPathController().getDeployDirectory(ear);
        int totalAfterFull = this.countChildrenRecurse(depPath.toFile());
        ((Server)this.server).setModulePublishState(ear, 3);
        ((Server)this.server).setModulePublishState(webInEar, 1);
        ((Server)this.server).setModulePublishState(utilInWebInEar, 1);
        this.publishIncremental(controller, ear, webInEar, utilInWebInEar);
        depPath = controller.getDeployPathController().getDeployDirectory(ear);
        int totalAfterIncr = this.countChildrenRecurse(depPath.toFile());
        IncrementalAfterFullPublishDefectTest.assertEquals((int)totalAfterFull, (int)totalAfterIncr);
    }

    private int countChildrenRecurse(File f) {
        int count = 1;
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            int i = 0;
            while (i < children.length) {
                count += this.countChildrenRecurse(children[i]);
                ++i;
            }
        }
        return count;
    }

    private void fullPublishAll(CustomPublishController controller, IModule[] ear, IModule[] webInEar, IModule[] utilInWebInEar) throws CoreException {
        controller.publishStart((IProgressMonitor)new NullProgressMonitor());
        controller.publishServer(1, (IProgressMonitor)new NullProgressMonitor());
        int resultEar = controller.publishModule(2, 1, ear, (IProgressMonitor)new NullProgressMonitor());
        int resultWeb = controller.publishModule(2, 1, webInEar, (IProgressMonitor)new NullProgressMonitor());
        int resultUtil = controller.publishModule(2, 1, utilInWebInEar, (IProgressMonitor)new NullProgressMonitor());
        controller.publishFinish((IProgressMonitor)new NullProgressMonitor());
        IncrementalAfterFullPublishDefectTest.assertEquals((int)resultEar, (int)1);
        IncrementalAfterFullPublishDefectTest.assertEquals((int)resultWeb, (int)1);
        IncrementalAfterFullPublishDefectTest.assertEquals((int)resultUtil, (int)1);
    }

    private void publishIncremental(CustomPublishController controller, IModule[] ear, IModule[] webInEar, IModule[] utilInWebInEar) throws CoreException {
        controller.publishStart((IProgressMonitor)new NullProgressMonitor());
        controller.publishServer(1, (IProgressMonitor)new NullProgressMonitor());
        int resultEar = controller.publishModule(1, 2, ear, (IProgressMonitor)new NullProgressMonitor());
        int resultWeb = controller.publishModule(1, 2, webInEar, (IProgressMonitor)new NullProgressMonitor());
        int resultUtil = controller.publishModule(1, 2, utilInWebInEar, (IProgressMonitor)new NullProgressMonitor());
        controller.publishFinish((IProgressMonitor)new NullProgressMonitor());
        IncrementalAfterFullPublishDefectTest.assertEquals((int)resultEar, (int)1);
        IncrementalAfterFullPublishDefectTest.assertEquals((int)resultWeb, (int)1);
        IncrementalAfterFullPublishDefectTest.assertEquals((int)resultUtil, (int)1);
    }

    private IPath getUnderlying() {
        IPath underlying = ASMatrixTests.getDefault().getStateLocation().append("underlying.txt");
        return underlying;
    }

    private IPath setUnderlyingVersion(int v) throws Exception {
        IPath underlying = this.getUnderlying();
        underlying.toFile().getParentFile().mkdirs();
        IOUtil.setContents(underlying.toFile(), "version" + v);
        return underlying;
    }

    private IPath[] getEarLeafPaths() {
        return new IPath[]{new Path("META-INF/application.xml")};
    }

    private IPath[] getUtilLeafPaths() {
        return new IPath[]{new Path("Clazz1.class"), new Path("Clazz2.class"), new Path("Clazz3.class")};
    }

    private IPath[] getWebLeafPaths() {
        IPath[] leafs = new IPath[]{new Path("w"), new Path("x"), new Path("y"), new Path("z"), new Path("a/a1"), new Path("a/a2"), new Path("a/q1"), new Path("a/q2"), new Path("b/b1"), new Path("b/b2"), new Path("b/b3"), new Path("b/b4"), new Path("c/y1"), new Path("c/y2.png"), new Path("c/y3.jpg"), new Path("c/y4.pdf"), new Path("d/F/f1.jar"), new Path("d/F/f2.txt"), new Path("d/F/f3.txt"), new Path("d/F/f4.txt")};
        return leafs;
    }

    private MockModule[] createUtilInWebInEarModule() throws Exception {
        IPath underlying = this.setUnderlyingVersion(1);
        MockModule ear = MockModuleUtil.createMockEarModule();
        MockModule web = MockModuleUtil.createMockWebModule();
        MockModule util = MockModuleUtil.createMockUtilModule();
        ear.addChildModule(web, "web.war");
        web.addChildModule(util, "WEB-INF/lib/util.jar");
        IPath[] earLeafs = this.getEarLeafPaths();
        IModuleResource[] earR = MockModuleUtil.createMockResources(earLeafs, new IPath[0], underlying.toFile());
        ear.setMembers(earR);
        ear.setExists(true);
        ear.setExternal(true);
        IPath[] webLeafs = this.getWebLeafPaths();
        IModuleResource[] webR = MockModuleUtil.createMockResources(webLeafs, new IPath[0], underlying.toFile());
        web.setMembers(webR);
        web.setExists(true);
        web.setExternal(true);
        IPath[] utilLeafs = this.getUtilLeafPaths();
        IModuleResource[] utilR = MockModuleUtil.createMockResources(utilLeafs, new IPath[0], underlying.toFile());
        util.setMembers(utilR);
        util.setExists(true);
        util.setExternal(true);
        return new MockModule[]{ear, web, util};
    }

    protected void verifyListRelativePath(IPath root, List<IPath> list, boolean exists) {
        ArrayList<IPath> list2 = new ArrayList<IPath>();
        Iterator<IPath> i = list.iterator();
        while (i.hasNext()) {
            list2.add(root.append(i.next()));
        }
        super.verifyList(root, list2, exists);
    }
}

