/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing.defect;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.jmx.core.test.util.TestProjectProvider;
import org.jboss.tools.test.util.JobUtils;
import org.junit.Before;
import org.junit.Test;

public class PublishWeb2DeletesWeb1LibsTest
extends TestCase {
    TestProjectProvider[] providers = null;
    IProject[] projects = null;
    IServer server;

    @Before
    public void setUp() throws Exception {
        TestProjectProvider util1Provider = new TestProjectProvider("org.jboss.tools.as.test.core", null, "UserForum1Util1", true);
        IProject util1Project = util1Provider.getProject();
        util1Project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        TestProjectProvider util2Provider = new TestProjectProvider("org.jboss.tools.as.test.core", null, "UserForum1Util2", true);
        IProject util2Project = util2Provider.getProject();
        util2Project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        TestProjectProvider ejb1Provider = new TestProjectProvider("org.jboss.tools.as.test.core", null, "UserForum1EJB1", true);
        IProject ejb1Project = ejb1Provider.getProject();
        ejb1Project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        TestProjectProvider web1Provider = new TestProjectProvider("org.jboss.tools.as.test.core", null, "UserForum1Web1", true);
        IProject web1Project = web1Provider.getProject();
        web1Project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        TestProjectProvider web2Provider = new TestProjectProvider("org.jboss.tools.as.test.core", null, "UserForum1Web2", true);
        IProject web2Project = web2Provider.getProject();
        web2Project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        this.projects = new IProject[]{util1Project, util2Project, ejb1Project, web1Project, web2Project};
        this.providers = new TestProjectProvider[]{util1Provider, util2Provider, ejb1Provider, web1Provider, web2Provider};
        int i = 0;
        while (i < this.projects.length) {
            PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)this.projects[i].exists());
            PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)this.projects[i].isAccessible());
            PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)this.projects[i].isNatureEnabled("org.eclipse.wst.common.project.facet.core.nature"));
            ++i;
        }
        this.server = ServerCreationTestUtils.createServerWithRuntime("org.jboss.ide.eclipse.as.systemCopyServer", ((Object)((Object)this)).getClass().getName());
    }

    private void addModuleAndFullPublish(String projectName) throws CoreException {
        IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)this.server);
        this.server = this.addModuleToServer(this.findModuleForProject(projectName));
        this.server.publish(2, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
    }

    @Test
    public void testFullPublishes() throws CoreException {
        this.addModuleAndFullPublish("UserForum1EJB1");
        this.verifyEJBAndJarExist();
        this.addModuleAndFullPublish("UserForum1Web1");
        this.verifyEJBAndJarExist();
        this.verifyWeb1AndLibsExist();
        this.addModuleAndFullPublish("UserForum1Web2");
        this.verifyEJBAndJarExist();
        this.verifyWeb1AndLibsExist();
        this.verifyWeb2AndLibsExist();
    }

    private void verifyEJBAndJarExist() {
        IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)this.server);
        IPath fullPath = ds.getDeploymentLocation(this.findArrayForProject("UserForum1EJB1"), true);
        PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)fullPath.toFile().exists());
        PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)fullPath.append("UserForum1Util1.jar").toFile().exists());
    }

    private void verifyWeb1AndLibsExist() {
        IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)this.server);
        IPath fullPath = ds.getDeploymentLocation(this.findArrayForProject("UserForum1Web1"), true);
        PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)fullPath.toFile().exists());
        PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)fullPath.append("WEB-INF").append("lib").append("UserForum1Util1.jar").toFile().exists());
        PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)fullPath.append("WEB-INF").append("lib").append("UserForum1Util2.jar").toFile().exists());
    }

    private void verifyWeb2AndLibsExist() {
        IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)this.server);
        IPath fullPath = ds.getDeploymentLocation(this.findArrayForProject("UserForum1Web2"), true);
        PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)fullPath.toFile().exists());
        PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)fullPath.append("WEB-INF").append("lib").append("UserForum1Util1.jar").toFile().exists());
        PublishWeb2DeletesWeb1LibsTest.assertTrue((boolean)fullPath.append("WEB-INF").append("lib").append("UserForum1Util2.jar").toFile().exists());
    }

    public IModule[] findArrayForProject(String projectName) {
        return new IModule[]{this.findModuleForProject(projectName)};
    }

    public IModule findModuleForProject(String projectName) {
        return ServerUtil.getModule((IProject)ResourceUtils.findProject(projectName));
    }

    public IServer addModuleToServer(IModule module) throws CoreException {
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        wc.modifyModules(new IModule[]{module}, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
        return wc.save(true, null);
    }
}

