/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing.sar;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.j2ee.application.internal.operations.AddReferenceToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServer;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ProjectRuntimeUtil;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.jboss.tools.test.util.JobUtils;

public class JBossSarProjectCreationTest
extends TestCase {
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }

    public void testProjectCreation1() {
        try {
            IDataModel sar1Model = CreateProjectOperationsUtility.getSarDataModel("sar1a", null, null, null, JavaEEFacetConstants.SAR_1);
            OperationTestCase.runAndVerify(sar1Model);
            JobUtils.waitForIdle((long)1000L);
            IProject sar = ResourcesPlugin.getWorkspace().getRoot().getProject("sar1a");
            JBossSarProjectCreationTest.assertTrue((boolean)sar.getFolder("sarcontent").exists());
            JBossSarProjectCreationTest.assertTrue((boolean)sar.getFolder("sarcontent").getFolder("META-INF").exists());
            JBossSarProjectCreationTest.assertTrue((boolean)sar.getFolder("src").exists());
            JBossSarProjectCreationTest.assertTrue((boolean)sar.getFolder("build").exists());
            JBossSarProjectCreationTest.assertTrue((boolean)sar.getFolder("build").getFolder("classes").exists());
            JBossSarProjectCreationTest.assertNull((Object)ProjectRuntimeUtil.getRuntime(sar));
        }
        catch (Exception e) {
            e.printStackTrace();
            JBossSarProjectCreationTest.fail((String)e.getMessage());
        }
    }

    public void testProjectCreationNonDefaultSrcContentOutput() {
        try {
            IDataModel sar1Model = CreateProjectOperationsUtility.getSarDataModel("sar1b", "src2", "sarcontent2", "bin", JavaEEFacetConstants.SAR_1);
            OperationTestCase.runAndVerify(sar1Model);
            JobUtils.waitForIdle((long)1000L);
            IProject sar = ResourcesPlugin.getWorkspace().getRoot().getProject("sar1b");
            System.out.println(sar.getLocation().toOSString());
            JBossSarProjectCreationTest.assertTrue((boolean)sar.getFolder("sarcontent2").exists());
            JBossSarProjectCreationTest.assertTrue((boolean)sar.getFolder("sarcontent2").getFolder("META-INF").exists());
            JBossSarProjectCreationTest.assertTrue((boolean)sar.getFolder("src2").exists());
            JBossSarProjectCreationTest.assertTrue((boolean)sar.getFolder("bin").exists());
            JBossSarProjectCreationTest.assertNull((Object)ProjectRuntimeUtil.getRuntime(sar));
        }
        catch (Exception e) {
            e.printStackTrace();
            JBossSarProjectCreationTest.fail((String)e.getMessage());
        }
    }

    public void testSarInsideEarAsChildModule() {
        this.createSarInEarAndVerify("sar1dear", "sar1g", "server1", new Path("lib").makeAbsolute());
    }

    public void testSarInsideEarMemberResourcesSafe() {
        this.createSarInEarAndVerify("sar1kear", "sar1k", "server4", new Path("lib").makeAbsolute());
        IProject earProj = ResourcesPlugin.getWorkspace().getRoot().getProject("sar1kear");
        IModule mod = ServerUtil.getModule((IProject)earProj);
        ModuleDelegate md = (ModuleDelegate)mod.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        try {
            IModuleResource sar = this.getResourceAtPath(md.members(), (IPath)new Path("lib/sar1k.sar"));
            JBossSarProjectCreationTest.assertNull((Object)sar);
            IModule[] children = md.getChildModules();
            JBossSarProjectCreationTest.assertTrue((children.length > 0 ? 1 : 0) != 0);
        }
        catch (CoreException ce) {
            JBossSarProjectCreationTest.fail((String)("Unable to get members for ear module: " + ce.getMessage()));
        }
    }

    protected IModuleResource getResourceAtPath(IModuleResource[] resources, IPath toFind) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getName().equals(toFind.segment(0))) {
                if (toFind.segmentCount() == 1) {
                    return resources[i];
                }
                if (resources[i] instanceof IModuleFile) {
                    return null;
                }
                return this.getResourceAtPath(((IModuleFolder)resources[i]).members(), toFind.removeFirstSegments(1));
            }
            ++i;
        }
        return null;
    }

    public void testSarInsideEarPublish() {
        this.createSarInEarAndVerify("sar1fear", "sar1h", "server2", new Path("lib").makeAbsolute());
        IProject earProj = ResourcesPlugin.getWorkspace().getRoot().getProject("sar1fear");
        IProject sarProj = ResourcesPlugin.getWorkspace().getRoot().getProject("sar1h");
        IFile testClass = sarProj.getFolder("src").getFile("MyTestClass.java");
        String contents = "public class MyTestClass { }";
        try {
            testClass.create((InputStream)new ByteArrayInputStream(contents.getBytes()), false, null);
        }
        catch (CoreException ce) {
            JBossSarProjectCreationTest.fail((String)("Unable to create test class at path " + testClass.getFullPath().toOSString()));
        }
        JobUtils.waitForIdle((long)1500L);
        IModule earModule = ServerUtil.getModule((IProject)earProj);
        IServer s = ServerCore.findServer((String)"server2");
        try {
            IServerWorkingCopy wc = s.createWorkingCopy();
            wc.modifyModules(new IModule[]{earModule}, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
            s = wc.save(false, null);
        }
        catch (CoreException ce) {
            JBossSarProjectCreationTest.fail((String)"Unable to add ear module with nested sar to server");
        }
        s.publish(2, null);
        DeployableServer ds = (DeployableServer)s.loadAdapter(DeployableServer.class, null);
        IPath deepDeployFolder = ds.getDeploymentLocation(new IModule[]{earModule}, true);
        JBossSarProjectCreationTest.assertTrue((boolean)deepDeployFolder.toFile().exists());
        JBossSarProjectCreationTest.assertTrue((boolean)deepDeployFolder.toFile().isDirectory());
        JBossSarProjectCreationTest.assertTrue((boolean)deepDeployFolder.append("lib").toFile().exists());
        JBossSarProjectCreationTest.assertTrue((boolean)deepDeployFolder.append("lib").toFile().isDirectory());
        IPath sar1h = deepDeployFolder.append("lib").append("sar1h.sar");
        JBossSarProjectCreationTest.assertTrue((boolean)sar1h.toFile().exists());
        JBossSarProjectCreationTest.assertTrue((boolean)sar1h.toFile().isDirectory());
        JBossSarProjectCreationTest.assertTrue((boolean)sar1h.append("META-INF").toFile().exists());
        JBossSarProjectCreationTest.assertTrue((boolean)sar1h.append("META-INF").toFile().isDirectory());
        JBossSarProjectCreationTest.assertTrue((boolean)sar1h.append("MyTestClass.class").toFile().exists());
        JBossSarProjectCreationTest.assertTrue((boolean)sar1h.append("MyTestClass.class").toFile().isFile());
        JBossSarProjectCreationTest.assertFalse((boolean)sar1h.append("MyTestClass.java").toFile().exists());
    }

    protected void createSarInEarAndVerify(String earName, String sarName, String serverName, IPath rootRelativePath) {
        try {
            this.createSarAndEarProjects(earName, sarName);
            this.addSarReferenceToEar(earName, sarName, rootRelativePath);
            IServer s = ServerCreationTestUtils.createMockServerWithRuntime("org.jboss.ide.eclipse.as.60", serverName);
            JBossSarProjectCreationTest.assertNotNull((Object)s);
            JBossSarProjectCreationTest.assertEquals((String)serverName, (String)s.getName());
            this.verifyParentChildRelationship(s, earName, sarName);
        }
        catch (Exception e) {
            e.printStackTrace();
            JBossSarProjectCreationTest.fail((String)e.getMessage());
        }
    }

    protected void createSarAndEarProjects(String earName, String sarName) throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel(earName, "earContent", null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify(dm);
        IDataModel sar1Model = CreateProjectOperationsUtility.getSarDataModel(sarName, null, null, null, JavaEEFacetConstants.SAR_1);
        OperationTestCase.runAndVerify(sar1Model);
    }

    protected void verifyParentChildRelationship(IServer s, String earName, String sarName) {
        IProject earProj = ResourcesPlugin.getWorkspace().getRoot().getProject(earName);
        IProject sarProj = ResourcesPlugin.getWorkspace().getRoot().getProject(sarName);
        IModule earModule = ServerUtil.getModule((IProject)earProj);
        IModule sarModule = ServerUtil.getModule((IProject)sarProj);
        IModule[] childModules = s.getChildModules(new IModule[]{earModule}, null);
        JBossSarProjectCreationTest.assertNotNull((Object)childModules);
        int i = 0;
        while (i < childModules.length) {
            if (childModules[i].equals(sarModule)) {
                return;
            }
            ++i;
        }
        JBossSarProjectCreationTest.fail((String)"Sar module not found as child of ear module");
    }

    protected void addSarReferenceToEar(String earName, String sarName, IPath rootRelativePath) throws CoreException {
        IProject earProj = ResourcesPlugin.getWorkspace().getRoot().getProject(earName);
        IProject sarProj = ResourcesPlugin.getWorkspace().getRoot().getProject(sarName);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProj);
        IVirtualComponent sarComp = ComponentCore.createComponent((IProject)sarProj);
        VirtualReference ref = new VirtualReference(earComp, sarComp);
        ref.setArchiveName(String.valueOf(sarProj.getName()) + ".sar");
        ref.setRuntimePath(rootRelativePath);
        AddReferenceToEnterpriseApplicationDataModelProvider provider = new AddReferenceToEnterpriseApplicationDataModelProvider();
        IDataModel addDm = DataModelFactory.createDataModel((IDataModelProvider)provider);
        addDm.setProperty("IAddReferenceDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
        addDm.setProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST", Arrays.asList(ref));
        IStatus stat = addDm.validateProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST");
        if (stat != IDataModelProvider.OK_STATUS) {
            throw new CoreException(stat);
        }
        try {
            addDm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            JBossSarProjectCreationTest.fail((String)e.getMessage());
        }
    }

    public void testProjectRuntimeModifyingClasspath() {
        try {
            IServer s = ServerCreationTestUtils.createMockServerWithRuntime("org.jboss.ide.eclipse.as.60", "server1");
            JBossSarProjectCreationTest.assertNotNull((Object)s);
            JBossSarProjectCreationTest.assertEquals((String)"server1", (String)s.getName());
            IRuntime rt = s.getRuntime();
            JBossSarProjectCreationTest.assertNotNull((Object)rt);
            IRuntime rt2 = RuntimeUtils.createRuntime((String)rt.getRuntimeType().getId(), (String)(String.valueOf(rt.getName()) + "v2"), (String)rt.getLocation().toOSString(), (String)"default", (IVMInstall)JavaRuntime.getDefaultVMInstall());
            IDataModel sar1Model = CreateProjectOperationsUtility.getSarDataModel("sar1c", null, null, null, JavaEEFacetConstants.SAR_1);
            OperationTestCase.runAndVerify(sar1Model);
            JobUtils.waitForIdle((long)1000L);
            IProject sar = ResourcesPlugin.getWorkspace().getRoot().getProject("sar1c");
            try {
                IJavaProject jp = JavaCore.create((IProject)sar);
                IClasspathEntry[] raw1 = jp.getRawClasspath();
                JBossSarProjectCreationTest.assertEquals((int)raw1.length, (int)2);
                ProjectRuntimeUtil.setTargetRuntime(rt, sar);
                raw1 = jp.getRawClasspath();
                JBossSarProjectCreationTest.assertEquals((int)raw1.length, (int)3);
                IPath desiredEntry = this.getContainerPathForRuntime(rt);
                boolean found = false;
                int i = 0;
                while (i < raw1.length) {
                    if (raw1[i].getPath().equals((Object)desiredEntry)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                JBossSarProjectCreationTest.assertTrue((boolean)found);
                ProjectRuntimeUtil.setTargetRuntime(rt2, sar);
                raw1 = jp.getRawClasspath();
                desiredEntry = this.getContainerPathForRuntime(rt2);
                JBossSarProjectCreationTest.assertEquals((int)raw1.length, (int)3);
                found = false;
                i = 0;
                while (i < raw1.length) {
                    if (raw1[i].getPath().equals((Object)desiredEntry)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                JBossSarProjectCreationTest.assertTrue((boolean)found);
                ProjectRuntimeUtil.clearRuntime(sar);
                raw1 = jp.getRawClasspath();
                JBossSarProjectCreationTest.assertEquals((int)raw1.length, (int)2);
            }
            catch (JavaModelException jme) {
                jme.printStackTrace();
                JBossSarProjectCreationTest.fail((String)jme.getMessage());
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                JBossSarProjectCreationTest.fail((String)ce.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected IPath getContainerPathForRuntime(IRuntime rt) {
        RuntimeClasspathProviderWrapper rcpw = JavaServerPlugin.findRuntimeClasspathProvider((IRuntimeType)rt.getRuntimeType());
        IPath serverContainerPath = new Path("org.eclipse.jst.server.core.container").append(rcpw.getId()).append(rt.getId());
        return serverContainerPath;
    }
}

