/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeploymentOptionsSubsystemResolutionTest
extends TestCase {
    private String serverType;
    private String mode;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        String[] servers = ServerParameterUtils.getJBossServerTypeParameters();
        String[] stringArray = new String[5];
        stringArray[0] = "local";
        stringArray[1] = "rse";
        stringArray[2] = "local.mgmt";
        stringArray[3] = "rse.mgmt";
        String[] modes = stringArray;
        return MatrixUtils.toMatrix(new Object[][]{servers, modes});
    }

    public DeploymentOptionsSubsystemResolutionTest(String serverType, String mode) {
        this.serverType = serverType;
        this.mode = mode;
    }

    @Before
    public void setUp() throws Exception {
        this.server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)this.mode);
        this.server = wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testResolution() throws Exception {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.server);
        DeploymentOptionsSubsystemResolutionTest.assertNotNull((Object)beh);
        try {
            ISubsystemController controller = beh.getController("deploymentOptions");
            if (this.mode != null) {
                DeploymentOptionsSubsystemResolutionTest.assertFalse((boolean)this.mode.contains(".mgmt"));
            }
            DeploymentOptionsSubsystemResolutionTest.assertNotNull((Object)controller);
        }
        catch (CoreException ce) {
            DeploymentOptionsSubsystemResolutionTest.assertTrue((boolean)this.mode.contains(".mgmt"));
        }
    }
}

