/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.util.Collection;
import junit.framework.TestCase;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ServerProfileTest
extends TestCase {
    private String serverType;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        String[] allServers = ServerParameterUtils.getAllJBossServerTypeParameters();
        return MatrixUtils.toMatrix(new Object[][]{allServers});
    }

    public ServerProfileTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testResolution() throws Exception {
        boolean localRequiresRuntime = ServerProfileModel.getDefault().profileRequiresRuntime(this.serverType, "local");
        ServerProfileTest.assertTrue((boolean)localRequiresRuntime);
        boolean rseRequiresRuntime = ServerProfileModel.getDefault().profileRequiresRuntime(this.serverType, "rse");
        ServerProfileTest.assertFalse((boolean)rseRequiresRuntime);
    }
}

