/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.tools;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;
import org.jboss.tools.common.jdt.debug.tools.ToolsCore;
import org.jboss.tools.common.jdt.debug.tools.ToolsCoreException;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IHost;
import org.jboss.tools.jmx.jvmmonitor.core.IJvmAttachHandler;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.IConstants;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.Messages;
import org.jboss.tools.jmx.jvmmonitor.tools.Activator;

public class JvmAttachHandler
implements IJvmAttachHandler,
IEclipsePreferences.IPreferenceChangeListener,
IConstants {
    private IHost localhost;
    Timer timer;

    public void setHost(IHost host) {
        this.localhost = host;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.tools.jmx.jvmmonitor.tools");
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public boolean hasValidJdk() {
        return ToolsCore.isToolsReady();
    }

    private void startMonitoring() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    JvmAttachHandler.this.updatesActiveJvms();
                }
                catch (Throwable t) {
                    Activator.log(4, Messages.updateTimerCanceledMsg, t);
                    JvmAttachHandler.this.timer.cancel();
                }
            }
        };
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.tools.jmx.jvmmonitor.tools");
        long period = prefs.getLong("org.jboss.tools.jmx.jvmmonitor.tools.updatePeriod", 3000L);
        this.timer.schedule(timerTask, 0L, period);
    }

    void updatesActiveJvms() throws JvmCoreException {
        try {
            Set activeJvms = ToolsCore.getActiveProcessIds((String)"localhost");
            List previousVms = this.localhost.getActiveJvms();
            Iterator iterator = activeJvms.iterator();
            while (iterator.hasNext()) {
                int pid = (Integer)iterator.next();
                if (JvmAttachHandler.containJvm(previousVms, pid)) {
                    boolean terminated;
                    boolean bl = terminated = RemoteDebugActivator.getDefault().getVmModel("localhost", Integer.valueOf(pid), true, (IProgressMonitor)new NullProgressMonitor()) == null;
                    if (!terminated) continue;
                    this.localhost.removeJvm(pid);
                    continue;
                }
                this.addActiveJvm(pid, "localhost");
            }
            for (IActiveJvm jvm : previousVms) {
                Integer pid = jvm.getPid();
                if (activeJvms.contains(pid)) continue;
                this.localhost.removeJvm(pid.intValue());
            }
        }
        catch (ToolsCoreException tce) {
            throw new JvmCoreException(tce.getStatus().getSeverity(), tce.getMessage(), (Throwable)tce);
        }
    }

    private static boolean containJvm(List<IActiveJvm> jvms, int pid) {
        for (IActiveJvm jvm : jvms) {
            if (jvm.getPid() != pid) continue;
            return true;
        }
        return false;
    }

    private void addActiveJvm(int pid, String host) {
        ToolsCore.MonitoredVM vm = null;
        try {
            vm = ToolsCore.getMonitoredVm((String)host, (int)pid);
        }
        catch (ToolsCoreException e) {
            return;
        }
        String mainClass = null;
        String launchCommand = null;
        try {
            if (vm != null) {
                try {
                    mainClass = JvmAttachHandler.getMainClass(host, pid);
                    launchCommand = JvmAttachHandler.getJavaCommand(host, pid);
                }
                catch (Exception tce) {
                    Activator.log(2, NLS.bind((String)Messages.connectTargetJvmFailedMsg, (Object)pid), tce);
                }
            }
            this.localhost.addLocalActiveJvm(pid, mainClass, launchCommand, vm == null ? vm : vm.getMonitoredVM(), null);
        }
        catch (JvmCoreException e) {
            Activator.log(2, NLS.bind((String)Messages.connectTargetJvmFailedMsg, (Object)pid), e);
        }
    }

    private static String getMainClass(String host, int pid) throws ToolsCoreException {
        return ToolsCore.getMainClass((String)host, (int)pid);
    }

    private static String getJavaCommand(String host, int pid) throws ToolsCoreException {
        return ToolsCore.getJavaCommand((String)host, (int)pid);
    }

    public String getLocalConnectorAddress(Object monitoredVm, int pid) throws JvmCoreException {
        try {
            return this.getLocalConnectorAddressInternal(monitoredVm, pid);
        }
        catch (JvmCoreException e) {
            String message = NLS.bind((String)Messages.getLocalConnectorAddressFailedMsg, (Object)pid);
            Activator.log(2, message, e);
            return null;
        }
    }

    public String getLocalConnectorAddressInternal(Object monitoredVm, int pid) throws JvmCoreException {
        String url = null;
        ToolsCore.AttachedVM virtualMachine = null;
        try {
            try {
                virtualMachine = ToolsCore.attach((int)pid);
                String javaHome = ToolsCore.getSystemProperties((ToolsCore.AttachedVM)virtualMachine).getProperty("java.home");
                File file = new File(String.valueOf(javaHome) + IConstants.MANAGEMENT_AGENT_JAR);
                if (!file.exists()) {
                    String message = NLS.bind((String)Messages.fileNotFoundMsg, (Object)file.getPath());
                    throw new JvmCoreException(4, message, (Throwable)new Exception());
                }
                ToolsCore.loadAgent((ToolsCore.AttachedVM)virtualMachine, (String)file.getAbsolutePath(), (String)"com.sun.management.jmxremote");
                Properties props = ToolsCore.getAgentProperties((ToolsCore.AttachedVM)virtualMachine);
                url = (String)props.get("com.sun.management.jmxremote.localConnectorAddress");
            }
            catch (ToolsCoreException tce) {
                throw new JvmCoreException(4, tce.getMessage(), (Throwable)tce);
            }
        }
        finally {
            if (virtualMachine != null) {
                try {
                    ToolsCore.detach((ToolsCore.AttachedVM)virtualMachine);
                }
                catch (ToolsCoreException toolsCoreException) {}
            }
        }
        return url;
    }

    public synchronized void beginPolling() {
        this.startMonitoring();
    }

    public synchronized void suspendPolling() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void refreshJVMs() throws JvmCoreException {
        this.updatesActiveJvms();
    }

    public synchronized boolean isPolling() {
        return this.timer != null;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        this.startMonitoring();
    }
}

