/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.ui.containers.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IRuntimeType;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.ui.containers.custom.FilesetClasspathProviderFragment;
import org.jboss.ide.eclipse.as.classpath.ui.containers.custom.LayeredPathProviderFragment;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.tools.foundation.core.tasks.TaskModel;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.TaskWizard;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;

public class RuntimeClasspathProviderWizard
extends TaskWizard {
    static final String RUNTIME_TYPE = "rtType";
    static final String PROVIDER_TYPE = "pathProviderType";
    static final String CREATED_PATH_PROVIDER = "createdProvider";
    private static RuntimePathProviderType[] types = new RuntimePathProviderType[]{new FilesetRuntimePathProviderTypeImpl(), new LayeredRuntimePathProviderTypeImpl()};

    public RuntimeClasspathProviderWizard(IRuntimeType rtType) {
        super("New Default Classpath Entry", (WizardFragment)new RootFragment());
        this.getTaskModel().putObject(RUNTIME_TYPE, (Object)rtType);
    }

    private static RuntimePathProviderType[] getTypesForRuntime(TaskModel tm) {
        ArrayList<RuntimePathProviderType> c = new ArrayList<RuntimePathProviderType>();
        int i = 0;
        while (i < types.length) {
            if (types[i].isValidFor((IRuntimeType)tm.getObject(RUNTIME_TYPE))) {
                c.add(types[i]);
            }
            ++i;
        }
        return c.toArray(new RuntimePathProviderType[c.size()]);
    }

    public IRuntimePathProvider getRuntimePathProvider() {
        return (IRuntimePathProvider)this.getTaskModel().getObject(CREATED_PATH_PROVIDER);
    }

    private static class FilesetRuntimePathProviderTypeImpl
    implements RuntimePathProviderType {
        private FilesetRuntimePathProviderTypeImpl() {
        }

        @Override
        public boolean isValidFor(IRuntimeType type) {
            return true;
        }

        @Override
        public String getName() {
            return "Standard Fileset";
        }
    }

    private static class LayeredRuntimePathProviderTypeImpl
    implements RuntimePathProviderType {
        private LayeredRuntimePathProviderTypeImpl() {
        }

        @Override
        public boolean isValidFor(IRuntimeType type) {
            ServerExtendedProperties props;
            ServerExtendedProperties serverExtendedProperties = props = type == null ? null : (ServerExtendedProperties)Platform.getAdapterManager().getAdapter((Object)type, ServerExtendedProperties.class);
            return props != null && props.getFileStructure() == 2;
        }

        @Override
        public String getName() {
            return "JBoss Module";
        }
    }

    protected static class RootFragment
    extends WizardFragment {
        private SelectFilesetTypeFragment selectTypeFragment = null;

        protected RootFragment() {
        }

        protected void createChildFragments(List<WizardFragment> list) {
            if (this.selectTypeFragment == null) {
                this.selectTypeFragment = new SelectFilesetTypeFragment();
            }
            list.add(this.selectTypeFragment);
        }
    }

    private static interface RuntimePathProviderType {
        public boolean isValidFor(IRuntimeType var1);

        public String getName();
    }

    protected static class SelectFilesetTypeFragment
    extends WizardFragment {
        private IWizardHandle handle;
        private ITreeContentProvider contentProvider;
        private TreeViewer viewer;
        private LayeredPathProviderFragment layeredFragment = null;
        private FilesetClasspathProviderFragment filesetFragment = null;

        protected SelectFilesetTypeFragment() {
        }

        public boolean hasComposite() {
            return true;
        }

        public Composite createComposite(Composite parent, IWizardHandle handle) {
            this.handle = handle;
            handle.setTitle("Select a classpath entry type");
            handle.setDescription("Please select one of the classpath entry types below.");
            handle.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.common.modulecore.ui", (String)"icons/assembly-banner.png"));
            Composite c = new Composite(parent, 0);
            c.setLayout((Layout)new GridLayout());
            this.viewer = new TreeViewer(c, 2052);
            this.viewer.getTree().setLayoutData((Object)new GridData(1808));
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return element == null ? "" : ((RuntimePathProviderType)element).getName();
                }
            });
            this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
            this.viewer.setComparator(new ViewerComparator());
            this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    this.viewerSelectionChanged();
                }
            });
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    this.advanceToNextPageOrFinish();
                }
            });
            return c;
        }

        protected void viewerSelectionChanged() {
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            Object o = sel == null ? null : sel.getFirstElement();
            this.getTaskModel().putObject(RuntimeClasspathProviderWizard.PROVIDER_TYPE, o);
            this.setComplete(o != null);
            this.handle.update();
        }

        protected ITreeContentProvider getContentProvider() {
            if (this.contentProvider == null) {
                this.contentProvider = new ITreeContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        return RuntimeClasspathProviderWizard.getTypesForRuntime(this.getTaskModel());
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }

                    public void dispose() {
                    }

                    public boolean hasChildren(Object element) {
                        return false;
                    }

                    public Object getParent(Object element) {
                        return null;
                    }

                    public Object[] getChildren(Object parentElement) {
                        return null;
                    }
                };
            }
            return this.contentProvider;
        }

        protected void createChildFragments(List<WizardFragment> list) {
            if (this.getTaskModel() != null) {
                RuntimePathProviderType t = (RuntimePathProviderType)this.getTaskModel().getObject(RuntimeClasspathProviderWizard.PROVIDER_TYPE);
                if (t instanceof LayeredRuntimePathProviderTypeImpl) {
                    if (this.layeredFragment == null) {
                        this.layeredFragment = new LayeredPathProviderFragment();
                    }
                    list.add(this.layeredFragment);
                } else if (t instanceof FilesetRuntimePathProviderTypeImpl) {
                    if (this.filesetFragment == null) {
                        this.filesetFragment = new FilesetClasspathProviderFragment();
                    }
                    list.add(this.filesetFragment);
                }
            }
        }
    }
}

