/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.build;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.EventManager;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.core.util.ModelUtil;
import org.jboss.ide.eclipse.archives.core.util.internal.ModelTruezipBridge;

public class ModelChangeListener
implements IArchiveModelListener {
    public void modelChanged(final IArchiveNodeDelta delta) {
        if (this.shouldRun(delta)) {
            WorkspaceJob j = new WorkspaceJob("Responding to archives model change"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    ModelChangeListener.this.executeAndLog(delta);
                    return Status.OK_STATUS;
                }
            };
            j.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            j.schedule();
        }
    }

    protected boolean shouldRun(IArchiveNodeDelta delta) {
        if (delta == null || delta.getPostNode() == null) {
            return false;
        }
        IPath projectPath = delta.getPostNode().getProjectPath();
        return ArchivesCore.getInstance().getPreferenceManager().shouldBuild(projectPath);
    }

    protected void executeAndLog(IArchiveNodeDelta delta) {
        IStatus[] errors = null;
        try {
            errors = this.handle(delta);
        }
        catch (ModelTruezipBridge.FullBuildRequiredException fbre) {
            throw fbre;
        }
        catch (Exception e) {
            Status er = new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCoreMessages.ErrorUpdatingModel, (Throwable)e);
            errors = new IStatus[]{er};
        }
        IArchiveNode node = delta.getPreNode() == null ? delta.getPostNode() : delta.getPreNode();
        EventManager.error(node, errors);
    }

    protected IStatus[] handle(IArchiveNodeDelta delta) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        if (this.isTopLevelArchive(delta.getPostNode())) {
            EventManager.startedBuildingArchive((IArchive)delta.getPostNode());
        }
        if ((delta.getKind() & 0x1800) != 0) {
            errors.addAll(Arrays.asList(this.nodeRemoved(delta.getPreNode())));
            errors.addAll(Arrays.asList(this.nodeAdded(delta.getPostNode())));
        }
        if ((delta.getKind() & 2) != 0) {
            errors.addAll(Arrays.asList(this.nodeRemoved(delta.getPreNode())));
        } else if ((delta.getKind() & 1) != 0) {
            errors.addAll(Arrays.asList(this.nodeAdded(delta.getPostNode())));
        } else if ((delta.getKind() & 0x80) != 0) {
            boolean shouldHandleChildren = this.handleAttributeChange(delta);
            if (shouldHandleChildren) {
                IArchiveNodeDelta[] children = delta.getAllAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    errors.addAll(Arrays.asList(this.handle(children[i])));
                    ++i;
                }
            }
        } else if (this.descendentChanged(delta.getKind())) {
            IArchiveNodeDelta[] children = delta.getAllAffectedChildren();
            int i = 0;
            while (i < children.length) {
                errors.addAll(Arrays.asList(this.handle(children[i])));
                ++i;
            }
        }
        if (this.isTopLevelArchive(delta.getPostNode())) {
            EventManager.finishedBuildingArchive((IArchive)delta.getPostNode());
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    protected boolean descendentChanged(int kind) {
        return (kind & 0x400) != 0 || (kind & 0x100) != 0 || (kind & 0x200) != 0;
    }

    protected boolean isTopLevelArchive(IArchiveNode node) {
        return node != null && node instanceof IArchive && ((IArchive)node).isTopLevel();
    }

    private boolean handleAttributeChange(IArchiveNodeDelta delta) {
        switch (delta.getPostNode().getNodeType()) {
            case 3: {
                return this.handleFolderAttributeChanged(delta);
            }
            case 2: {
                return this.handleFilesetAttributeChanged(delta);
            }
            case 0: {
                return this.handlePackageAttributeChanged(delta);
            }
        }
        return false;
    }

    private boolean handleFolderAttributeChanged(IArchiveNodeDelta delta) {
        this.nodeRemoved(delta.getPreNode());
        this.nodeAdded(delta.getPostNode());
        return false;
    }

    private boolean handleFilesetAttributeChanged(IArchiveNodeDelta delta) {
        this.nodeRemoved(delta.getPreNode());
        this.nodeAdded(delta.getPostNode());
        return false;
    }

    private boolean handlePackageAttributeChanged(IArchiveNodeDelta delta) {
        this.nodeRemoved(delta.getPreNode());
        this.nodeAdded(delta.getPostNode());
        return false;
    }

    private IStatus[] nodeAdded(IArchiveNode added) {
        int i;
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        if (added == null) {
            return new IStatus[0];
        }
        if (added.getNodeType() == -1) {
            IArchiveNode[] archives = ((IArchiveModelRootNode)added).getChildren(0);
            i = 0;
            while (i < archives.length) {
                errors.addAll(Arrays.asList(this.nodeAdded(archives[i])));
                ++i;
            }
        } else if (added.getNodeType() == 0) {
            if (((IArchive)added).isTopLevel() && !added.canBuild()) {
                return new IStatus[]{this.logCannotBuildError((IArchive)added)};
            }
            ModelTruezipBridge.createFile(added);
        } else if (added.getNodeType() == 3) {
            ModelTruezipBridge.createFile(added);
        }
        IArchiveFileSet[] filesets = ModelUtil.findAllDescendentFilesets(added);
        i = 0;
        while (i < filesets.length) {
            ModelTruezipBridge.FileWrapperStatusPair result = ModelTruezipBridge.fullFilesetBuild(filesets[i], (IProgressMonitor)new NullProgressMonitor(), true);
            errors.addAll(Arrays.asList(result.s));
            DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] files = filesets[i].findMatchingPaths();
            EventManager.filesUpdated(filesets[i].getRootArchive(), filesets[i], files);
            ++i;
        }
        this.postChange(added);
        return errors.toArray(new IStatus[errors.size()]);
    }

    private IStatus[] nodeRemoved(IArchiveNode removed) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        if (removed == null) {
            return new IStatus[0];
        }
        if (removed.getNodeType() == -1) {
            IArchiveNode[] kids = removed.getChildren(0);
            int i = 0;
            while (i < kids.length) {
                errors.addAll(Arrays.asList(this.nodeRemoved(kids[i])));
                ++i;
            }
            this.postChange(removed);
            return errors.toArray(new IStatus[errors.size()]);
        }
        if (removed.getNodeType() == 0) {
            if (((IArchive)removed).isTopLevel() && !removed.canBuild()) {
                return new IStatus[]{this.logCannotBuildError((IArchive)removed)};
            }
            ModelTruezipBridge.deleteArchive((IArchive)removed);
            this.postChange(removed);
            return new IStatus[0];
        }
        if (removed.getNodeType() == 3) {
            IArchiveFileSet[] filesets = ModelUtil.findAllDescendentFilesets((IArchiveFolder)removed);
            int i = 0;
            while (i < filesets.length) {
                ModelTruezipBridge.FileWrapperStatusPair result = ModelTruezipBridge.fullFilesetRemove(filesets[i], (IProgressMonitor)new NullProgressMonitor(), false);
                errors.addAll(Arrays.asList(result.s));
                EventManager.filesRemoved(this.convertToPath(result.f), filesets[i]);
                ++i;
            }
            this.postChange(removed);
            return errors.toArray(new IStatus[errors.size()]);
        }
        IArchiveFileSet[] filesets = ModelUtil.findAllDescendentFilesets(removed);
        int i = 0;
        while (i < filesets.length) {
            ModelTruezipBridge.FileWrapperStatusPair result = ModelTruezipBridge.fullFilesetRemove((IArchiveFileSet)removed, (IProgressMonitor)new NullProgressMonitor(), false);
            EventManager.filesRemoved(this.convertToPath(result.f), (IArchiveFileSet)removed);
            errors.addAll(Arrays.asList(result.s));
            ++i;
        }
        this.postChange(removed);
        return errors.toArray(new IStatus[errors.size()]);
    }

    protected IPath[] convertToPath(DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] wrappers) {
        IPath[] paths = new IPath[wrappers.length];
        int i = 0;
        while (i < wrappers.length) {
            paths[i] = wrappers[i].getWrapperPath();
            ++i;
        }
        return paths;
    }

    protected void postChange(IArchiveNode node) {
    }

    protected IStatus logCannotBuildError(IArchive archive) {
        Status s = new Status(2, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind(ArchivesCoreMessages.CannotBuildBadConfiguration, archive.getName()), null);
        return s;
    }
}

