/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveBuildListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;

public class EventManager {
    private static final IArchiveModelListener[] NO_LISTENERS = new IArchiveModelListener[0];

    public static void cleanProjectBuild(IPath project) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].cleanProject(project);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void cleanArchiveBuild(IArchive archive) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners(archive);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].cleanArchive(archive);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void startedBuild(IPath project) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].startedBuild(project);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void finishedBuild(IPath project) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].finishedBuild(project);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void startedBuildingArchive(IArchive archive) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners(archive);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].startedBuildingArchive(archive);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void finishedBuildingArchive(IArchive archive) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners(archive);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].finishedBuildingArchive(archive);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void startedCollectingFileSet(IArchiveFileSet fileset) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners(fileset);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].startedCollectingFileSet(fileset);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void finishedCollectingFileSet(IArchiveFileSet fileset) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners(fileset);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].finishedCollectingFileSet(fileset);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void filesUpdated(IArchive topLevelArchive, IArchiveFileSet fileset, DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] filePath) {
        int i = 0;
        while (i < filePath.length) {
            EventManager.fileUpdated(topLevelArchive, fileset, (IPath)new Path(filePath[i].getAbsolutePath()));
            ++i;
        }
    }

    public static void fileUpdated(IPath path, IArchiveFileSet[] matchingFilesets) {
        int i = 0;
        while (i < matchingFilesets.length) {
            EventManager.fileUpdated(matchingFilesets[i].getRootArchive(), matchingFilesets[i], path);
            ++i;
        }
    }

    public static void fileUpdated(IArchive topLevelArchive, IArchiveFileSet fileset, IPath filePath) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners(topLevelArchive);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].fileUpdated(topLevelArchive, fileset, filePath);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void fileRemoved(IArchive topLevelArchive, IArchiveFileSet fileset, IPath filePath) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners(topLevelArchive);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].fileRemoved(topLevelArchive, fileset, filePath);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void fileRemoved(IPath path, IArchiveFileSet[] matchingFilesets) {
        int i = 0;
        while (i < matchingFilesets.length) {
            EventManager.fileRemoved(matchingFilesets[i].getRootArchive(), matchingFilesets[i], path);
            ++i;
        }
    }

    public static void filesRemoved(IPath[] paths, IArchiveFileSet fileset) {
        int i = 0;
        while (i < paths.length) {
            EventManager.fileRemoved(fileset.getRootArchive(), fileset, paths[i]);
            ++i;
        }
    }

    public static void buildFailed(IArchive pkg, IStatus status) {
        IArchiveBuildListener[] listeners = EventManager.getBuildListeners(pkg);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].buildFailed(pkg, status);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    public static void error(IArchiveNode node, IStatus[] errors) {
        if (errors != null && errors.length > 0) {
            IArchiveBuildListener[] listeners = EventManager.getBuildListeners(node);
            int i = 0;
            while (i < listeners.length) {
                try {
                    listeners[i].error(node, errors);
                }
                catch (Exception e) {
                    EventManager.logError(e);
                }
                ++i;
            }
        }
    }

    public static void fireDelta(IArchiveNodeDelta delta) {
        IArchiveNode node = delta.getPostNode() == null ? delta.getPreNode() : delta.getPostNode();
        IArchiveModelListener[] listeners = EventManager.getModelListeners(node);
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].modelChanged(delta);
            }
            catch (Exception e) {
                EventManager.logError(e);
            }
            ++i;
        }
    }

    private static IArchiveModelListener[] getModelListeners(IArchiveNode node) {
        IArchiveModelRootNode model;
        IArchiveModelListener[] listeners = NO_LISTENERS;
        if (node != null && (model = node.getModelRootNode()) != null && model.getModel() != null) {
            listeners = model.getModel().getModelListeners();
        }
        return listeners;
    }

    private static IArchiveBuildListener[] getBuildListeners() {
        return ArchivesModel.instance().getBuildListeners();
    }

    private static IArchiveBuildListener[] getBuildListeners(IArchiveNode node) {
        if (node == null) {
            return EventManager.getBuildListeners();
        }
        IArchiveModelRootNode model = node.getModelRootNode();
        if (model != null && model.getModel() != null) {
            return model.getModel().getBuildListeners();
        }
        return new IArchiveBuildListener[0];
    }

    protected static void logError(Exception e) {
        ArchivesCore.log(2, ArchivesCoreMessages.ArchivesListenerError, e);
    }
}

