/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeVisitor;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveNodeDeltaImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackageNode;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackageNodeWithProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveNodeImpl
implements IArchiveNode {
    protected XbPackageNodeWithProperties nodeDelegate;
    protected IArchiveNode parent;
    protected ArrayList<ArchiveNodeImpl> children;
    private HashMap<String, ArchiveNodeDeltaImpl.NodeDelta> attributeChanges;
    private HashMap<String, ArchiveNodeDeltaImpl.NodeDelta> propertyChanges;
    private HashMap<IArchiveNode, Integer> childChanges;

    public synchronized HashMap<String, ArchiveNodeDeltaImpl.NodeDelta> getAttributeChanges() {
        return (HashMap)this.attributeChanges.clone();
    }

    public synchronized HashMap<String, ArchiveNodeDeltaImpl.NodeDelta> getPropertyChanges() {
        return (HashMap)this.propertyChanges.clone();
    }

    public synchronized HashMap<IArchiveNode, Integer> getChildChanges() {
        return (HashMap)this.childChanges.clone();
    }

    public ArchiveNodeImpl(XbPackageNodeWithProperties delegate) {
        this.nodeDelegate = delegate;
        this.children = new ArrayList();
        this.attributeChanges = new HashMap();
        this.propertyChanges = new HashMap();
        this.childChanges = new HashMap();
    }

    public XbPackageNode getNodeDelegate() {
        return this.nodeDelegate;
    }

    @Override
    public IArchiveNode getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    @Override
    public IArchiveModelRootNode getModelRootNode() {
        IArchiveNode root = this.getRoot();
        return root instanceof IArchiveModelRootNode ? (IArchiveModelRootNode)root : null;
    }

    @Override
    public double getDescriptorVersion() {
        IArchiveModelRootNode root = this.getModelRootNode();
        return root != null ? root.getDescriptorVersion() : 1.2;
    }

    @Override
    public IArchive getRootArchive() {
        IArchiveNode parent = this.parent;
        IArchive topArchives = null;
        if (this.getNodeType() == 0) {
            topArchives = (IArchive)((Object)this);
        }
        while (parent != null) {
            if (parent.getNodeType() == 0) {
                topArchives = (IArchive)parent;
            }
            parent = parent.getParent();
        }
        return topArchives;
    }

    @Override
    public IArchiveNode[] getAllChildren() {
        return this.children.toArray(new IArchiveNode[this.children.size()]);
    }

    @Override
    public IArchiveNode[] getChildren(int type) {
        ArrayList<IArchiveNode> typedChildren = new ArrayList<IArchiveNode>();
        for (IArchiveNode iArchiveNode : this.children) {
            if (iArchiveNode.getNodeType() != type) continue;
            typedChildren.add(iArchiveNode);
        }
        return typedChildren.toArray(new IArchiveNode[typedChildren.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.nodeDelegate.hasChildren();
    }

    @Override
    public boolean hasChild(IArchiveNode child) {
        ArchiveNodeImpl childImpl = (ArchiveNodeImpl)child;
        return this.nodeDelegate.getAllChildren().contains(childImpl.nodeDelegate);
    }

    @Override
    public IArchiveNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IArchiveNode parent) {
        if (this.getParent() != null && parent != this.getParent()) {
            this.getParent().removeChild(this);
        }
        this.parent = parent;
        this.nodeDelegate.setParent(parent == null ? null : ((ArchiveNodeImpl)parent).getNodeDelegate());
    }

    @Override
    public IPath getProjectPath() {
        IArchiveModelRootNode root = this.getModelRootNode();
        return root == null ? null : root.getProjectPath();
    }

    @Override
    public String getProjectName() {
        IPath path = this.getProjectPath();
        return ArchivesCore.getInstance().getVFS().getProjectName(path);
    }

    @Override
    public String getProperty(String property) {
        return this.getProperties().getProperty(property);
    }

    @Override
    public void setProperty(String property, String value) {
        if (property == null) {
            return;
        }
        this.propertyChanged(property, this.getProperty(property), value);
        if (value == null) {
            this.getProperties().remove(property);
        } else {
            this.getProperties().setProperty(property, value);
        }
    }

    protected Properties getProperties() {
        return this.nodeDelegate.getProperties().getProperties();
    }

    @Override
    public boolean accept(IArchiveNodeVisitor visitor) {
        return this.accept(visitor, false);
    }

    @Override
    public boolean accept(IArchiveNodeVisitor visitor, boolean depthFirst) {
        IArchiveNode[] children = this.getAllChildren();
        boolean keepGoing = true;
        if (!depthFirst) {
            keepGoing = visitor.visit(this);
        }
        if (keepGoing) {
            int i = 0;
            while (i < children.length) {
                if (keepGoing) {
                    keepGoing = children[i].accept(visitor, depthFirst);
                }
                ++i;
            }
        }
        if (depthFirst && keepGoing) {
            keepGoing = visitor.visit(this);
        }
        return keepGoing;
    }

    @Override
    public final void addChild(IArchiveNode node) throws ArchivesModelException {
        this.addChild(node, true);
    }

    public final synchronized void addChild(IArchiveNode child, boolean addInDelegate) throws ArchivesModelException {
        Assert.isNotNull((Object)child);
        ArchiveNodeImpl childImpl = (ArchiveNodeImpl)child;
        this.children.add(childImpl);
        childImpl.setParent(this);
        if (addInDelegate) {
            this.nodeDelegate.addChild(childImpl.nodeDelegate);
        }
        this.childChanges(child, 256);
        if (!this.validateModel()) {
            this.removeChild(child);
            throw new ArchivesModelException(ArchivesCore.bind(ArchivesCoreMessages.ErrorAddChildNode, child.toString()));
        }
    }

    @Override
    public boolean validateModel() {
        IArchiveNode[] kids = this.getAllChildren();
        int i = 0;
        while (i < kids.length) {
            if (!kids[i].validateModel()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean canBuild() {
        IArchiveNode[] kids = this.getAllChildren();
        int i = 0;
        while (i < kids.length) {
            if (!kids[i].canBuild()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public synchronized void removeChild(IArchiveNode node) {
        Assert.isNotNull((Object)node);
        ArchiveNodeImpl impl = (ArchiveNodeImpl)node;
        boolean removed = false;
        if (this.nodeDelegate.getAllChildren().contains(impl.nodeDelegate)) {
            this.nodeDelegate.removeChild(impl.nodeDelegate);
            removed = true;
        }
        if (this.children.contains(node)) {
            this.children.remove(node);
            removed = true;
        }
        if (removed) {
            this.childChanges(node, 512);
        }
    }

    protected synchronized void attributeChanged(String key, Object beforeValue, Object afterValue) {
        int kind = 128;
        if (beforeValue != null && beforeValue.equals(afterValue)) {
            return;
        }
        if (this.attributeChanges.containsKey(key)) {
            Object original = this.attributeChanges.get(key).getBefore();
            if (original == null && afterValue == null) {
                this.attributeChanges.remove(key);
            } else if (original == null) {
                this.attributeChanges.put(key, new ArchiveNodeDeltaImpl.NodeDelta(original, afterValue, kind));
            } else if (original.equals(afterValue)) {
                this.attributeChanges.remove(key);
            } else {
                this.attributeChanges.put(key, new ArchiveNodeDeltaImpl.NodeDelta(original, afterValue, kind));
            }
        } else {
            this.attributeChanges.put(key, new ArchiveNodeDeltaImpl.NodeDelta(beforeValue, afterValue, kind));
        }
    }

    protected synchronized void propertyChanged(String key, Object beforeValue, Object afterValue) {
        if (beforeValue != null && beforeValue.equals(afterValue)) {
            return;
        }
        if (this.propertyChanges.containsKey(key)) {
            Object original = this.propertyChanges.get(key).getBefore();
            if (original == null && afterValue == null) {
                this.propertyChanges.remove(key);
            } else if (original == null) {
                this.propertyChanges.put(key, new ArchiveNodeDeltaImpl.NodeDelta(original, afterValue, 16));
            } else if (original.equals(afterValue)) {
                this.propertyChanges.remove(key);
            } else if (afterValue == null) {
                this.propertyChanges.put(key, new ArchiveNodeDeltaImpl.NodeDelta(original, afterValue, 32));
            } else {
                this.propertyChanges.put(key, new ArchiveNodeDeltaImpl.NodeDelta(original, afterValue, 64));
            }
        } else {
            int kind = beforeValue == null ? 16 : (afterValue == null ? 32 : 64);
            this.propertyChanges.put(key, new ArchiveNodeDeltaImpl.NodeDelta(beforeValue, afterValue, kind));
        }
    }

    protected synchronized void childChanges(IArchiveNode node, int changeType) {
        if (this.childChanges.containsKey(node)) {
            int lastChange = this.childChanges.get(node);
            if (lastChange == 256 && changeType == 512) {
                this.childChanges.remove(node);
            } else if (lastChange == 512 && changeType == 256) {
                this.childChanges.remove(node);
            }
        } else {
            this.childChanges.put(node, new Integer(changeType));
        }
    }

    @Override
    public IArchiveNodeDelta getDelta() {
        return new ArchiveNodeDeltaImpl(null, this, this.getAttributeChanges(), this.getPropertyChanges(), this.getChildChanges());
    }

    @Override
    public synchronized void clearDelta() {
        this.attributeChanges.clear();
        this.propertyChanges.clear();
        this.childChanges.clear();
        IArchiveNode[] children = this.getAllChildren();
        int i = 0;
        while (i < children.length) {
            ((ArchiveNodeImpl)children[i]).clearDelta();
            ++i;
        }
    }
}

