/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal.xb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.IMemento;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XMLMemento;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbFileSet;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbFolder;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbLibFileSet;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackage;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackageNodeWithProperties;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackages;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbProperties;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbProperty;

public class XMLBinding {
    public static String serializePackages(XbPackages packages, IProgressMonitor monitor) throws XbException {
        try {
            StringWriter sw = new StringWriter();
            XMLBinding.marshall(packages, sw, monitor);
            return new String(sw.toString());
        }
        catch (Exception e) {
            throw new XbException(e);
        }
    }

    public static void marshallToFile(XbPackages element, IPath filePath, IProgressMonitor monitor) throws XbException {
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new OutputStreamWriter(new FileOutputStream(filePath.toFile()));
                XMLBinding.marshall(element, writer, monitor);
            }
            catch (XbException xbe) {
                throw xbe;
            }
            catch (IOException ioe) {
                throw new XbException(ioe);
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String marshall(IArchive topLevelArchive, IProgressMonitor monitor) throws XbException {
        if (topLevelArchive.isTopLevel() && topLevelArchive instanceof ArchiveImpl) {
            XbPackages packs = (XbPackages)((ArchiveImpl)topLevelArchive).getNodeDelegate().getParent();
            StringWriter sw = new StringWriter();
            XMLBinding.marshall(packs, sw, monitor);
            return sw.toString();
        }
        return null;
    }

    public static void marshall(XbPackages element, Writer writer, IProgressMonitor monitor) throws XbException {
        XMLMemento root = XMLMemento.createWriteRoot("packages");
        root.putString("version", new Double(element.getVersion()).toString());
        List packagesToAdd = element.getChildren(XbPackage.class);
        XMLBinding.marshallAddPackages(root, XMLBinding.nullSafe(packagesToAdd));
        XMLBinding.marshallAddProperties(root, element.getProperties());
        try {
            String s = root.saveToString();
            writer.write(s);
        }
        catch (IOException ioe) {
            throw new XbException(ioe);
        }
    }

    private static List nullSafe(List list) {
        return list == null ? new ArrayList() : list;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static void marshallAddPackages(XMLMemento memento, List packages) throws XbException {
        Iterator i = packages.iterator();
        while (i.hasNext()) {
            XMLMemento childMemento = (XMLMemento)memento.createChild("package");
            XbPackage childXb = (XbPackage)i.next();
            if (childXb.getName() == null) {
                throw new XbException(new Exception("Element 'package' missing attribute 'name'"));
            }
            childMemento.putString("name", childXb.getName());
            if (!XMLBinding.isEmpty(childXb.getPackageType())) {
                childMemento.putString("type", childXb.getPackageType());
            }
            if (!XMLBinding.isEmpty(childXb.getToDir())) {
                childMemento.putString("todir", childXb.getToDir());
            }
            if (!XMLBinding.isEmpty(childXb.getId())) {
                childMemento.putString("id", childXb.getId());
            }
            childMemento.putString("exploded", new Boolean(childXb.isExploded()).toString());
            childMemento.putString("inWorkspace", new Boolean(childXb.isInWorkspace()).toString());
            XMLBinding.marshallAddPackages(childMemento, XMLBinding.nullSafe(childXb.getChildren(XbPackage.class)));
            XMLBinding.addFileset(childMemento, XMLBinding.nullSafe(childXb.getChildren(XbFileSet.class)));
            XMLBinding.addLibFileset(childMemento, XMLBinding.nullSafe(childXb.getChildren(XbLibFileSet.class)));
            XMLBinding.addFolders(childMemento, XMLBinding.nullSafe(childXb.getChildren(XbFolder.class)));
            XMLBinding.marshallAddProperties(childMemento, childXb.getProperties());
        }
    }

    private static void addFolders(XMLMemento memento, List folders) throws XbException {
        Iterator i = folders.iterator();
        while (i.hasNext()) {
            XMLMemento childMemento = (XMLMemento)memento.createChild("folder");
            XbFolder childXb = (XbFolder)i.next();
            if (childXb.getName() == null) {
                throw new XbException(new Exception("Element 'folder' missing attribute 'name'"));
            }
            childMemento.putString("name", childXb.getName());
            XMLBinding.marshallAddPackages(childMemento, XMLBinding.nullSafe(childXb.getChildren(XbPackage.class)));
            XMLBinding.addFileset(childMemento, XMLBinding.nullSafe(childXb.getChildren(XbFileSet.class)));
            XMLBinding.addLibFileset(childMemento, XMLBinding.nullSafe(childXb.getChildren(XbLibFileSet.class)));
            XMLBinding.addFolders(childMemento, XMLBinding.nullSafe(childXb.getChildren(XbFolder.class)));
            XMLBinding.marshallAddProperties(childMemento, childXb.getProperties());
        }
    }

    private static void addFileset(XMLMemento memento, List xbList) throws XbException {
        Iterator i = xbList.iterator();
        while (i.hasNext()) {
            XMLMemento fsMemento = (XMLMemento)memento.createChild("fileset");
            XbFileSet fsXb = (XbFileSet)i.next();
            if (fsXb.getDir() == null) {
                throw new XbException(new Exception("Element 'fileset' missing attribute 'dir'"));
            }
            if (fsXb.getIncludes() == null) {
                throw new XbException(new Exception("Element 'fileset' missing attribute 'includes'"));
            }
            fsMemento.putString("dir", fsXb.getDir());
            fsMemento.putString("includes", fsXb.getIncludes());
            if (!XMLBinding.isEmpty(fsXb.getExcludes())) {
                fsMemento.putString("excludes", fsXb.getExcludes());
            }
            fsMemento.putString("inWorkspace", new Boolean(fsXb.isInWorkspace()).toString());
            fsMemento.putString("flatten", new Boolean(fsXb.isFlatten()).toString());
            XMLBinding.marshallAddProperties(fsMemento, fsXb.getProperties());
        }
    }

    private static void addLibFileset(XMLMemento memento, List xbList) {
        Iterator i = xbList.iterator();
        while (i.hasNext()) {
            XMLMemento fsMemento = (XMLMemento)memento.createChild("lib-fileset");
            XbLibFileSet fsXb = (XbLibFileSet)i.next();
            if (!XMLBinding.isEmpty(fsXb.getId())) {
                fsMemento.putString("name", fsXb.getId());
            }
            XMLBinding.marshallAddProperties(fsMemento, fsXb.getProperties());
        }
    }

    private static void marshallAddProperties(XMLMemento memento, XbProperties properties) {
        XMLMemento props = (XMLMemento)memento.createChild("properties");
        if (properties != null) {
            XbProperties.PropertiesExt ext = properties.getProperties();
            Set<Object> set = ext.keySet();
            for (String string : set) {
                String value = ext.getProperty(string);
                XMLMemento propMemento = (XMLMemento)props.createChild("property");
                propMemento.putString("name", string);
                propMemento.putString("value", value);
            }
        }
    }

    public static XbPackages unmarshal(File file, IProgressMonitor monitor) throws XbException {
        try {
            FileInputStream fis = new FileInputStream(file);
            return XMLBinding.unmarshal(fis, monitor);
        }
        catch (FileNotFoundException fnfe) {
            throw new XbException(fnfe);
        }
        catch (XbException xbe) {
            throw new XbException("Unable to parse project archives file: " + (file == null ? null : file.getAbsolutePath()), xbe);
        }
    }

    public static XbPackages unmarshal(InputStream in, IProgressMonitor monitor) throws XbException {
        XMLMemento root = XMLMemento.createReadRoot(in);
        if (root == null) {
            throw new XbException(new Exception("Unable to parse xml string"));
        }
        String versionString = root.getString("version");
        System.out.println("unmarshalling: " + versionString);
        XbPackages packs = new XbPackages();
        Double d = 1.0;
        if (versionString != null) {
            try {
                d = Double.parseDouble(versionString);
            }
            catch (NumberFormatException nfe) {
                throw new XbException(nfe);
            }
        }
        packs.setVersion(d);
        IMemento[] packageChildren = root.getChildren("package");
        XMLBinding.unmarshallPackageList(packs, packageChildren);
        IMemento[] propertiesChild = root.getChildren("properties");
        if (propertiesChild != null && propertiesChild.length == 1) {
            XMLBinding.unmarshallProperties(packs, propertiesChild[0]);
        }
        return packs;
    }

    private static void unmarshallPackageList(XbPackageNodeWithProperties packs, IMemento[] packageChildren) throws XbException {
        int i = 0;
        while (i < packageChildren.length) {
            IMemento[] propertiesChild;
            IMemento[] folders;
            IMemento[] libfsets;
            IMemento[] fsets;
            XbPackage pack = new XbPackage();
            String name = packageChildren[i].getString("name");
            String type = packageChildren[i].getString("type");
            String toDir = packageChildren[i].getString("todir");
            String id = packageChildren[i].getString("id");
            String exploded = packageChildren[i].getString("exploded");
            String inWorkspace = packageChildren[i].getString("inWorkspace");
            String exploded2 = exploded == null ? "" : exploded;
            String inWorkspace2 = inWorkspace == null ? "" : inWorkspace;
            boolean explodedValid = "true".equals(exploded2.toLowerCase()) || "false".equals(exploded2.toLowerCase());
            boolean inWorkspaceValid = "true".equals(inWorkspace2.toLowerCase()) || "false".equals(inWorkspace2.toLowerCase());
            boolean bExploded = explodedValid ? Boolean.parseBoolean(exploded) : false;
            boolean bInWorkspace = inWorkspaceValid ? Boolean.parseBoolean(inWorkspace) : true;
            pack.setName(name);
            pack.setPackageType(type);
            pack.setToDir(toDir);
            pack.setId(id);
            pack.setExploded(bExploded);
            pack.setInWorkspace(bInWorkspace);
            if (name == null) {
                throw new XbException(new Exception("Element 'package' missing required attribute 'name'"));
            }
            IMemento[] inner = packageChildren[i].getChildren("package");
            if (inner != null && inner.length > 0) {
                XMLBinding.unmarshallPackageList(pack, inner);
            }
            if ((fsets = packageChildren[i].getChildren("fileset")) != null && fsets.length > 0) {
                XMLBinding.unmarshallFilesets(pack, fsets);
            }
            if ((libfsets = packageChildren[i].getChildren("lib-fileset")) != null && libfsets.length > 0) {
                XMLBinding.unmarshallLibFilesets(pack, libfsets);
            }
            if ((folders = packageChildren[i].getChildren("folder")) != null && folders.length > 0) {
                XMLBinding.unmarshallFolders(pack, folders);
            }
            if ((propertiesChild = packageChildren[i].getChildren("properties")) != null && propertiesChild.length == 1) {
                XMLBinding.unmarshallProperties(pack, propertiesChild[0]);
            }
            packs.addChild(pack);
            ++i;
        }
    }

    private static void unmarshallFolders(XbPackageNodeWithProperties node, IMemento[] folders) throws XbException {
        int i = 0;
        while (i < folders.length) {
            IMemento[] propertiesChild;
            IMemento[] folders2;
            IMemento[] libfsets;
            IMemento[] fsets;
            XbFolder folder = new XbFolder();
            String name = folders[i].getString("name");
            folder.setName(name);
            if (name == null) {
                throw new XbException(new Exception("Element 'folder' missing required attribute 'name'"));
            }
            IMemento[] inner = folders[i].getChildren("package");
            if (inner != null && inner.length > 0) {
                XMLBinding.unmarshallPackageList(folder, inner);
            }
            if ((fsets = folders[i].getChildren("fileset")) != null && fsets.length > 0) {
                XMLBinding.unmarshallFilesets(folder, fsets);
            }
            if ((libfsets = folders[i].getChildren("lib-fileset")) != null && libfsets.length > 0) {
                XMLBinding.unmarshallLibFilesets(folder, libfsets);
            }
            if ((folders2 = folders[i].getChildren("folder")) != null && folders2.length > 0) {
                XMLBinding.unmarshallFolders(folder, folders2);
            }
            if ((propertiesChild = folders[i].getChildren("properties")) != null && propertiesChild.length == 1) {
                XMLBinding.unmarshallProperties(folder, propertiesChild[0]);
            }
            node.addChild(folder);
            ++i;
        }
    }

    private static void unmarshallFilesets(XbPackageNodeWithProperties node, IMemento[] fs) throws XbException {
        int i = 0;
        while (i < fs.length) {
            XbFileSet fileset = new XbFileSet();
            String dir = fs[i].getString("dir");
            String inc = fs[i].getString("includes");
            String exc = fs[i].getString("excludes");
            String inWorkspace = fs[i].getString("inWorkspace");
            String inWorkspace2 = inWorkspace == null ? "" : inWorkspace;
            String flatten = fs[i].getString("exploded");
            String flatten2 = flatten == null ? "" : flatten;
            boolean explodedValid = "true".equals(flatten2.toLowerCase()) || "false".equals(flatten2.toLowerCase());
            boolean inWorkspaceValid = "true".equals(inWorkspace2.toLowerCase()) || "false".equals(inWorkspace2.toLowerCase());
            boolean bFlat = explodedValid ? Boolean.parseBoolean(flatten) : false;
            boolean bInWorkspace = inWorkspaceValid ? Boolean.parseBoolean(inWorkspace) : true;
            fileset.setDir(dir);
            fileset.setIncludes(inc);
            if (exc != null && !"".equals(exc)) {
                fileset.setExcludes(exc);
            }
            fileset.setInWorkspace(bInWorkspace);
            fileset.setFlatten(bFlat);
            if (dir == null) {
                throw new XbException(new Exception("Element 'fileset' missing required attribute 'dir'"));
            }
            if (inc == null) {
                throw new XbException(new Exception("Element 'fileset' missing required attribute 'includes'"));
            }
            node.addChild(fileset);
            ++i;
        }
    }

    private static void unmarshallLibFilesets(XbPackageNodeWithProperties node, IMemento[] fs) {
        int i = 0;
        while (i < fs.length) {
            XbLibFileSet fileset = new XbLibFileSet();
            String id = fs[i].getString("name");
            fileset.setId(id);
            node.addChild(fileset);
            ++i;
        }
    }

    private static void unmarshallProperties(XbPackageNodeWithProperties node, IMemento propNode) throws XbException {
        XbProperties propsWrapper = new XbProperties();
        node.setProperties(propsWrapper);
        String[] names = ((XMLMemento)propNode).getChildNames();
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(Arrays.asList(names));
        if (set.size() == 0) {
            return;
        }
        if (set.size() > 1 || !((String)set.iterator().next()).equals("property")) {
            throw new XbException(new Exception("Element 'property' contains unknown attribute " + (String)set.iterator().next()));
        }
        IMemento[] allProps = propNode.getChildren("property");
        int i = 0;
        while (i < allProps.length) {
            XbProperty p = new XbProperty();
            String name = allProps[i].getString("name");
            String val = allProps[i].getString("value");
            if (name == null) {
                throw new XbException(new Exception("Element 'property' missing required attribute 'name'"));
            }
            if (val == null) {
                throw new XbException(new Exception("Element 'property' missing required attribute 'value'"));
            }
            if (allProps[i].getNames().size() > 2) {
                throw new XbException(new Exception("Element 'property' contains unknown attribute key"));
            }
            p.setName(name);
            p.setValue(val);
            propsWrapper.addProperty(p);
            ++i;
        }
    }

    public static class XbException
    extends Exception {
        private Exception parent;
        private String msg;

        public XbException(String msg, Exception e) {
            this.parent = e;
            this.msg = msg;
        }

        public XbException(Exception e) {
            this.parent = e;
        }

        public Exception getException() {
            return this.parent;
        }

        public String getMessage() {
            String prefix = this.msg == null ? "" : String.valueOf(this.msg) + ": ";
            String suffix = this.parent.getCause() == null ? this.parent.getMessage() : this.parent.getCause().getMessage();
            return String.valueOf(prefix) + suffix;
        }

        public Throwable getCause() {
            return this.parent;
        }
    }
}

