/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.runtimes.integration;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.as.runtimes.integration.Messages;
import org.jboss.tools.as.runtimes.integration.internal.DriverRuntimeLifecycleListener;
import org.jboss.tools.foundation.core.plugin.BaseCorePlugin;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ServerRuntimesIntegrationActivator
extends BaseCorePlugin {
    public static final String USAGE_COMPONENT_NAME = "server";
    public static final String USAGE_SERVER_ID_LABEL_DESCRIPTION = Messages.UsageEventTypeServerIDLabelDescription;
    private static final String DETECT_ACTION_NAME = "detect";
    public static final String PLUGIN_ID = "org.jboss.tools.as.runtimes.integration";
    private static BundleContext context;
    private static ServerRuntimesIntegrationActivator DEFAULT;
    private UsageEventType newDetectedServerEventType;
    private IRuntimeLifecycleListener driverListener;

    public static ServerRuntimesIntegrationActivator getDefault() {
        return DEFAULT;
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        DEFAULT = this;
        this.newDetectedServerEventType = new UsageEventType(USAGE_COMPONENT_NAME, UsageEventType.getVersion((Plugin)this), null, DETECT_ACTION_NAME, USAGE_SERVER_ID_LABEL_DESCRIPTION);
        UsageReporter.getInstance().registerEvent(this.newDetectedServerEventType);
        if (ServerRuntimesIntegrationActivator.isDtpPresent()) {
            this.driverListener = DriverRuntimeLifecycleListener.getDefault();
            ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.driverListener);
        }
    }

    private static boolean isDtpPresent() {
        String bundle1 = "org.eclipse.datatools.connectivity";
        String bundle2 = "org.eclipse.datatools.connectivity.db.generic";
        Bundle b1 = Platform.getBundle((String)bundle1);
        Bundle b2 = Platform.getBundle((String)bundle2);
        return b1 != null && b2 != null;
    }

    public void trackNewDetectedServerEvent(String serverTypeId) {
        UsageReporter.getInstance().trackEvent(this.newDetectedServerEventType.event(serverTypeId));
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        if (this.driverListener != null) {
            ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)this.driverListener);
            this.driverListener = null;
        }
    }

    public static IPluginLog pluginLog() {
        return ServerRuntimesIntegrationActivator.getDefault().pluginLogInternal();
    }
}

