/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.runtimes.integration.internal;

import java.util.ArrayList;
import org.eclipse.jdt.internal.debug.ui.jres.AddVMInstallWizard;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.runtime.core.model.IRuntimeDetectionResolution;
import org.jboss.tools.runtime.core.model.IRuntimeDetectionResolutionProvider;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimeDetectionProblem;

public class MissingJREProblemResolutionProvider
implements IRuntimeDetectionResolutionProvider {
    public static final String MIN_EXEC_ENV = "MIN_EXEC_ENV";
    public static final String MAX_EXEC_ENV = "MAX_EXEC_ENV";
    public static final int MISSING_JRE_CODE = 1337;

    public IRuntimeDetectionResolution[] getResolutions(RuntimeDetectionProblem problem, RuntimeDefinition def) {
        if (problem.getCode() != 1337) {
            return new IRuntimeDetectionResolution[0];
        }
        IRuntimeDetectionResolution r1 = new IRuntimeDetectionResolution(){

            public String getLabel() {
                return "Add JRE to Workspace";
            }

            public void run(RuntimeDetectionProblem problem, RuntimeDefinition definition) {
                VMStandin result;
                ResolutionWizard wiz = new ResolutionWizard(MissingJREProblemResolutionProvider.this.getWorkspaceJREs(), problem, definition);
                WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wiz);
                if (wd.open() == 0 && (result = wiz.getResult()) != null) {
                    result.convertToRealVM();
                }
            }
        };
        return new IRuntimeDetectionResolution[]{r1};
    }

    private String getDescriptionMessage(RuntimeDetectionProblem problem, RuntimeDefinition definition) {
        String max = null;
        String min = null;
        Object minExecEnv = problem.getProperty(MIN_EXEC_ENV);
        Object maxExecEnv = problem.getProperty(MAX_EXEC_ENV);
        if (minExecEnv != null && minExecEnv instanceof IExecutionEnvironment) {
            min = ((IExecutionEnvironment)minExecEnv).getId();
        }
        if (maxExecEnv != null && maxExecEnv instanceof IExecutionEnvironment) {
            max = ((IExecutionEnvironment)maxExecEnv).getId();
        }
        if (min == null && max == null) {
            return "Please add a JRE to your workspace.";
        }
        if (min == null) {
            return "Please add a JRE with maximum version " + max;
        }
        if (max == null) {
            return "Please add a JRE with minimum version " + min;
        }
        return "Please add a JRE with minimum version " + min + " and maximum version " + max;
    }

    protected IVMInstall[] getWorkspaceJREs() {
        ArrayList<IVMInstall> standins = new ArrayList<IVMInstall>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstallType type = types[i];
            IVMInstall[] installs = type.getVMInstalls();
            int j = 0;
            while (j < installs.length) {
                IVMInstall install = installs[j];
                standins.add(install);
                ++j;
            }
            ++i;
        }
        return standins.toArray(new IVMInstall[standins.size()]);
    }

    private class ResolutionWizard
    extends AddVMInstallWizard {
        RuntimeDetectionProblem problem;
        RuntimeDefinition definition;

        public ResolutionWizard(IVMInstall[] currentInstalls, RuntimeDetectionProblem problem, RuntimeDefinition definition) {
            super(currentInstalls);
            this.problem = null;
            this.definition = null;
            this.problem = problem;
            this.definition = definition;
        }

        public void addPages() {
            super.addPages();
            String msg = MissingJREProblemResolutionProvider.this.getDescriptionMessage(this.problem, this.definition);
            this.getStartingPage().setDescription(msg);
            this.getStartingPage().setTitle("Add a JRE");
        }

        public VMStandin getResult() {
            return super.getResult();
        }
    }
}

