/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.wtp.server.launchbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchObjectProvider;
import org.eclipse.launchbar.ui.controls.internal.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;
import org.jboss.tools.wtp.server.launchbar.objects.LaunchedArtifacts;
import org.jboss.tools.wtp.server.launchbar.objects.ModuleArtifactDetailsWrapper;
import org.jboss.tools.wtp.server.launchbar.objects.ModuleArtifactWrapper;
import org.jboss.tools.wtp.server.launchbar.objects.ModuleWrapper;

public class ModuleObjectProvider
implements ILaunchObjectProvider,
IResourceChangeListener,
ILaunchConfigurationListener,
ISelectionListener {
    private ILaunchBarManager manager;
    private HashMap<IProject, ModuleWrapper[]> knownModules;
    private ModuleArtifactWrapper mostRecent;
    private static String WTP_LAUNCH_TYPE = "org.eclipse.wst.server.ui.launchConfigurationType";

    public void init(ILaunchBarManager manager) throws CoreException {
        this.manager = manager;
        this.knownModules = new HashMap();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.resourceChanged(project, null);
            ++n2;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        ILaunchConfiguration[] all = this.getLaunchManager().getLaunchConfigurations();
        int i = 0;
        while (i < all.length) {
            if (all[i].getType().getIdentifier().equals(WTP_LAUNCH_TYPE)) {
                this.launchConfigurationAdded(all[i]);
            }
            ++i;
        }
        this.getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        this.delayedAddWorkbenchListener(this);
    }

    private void delayedAddWorkbenchListener(final ModuleObjectProvider provider) {
        new Job("Adding Workbench Selection Listener for server artifacts"){

            protected IStatus run(IProgressMonitor monitor) {
                long timeLimit = 300000L;
                long current = System.currentTimeMillis();
                long max = current + timeLimit;
                IWorkbenchWindow window = ModuleObjectProvider.this.syncGetActiveWorkbenchWindow();
                while (window == null && System.currentTimeMillis() < max) {
                    try {
                        System.out.println("*** sleeping 500");
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    window = ModuleObjectProvider.this.syncGetActiveWorkbenchWindow();
                }
                System.out.println("Loop over:  window=" + window);
                if (window != null) {
                    window.getSelectionService().addPostSelectionListener((ISelectionListener)provider);
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        }.schedule();
    }

    private IWorkbenchWindow syncGetActiveWorkbenchWindow() {
        final IWorkbenchWindow[] window = new IWorkbenchWindow[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                window[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
        });
        return window[0];
    }

    ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource res = delta.getResource();
                    if (res instanceof IProject) {
                        return ModuleObjectProvider.this.resourceChanged((IProject)res, delta);
                    }
                    return !(res instanceof IFile) && !(res instanceof IFolder);
                }
            });
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    private ModuleWrapper[] convert(IModule[] modules) {
        ArrayList<ModuleWrapper> list = new ArrayList<ModuleWrapper>();
        int i = 0;
        while (i < modules.length) {
            list.add(new ModuleWrapper(modules[i]));
            ++i;
        }
        return list.toArray(new ModuleWrapper[list.size()]);
    }

    private boolean resourceChanged(IProject project, IResourceDelta delta) throws CoreException {
        if (project == null) {
            return false;
        }
        IModule[] modules = ServerUtil.getModules((IProject)project);
        int kind = delta == null ? 1 : delta.getKind();
        ModuleWrapper[] known = this.knownModules.get(project);
        if ((kind & 1) != 0) {
            if (known != null) {
                this.alertRemoved(known);
            }
            ModuleWrapper[] newModules = this.convert(modules);
            this.alertAdded(newModules);
            this.knownModules.put(project, newModules);
        } else if ((kind & 2) != 0) {
            if (known != null) {
                this.alertRemoved(known);
            }
            this.knownModules.remove(project);
        } else if ((kind & 4) != 0) {
            ModuleWrapper[] newModules = this.convert(modules);
            this.handleChanged(known, newModules);
        }
        return false;
    }

    private void alertRemoved(ModuleWrapper[] all) throws CoreException {
        int i = 0;
        while (i < all.length) {
            this.manager.launchObjectRemoved((Object)all[i]);
            ++i;
        }
    }

    private void alertAdded(ModuleWrapper[] all) throws CoreException {
        int i = 0;
        while (i < all.length) {
            this.manager.launchObjectAdded((Object)all[i]);
            ++i;
        }
    }

    private void alertChanged(ModuleWrapper[] all) throws CoreException {
        int i = 0;
        while (i < all.length) {
            this.manager.launchObjectChanged((Object)all[i]);
            ++i;
        }
    }

    private void handleChanged(ModuleWrapper[] old, ModuleWrapper[] nnew) throws CoreException {
        if (old == null && nnew != null) {
            this.alertAdded(nnew);
        } else if (nnew == null && old != null) {
            this.alertRemoved(old);
        } else {
            ModuleWrapper[] missing = this.findMissing(old, nnew);
            ModuleWrapper[] added = this.findMissing(nnew, old);
            ArrayList<ModuleWrapper> changed = new ArrayList<ModuleWrapper>(Arrays.asList(nnew));
            changed.removeAll(Arrays.asList(added));
            changed.removeAll(Arrays.asList(missing));
            ModuleWrapper[] changedArray = changed.toArray(new ModuleWrapper[changed.size()]);
            this.alertAdded(added);
            this.alertRemoved(missing);
            this.alertChanged(changedArray);
        }
    }

    private ModuleWrapper[] findMissing(ModuleWrapper[] old, ModuleWrapper[] nnew) {
        ArrayList<ModuleWrapper> missing = new ArrayList<ModuleWrapper>();
        int i = 0;
        while (i < old.length) {
            if (!this.isPresent(old[i], nnew)) {
                missing.add(old[i]);
            }
            ++i;
        }
        return missing.toArray(new ModuleWrapper[missing.size()]);
    }

    private boolean isPresent(ModuleWrapper needle, ModuleWrapper[] haystack) {
        int i = 0;
        while (i < haystack.length) {
            if (needle.getModule().getId().equals(haystack[i].getModule().getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        try {
            String typeId = configuration.getType().getIdentifier();
            if (WTP_LAUNCH_TYPE.equals(typeId)) {
                ModuleArtifactDetailsWrapper wrap = this.getArtifactWrapperFor(configuration);
                this.manager.launchObjectAdded((Object)wrap);
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    private ModuleArtifactDetailsWrapper getArtifactWrapperFor(ILaunchConfiguration configuration) {
        String ATTR_SERVER_ID = "server-id";
        String ATTR_MODULE_ARTIFACT = "module-artifact";
        String ATTR_MODULE_ARTIFACT_CLASS = "module-artifact-class";
        String ATTR_LAUNCHABLE_ADAPTER_ID = "launchable-adapter-id";
        String ATTR_CLIENT_ID = "client-id";
        try {
            String artifact = configuration.getAttribute(ATTR_MODULE_ARTIFACT, null);
            String clazz = configuration.getAttribute(ATTR_MODULE_ARTIFACT_CLASS, null);
            if (artifact != null && clazz != null) {
                ModuleArtifactDetailsWrapper wrapper = new ModuleArtifactDetailsWrapper(configuration.getName(), artifact, clazz);
                return wrapper;
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return null;
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object o;
        IModuleArtifact[] moduleArtifacts;
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.launchbar.ui.controls");
        boolean enabled = store.getBoolean("enableLaunchBar");
        if (!enabled) {
            return;
        }
        if (selection instanceof IStructuredSelection && (moduleArtifacts = ServerPlugin.getModuleArtifacts((Object)(o = ((IStructuredSelection)selection).getFirstElement()))) != null && moduleArtifacts.length > 0) {
            ModuleArtifactWrapper tmp = null;
            int i = 0;
            while (i < moduleArtifacts.length && tmp != null) {
                if (this.canLoad(moduleArtifacts[i])) {
                    tmp = new ModuleArtifactWrapper(moduleArtifacts[i]);
                }
                ++i;
            }
            if (tmp != null) {
                if (this.mostRecent != null) {
                    try {
                        if (!LaunchedArtifacts.getDefault().hasBeenLaunched(this.mostRecent)) {
                            this.manager.launchObjectRemoved((Object)this.mostRecent);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                this.mostRecent = tmp;
                try {
                    this.manager.launchObjectAdded((Object)this.mostRecent);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean canLoad(IModuleArtifact artifact) {
        if (artifact instanceof ModuleArtifactDelegate) {
            try {
                Class<?> c = Class.forName(artifact.getClass().getName());
                if (c.newInstance() != null) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }
}

