/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Document;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.AntFileFilter;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XMLDocumentRepository;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathFileResult;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.resolvers.RuntimeVariableResolver;
import org.jboss.ide.eclipse.as.core.util.IMemento;
import org.jboss.tools.foundation.core.expressions.ExpressionResolver;
import org.jboss.tools.foundation.core.expressions.IVariableResolver;

public class XPathQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String baseDir;
    protected volatile String effectiveBaseDir;
    protected String filePattern;
    protected volatile String effectiveFilePattern;
    protected String xpathPattern;
    protected String attribute;
    protected transient AntFileFilter filter;
    protected transient XPathFileResult[] results;
    protected transient XPathCategory category;
    protected transient XMLDocumentRepository repository = null;
    protected IServer server;
    private long lastScanned = 0L;

    public XPathQuery(IMemento memento, IServer server) {
        this.server = server;
        this.name = memento.getString("name");
        this.baseDir = memento.getString("dir");
        this.filePattern = memento.getString("filePattern");
        this.xpathPattern = memento.getString("xpathPattern");
        this.attribute = memento.getString("attribute");
        this.setEffectiveBaseDir();
        this.setEffectiveFilePattern();
    }

    public XPathQuery(String name, List list) {
        this.name = name;
        this.baseDir = list.get(0).equals("org.jboss.ide.eclipse.as.core.model.descriptor.EmptyString") ? null : (String)list.get(0);
        this.filePattern = list.get(1).equals("org.jboss.ide.eclipse.as.core.model.descriptor.EmptyString") ? null : (String)list.get(1);
        this.xpathPattern = list.get(2).equals("org.jboss.ide.eclipse.as.core.model.descriptor.EmptyString") ? null : (String)list.get(2);
        this.attribute = list.size() < 3 || list.get(3).equals("org.jboss.ide.eclipse.as.core.model.descriptor.EmptyString") ? null : (String)list.get(3);
        this.setEffectiveBaseDir();
        this.setEffectiveFilePattern();
    }

    public XPathQuery(IServer server, String name, String baseDir, String filePattern, String xpathPattern, String attribute) {
        this.server = server;
        this.name = name;
        this.baseDir = baseDir;
        this.filePattern = filePattern;
        this.xpathPattern = xpathPattern;
        this.attribute = attribute;
        this.results = null;
        this.setEffectiveBaseDir();
        this.setEffectiveFilePattern();
    }

    private String getReplacedString(String original) {
        if (this.server != null) {
            RuntimeVariableResolver resolver = new RuntimeVariableResolver(this.server.getRuntime());
            ExpressionResolver process = new ExpressionResolver((IVariableResolver)resolver);
            return process.resolve(original);
        }
        return original;
    }

    private void setEffectiveBaseDir() {
        Path dir;
        IRuntime rt = this.server == null ? null : this.server.getRuntime();
        String dir1 = this.baseDir == null ? null : this.baseDir;
        String dir2 = this.getReplacedString(dir1);
        Path path = dir = dir2 == null ? null : new Path(dir2);
        if (this.category != null && rt != null) {
            if (dir == null) {
                dir = rt.getLocation();
            }
            if (dir != null && !dir.isAbsolute() && rt.getLocation() != null) {
                dir = rt.getLocation().append((IPath)dir);
            }
        }
        this.effectiveBaseDir = dir == null ? null : dir.toString();
    }

    private void setEffectiveFilePattern() {
        String pattern2;
        String pattern = this.filePattern == null ? null : this.filePattern;
        this.effectiveFilePattern = pattern2 = this.getReplacedString(pattern);
    }

    protected AntFileFilter getFilter() {
        if (this.filter == null) {
            this.filter = new AntFileFilter(this.effectiveBaseDir, this.effectiveFilePattern);
        }
        return this.filter;
    }

    public void refresh() {
        String[] files = this.getFilter().getIncludedFiles();
        boolean changed = false;
        int i = 0;
        while (i < files.length) {
            IPath fullPath = new Path(this.effectiveBaseDir).append(files[i]);
            this.getRepository().refresh(fullPath.toOSString());
            changed = changed || this.getRepository().hasChangedSince(fullPath.toOSString(), this.lastScanned);
            ++i;
        }
        if (changed) {
            this.results = null;
        }
        this.lastScanned = System.currentTimeMillis();
    }

    public String[] getPossibleFileMatches() {
        return this.getFilter().getIncludedFiles();
    }

    public XPathFileResult[] getResults() {
        if (this.results == null) {
            this.loadResults();
        }
        return this.results;
    }

    public void clearCache() {
        this.results = null;
        this.filter = null;
        this.setEffectiveBaseDir();
        this.setEffectiveFilePattern();
        this.refresh();
    }

    public boolean resultsLoaded() {
        return this.results != null;
    }

    protected void loadResults() {
        try {
            String[] files = this.getFilter().getIncludedFiles();
            ArrayList<XPathFileResult> resultList = new ArrayList<XPathFileResult>();
            List nodeList = null;
            int i = 0;
            while (i < files.length) {
                String fileLoc = new Path(this.effectiveBaseDir).append(files[i]).toOSString();
                Document d = this.getRepository().getDocument(fileLoc);
                if (d != null) {
                    Dom4jXPath xpath = new Dom4jXPath(this.xpathPattern);
                    Properties map = XPathModel.getDefault().getNamespaceMap();
                    xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext((Map)map));
                    List nodes = xpath.selectNodes((Object)d);
                    nodeList = xpath.selectNodes((Object)d);
                }
                if (nodeList != null && nodeList.size() > 0) {
                    resultList.add(new XPathFileResult(this, fileLoc, nodeList));
                }
                ++i;
            }
            this.results = resultList.toArray(new XPathFileResult[resultList.size()]);
        }
        catch (IllegalStateException ise) {
            this.results = new XPathFileResult[0];
        }
        catch (JaxenException je) {
            this.results = new XPathFileResult[0];
        }
    }

    public String getFirstResult() {
        XPathFileResult.XPathResultNode[] nodes;
        XPathFileResult[] fileResults = this.getResults();
        if (fileResults.length > 0 && (nodes = fileResults[0].getChildren()).length > 0) {
            return nodes[0].getText();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.category != null) {
            this.category.renameQuery(this.name, name);
        }
        this.name = name;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getXpathPattern() {
        return this.xpathPattern;
    }

    public void setXpathPattern(String xpathPattern) {
        this.xpathPattern = xpathPattern;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        this.setEffectiveBaseDir();
    }

    public XPathCategory getCategory() {
        return this.category;
    }

    public void setCategory(XPathCategory category) {
        boolean hadCategory = this.category != null;
        this.category = category;
        if (!hadCategory) {
            this.setEffectiveBaseDir();
        }
    }

    public void setRepository(XMLDocumentRepository repo) {
        this.repository = repo;
    }

    public XMLDocumentRepository getRepository() {
        return this.repository == null ? XMLDocumentRepository.getDefault() : this.repository;
    }
}

