/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.tools.as.core.server.controllable.systems.IPortsController;
import org.jboss.tools.foundation.core.expressions.ExpressionResolver;

public class XPathsPortsController
extends AbstractSubsystemController
implements IPortsController {
    public static final String JNDI_PORT = "org.jboss.ide.eclipse.as.core.server.jndiPort";
    public static final String JNDI_PORT_DETECT = "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect";
    public static final String JNDI_PORT_DETECT_XPATH = "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect.XPath";
    public static final String JNDI_PORT_DEFAULT_XPATH = "Ports/JNDI";
    public static final int JNDI_DEFAULT_PORT = 1099;
    public static final String WEB_PORT = "org.jboss.ide.eclipse.as.core.server.webPort";
    public static final String WEB_PORT_DETECT = "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect";
    public static final String WEB_PORT_DETECT_XPATH = "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect.XPath";
    public static final String WEB_PORT_DEFAULT_XPATH = "Ports/JBoss Web";
    public static final int JBOSS_WEB_DEFAULT_PORT = 8080;
    public static final String AS7_MANAGEMENT_PORT = "org.jboss.ide.eclipse.as.core.server.as7.managementPort";
    public static final String AS7_MANAGEMENT_PORT_DETECT = "org.jboss.ide.eclipse.as.core.server.as7.managementPortAutoDetect";
    public static final String AS7_MANAGEMENT_PORT_DETECT_XPATH = "org.jboss.ide.eclipse.as.core.server.as7.managementPortAutoDetect.XPath";
    public static final String AS7_MANAGEMENT_PORT_DEFAULT_XPATH = "Ports/JBoss Management";
    public static final int AS7_MANAGEMENT_PORT_DEFAULT_PORT = 9999;
    public static final int WILDFLY8_MANAGEMENT_PORT_DEFAULT_PORT = 9990;
    public static final String PORT_OFFSET_KEY = "org.jboss.ide.eclipse.as.core.server.portOffset";
    public static final String PORT_OFFSET_DETECT = "org.jboss.ide.eclipse.as.core.server.portOffsetAutoDetect";
    public static final String PORT_OFFSET_DETECT_XPATH = "org.jboss.ide.eclipse.as.core.server.portOffsetAutoDetect.XPath";
    public static final String PORT_OFFSET_DEFAULT_XPATH = "Ports/Port Offset";
    public static final int PORT_OFFSET_DEFAULT_PORT = 0;
    public static final String JMX_RMI_PORT = "org.jboss.ide.eclipse.as.core.server.jmxrmiport";
    public static final String JMX_RMI_PORT_DETECT = "org.jboss.ide.eclipse.as.core.server.jmxrmiport_AutoDetect";
    public static final String JMX_RMI_PORT_DETECT_XPATH = "org.jboss.ide.eclipse.as.core.server.jmxrmiport_AutoDetect.XPath";
    public static final String JMX_RMI_PORT_DEFAULT_XPATH = "Ports/JMX RMI Port";
    public static final int JMX_RMI_DEFAULT_PORT = 1090;

    @Override
    public int findPort(int id, int defaultVal) {
        switch (id) {
            case 103: {
                return this.getJMXRMIPort(defaultVal);
            }
            case 100: {
                return this.getJNDIPort(defaultVal);
            }
            case 101: {
                return this.getJBossWebPort(defaultVal);
            }
            case 104: {
                return this.getManagementPort(defaultVal);
            }
            case 102: {
                return this.getPortOffset(defaultVal);
            }
        }
        return 0;
    }

    protected boolean automaticallyDetect(String attributeKey, String detectKey) {
        return this.getServer().getAttribute(detectKey, true);
    }

    protected int findPort(String attributeKey, String detectKey, String xpathKey, String defaultXPath, int defaultValue) {
        boolean detect = this.automaticallyDetect(attributeKey, detectKey);
        String result = null;
        if (!detect) {
            result = this.getServer().getAttribute(attributeKey, null);
        } else {
            XPathQuery query;
            String xpath = this.getServer().getAttribute(xpathKey, defaultXPath);
            if (this.getServer().getRuntime() != null && (query = XPathModel.getDefault().getQuery(this.getServer(), (IPath)new Path(xpath))) != null) {
                query.refresh();
                result = query.getFirstResult();
            }
        }
        if (result != null) {
            result = this.resolveXPathResult(result);
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    protected String resolveXPathResult(String result) {
        return new ExpressionResolver().resolveIgnoreErrors(result);
    }

    private int getJNDIPort(int defaultVal) {
        return this.getPortOffset(0) + this.findPort(JNDI_PORT, JNDI_PORT_DETECT, JNDI_PORT_DETECT_XPATH, JNDI_PORT_DEFAULT_XPATH, defaultVal);
    }

    private int getJBossWebPort(int defaultVal) {
        return this.getPortOffset(0) + this.findPort(WEB_PORT, WEB_PORT_DETECT, WEB_PORT_DETECT_XPATH, WEB_PORT_DEFAULT_XPATH, defaultVal);
    }

    private int getManagementPort(int defaultVal) {
        return this.getPortOffset(0) + this.findPort(AS7_MANAGEMENT_PORT, AS7_MANAGEMENT_PORT_DETECT, AS7_MANAGEMENT_PORT_DETECT_XPATH, AS7_MANAGEMENT_PORT_DEFAULT_XPATH, defaultVal);
    }

    private int getJMXRMIPort(int defaultVal) {
        return this.findPort(JMX_RMI_PORT, JMX_RMI_PORT_DETECT, JMX_RMI_PORT_DETECT_XPATH, JMX_RMI_PORT_DEFAULT_XPATH, defaultVal);
    }

    private int getPortOffset(int defaultVal) {
        return this.findPort(PORT_OFFSET_KEY, PORT_OFFSET_DETECT, PORT_OFFSET_DETECT_XPATH, PORT_OFFSET_DEFAULT_XPATH, defaultVal);
    }
}

