/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.behavior.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllerEnvironment;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishControllerDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.SubsystemModel;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;

public class PublishControllerUtil {
    public static final int NO_PUBLISH = 0;
    public static final int INCREMENTAL_PUBLISH = 1;
    public static final int FULL_PUBLISH = 2;
    public static final int REMOVE_PUBLISH = 3;

    public static int getPublishType(IServer server, IModule[] module, int kind, int deltaKind) {
        int modulePublishState = server.getModulePublishState(module);
        if (deltaKind == 1) {
            return 2;
        }
        if (deltaKind == 3) {
            return 3;
        }
        if (kind == 2 || modulePublishState == 3 || kind == 4) {
            return 2;
        }
        if ((kind == 1 || modulePublishState == 2 || kind == 3) && 2 == deltaKind) {
            return 1;
        }
        return 0;
    }

    public static int getDeepPublishType(IServer server, IModule root, int kind, int deltaKind) {
        List<Integer> allDelta;
        int publishType = PublishControllerUtil.getPublishType(server, new IModule[]{root}, kind, deltaKind);
        if (publishType == 3) {
            return 3;
        }
        List<IModule[]> deepModules = PublishControllerUtil.getAllModulesFromRoot(server, root);
        if (PublishControllerUtil.structureChanged(server, root, deepModules, allDelta = PublishControllerUtil.computeDelta(server, deepModules))) {
            return 2;
        }
        Iterator<IModule[]> modIt = deepModules.iterator();
        Iterator<Integer> deltIt = allDelta.iterator();
        while (modIt.hasNext()) {
            IModule[] tmp = modIt.next();
            int type2 = PublishControllerUtil.getPublishType(server, tmp, kind, deltIt.next());
            if (type2 <= publishType) continue;
            publishType = type2;
        }
        return publishType;
    }

    public static IPublishControllerDelegate findDelegatePublishController(IServer server, IModule[] module, boolean global) {
        String systemName = "publishDelegate";
        String typeId = module[module.length - 1].getModuleType().getId();
        ControllerEnvironment env = new ControllerEnvironment();
        env.addRequiredProperty(systemName, "moduleType:" + typeId, "true");
        try {
            ISubsystemController c = SubsystemModel.getInstance().createSubsystemController((IServerAttributes)server, systemName, env.getMap());
            return (IPublishControllerDelegate)c;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static List<IModule[]> getAllModulesFromRoot(IServer server, IModule root) {
        ArrayList<IModule[]> deepModules = ServerModelUtilities.getDeepChildren(server, new IModule[]{root});
        deepModules.add(new IModule[]{root});
        PublishControllerUtil.addRemovedModules(server, deepModules, null);
        Iterator<IModule[]> it2 = deepModules.iterator();
        while (it2.hasNext()) {
            IModule[] tmp = it2.next();
            if (tmp != null && tmp.length != 0 && tmp[0].equals(root)) continue;
            it2.remove();
        }
        return deepModules;
    }

    public static boolean structureChanged(IServer server, IModule root) {
        List<IModule[]> deepModules = PublishControllerUtil.getAllModulesFromRoot(server, root);
        List<Integer> allDelta = PublishControllerUtil.computeDelta(server, deepModules);
        return PublishControllerUtil.structureChanged(server, root, deepModules, allDelta);
    }

    private static boolean structureChanged(IServer server, IModule root, List<IModule[]> deepModules, List<Integer> allDelta) {
        for (int i : allDelta) {
            if (i != 1 && i != 3) continue;
            return true;
        }
        return false;
    }

    private static List<Integer> computeDelta(IServer server, List<IModule[]> moduleList) {
        return PublishControllerUtil.computeDelta(server, moduleList, false);
    }

    private static List<Integer> computeDelta(IServer server, List<IModule[]> moduleList, boolean includeRemoved) {
        ArrayList<Integer> deltaKindList = new ArrayList<Integer>();
        for (IModule[] module : moduleList) {
            if (PublishControllerUtil.hasBeenPublished(server, module)) {
                IModule m = module[module.length - 1];
                if (m.getProject() != null && !m.getProject().isAccessible() || PublishControllerUtil.getPublishedResourceDelta(server, module).length == 0) {
                    deltaKindList.add(new Integer(0));
                    continue;
                }
                deltaKindList.add(new Integer(2));
                continue;
            }
            deltaKindList.add(new Integer(1));
        }
        if (includeRemoved) {
            PublishControllerUtil.addRemovedModules(server, moduleList, null);
            while (deltaKindList.size() < moduleList.size()) {
                deltaKindList.add(new Integer(3));
            }
        }
        return deltaKindList;
    }

    protected static boolean hasBeenPublished(IServer server, IModule[] module) {
        return ((Server)server).getServerPublishInfo().hasModulePublishInfo(module);
    }

    protected static IModuleResourceDelta[] getPublishedResourceDelta(IServer server, IModule[] module) {
        return ((Server)server).getPublishedResourceDelta(module);
    }

    protected static void addRemovedModules(IServer server, List<IModule[]> moduleList, List<Integer> kindList) {
        ((Server)server).getServerPublishInfo().addRemovedModules(moduleList);
    }
}

