/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.download;

import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.exception.WaitTimeoutExpiredException;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.exception.CoreLayerException;
import org.jboss.reddeer.swt.impl.button.CancelButton;
import org.jboss.reddeer.swt.impl.progressbar.DefaultProgressBar;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.swt.impl.text.DefaultText;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.as.ui.bot.itests.download.RuntimeDownloadTestUtility;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.DisableSecureStorageRequirement;
import org.junit.Assert;
import org.junit.Test;

@DisableSecureStorageRequirement.DisableSecureStorage
public class InvalidCredentialProductDownloadTest {
    @Test
    public void useInvalidCredentials() {
        RuntimeDownloadTestUtility util = new RuntimeDownloadTestUtility();
        util.invokeDownloadRuntimesWizard();
        util.processSelectingRuntime("JBoss EAP 6.2.0");
        util.processInsertingCredentials("Invalid username", "Invalid password");
        new WaitWhile((WaitCondition)new ValidatingCredentialsProgressBarIsRunning());
        this.assertErrorMessageIsShown();
        new DefaultShell("Download Runtimes");
        new CancelButton().click();
        new WorkbenchPreferenceDialog().ok();
    }

    private void assertErrorMessageIsShown() {
        try {
            new WaitUntil((WaitCondition)new ErrorMessageIsShown());
        }
        catch (WaitTimeoutExpiredException e) {
            e.printStackTrace();
            Assert.fail((String)("Error message was not shown. " + e.getMessage()));
        }
    }

    private class ErrorMessageIsShown
    implements WaitCondition {
        private ErrorMessageIsShown() {
        }

        public boolean test() {
            try {
                new DefaultText(" Your credentials are incorrect. Please review the values and try again.");
                return true;
            }
            catch (CoreLayerException coreLayerException) {
                return false;
            }
        }

        public String errorMessage() {
            return "error message was not shown.";
        }

        public String description() {
            return "error message is shown.";
        }
    }

    private class ValidatingCredentialsProgressBarIsRunning
    implements WaitCondition {
        private ValidatingCredentialsProgressBarIsRunning() {
        }

        public boolean test() {
            try {
                new DefaultProgressBar("Validating Credentials");
                return true;
            }
            catch (CoreLayerException coreLayerException) {
                return false;
            }
        }

        public String description() {
            return "Validating Credentials progress bar is running";
        }

        public String errorMessage() {
            return "Validating Credentials progress bar is not running";
        }
    }
}

